/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.maps.loaders;

import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;

public interface ImageResolver {
    public TextureRegion getImage(String var1);

    public static class TextureAtlasImageResolver
    implements ImageResolver {
        private final TextureAtlas atlas;

        public TextureAtlasImageResolver(TextureAtlas atlas) {
            this.atlas = atlas;
        }

        @Override
        public TextureRegion getImage(String name) {
            return this.atlas.find(name);
        }
    }

    public static class AssetManagerImageResolver
    implements ImageResolver {
        private final AssetManager assetManager;

        public AssetManagerImageResolver(AssetManager assetManager) {
            this.assetManager = assetManager;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.assetManager.get(name, Texture.class));
        }
    }

    public static class DirectImageResolver
    implements ImageResolver {
        private final ObjectMap<String, Texture> images;

        public DirectImageResolver(ObjectMap<String, Texture> images) {
            this.images = images;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.images.get(name));
        }
    }
}

