/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math;

public class Extrapolator {
    private float[] snapPos;
    private float[] snapVel;
    private float[] aimPos;
    private float[] lastPacketPos;
    private float[] tmpArr;
    private float[] tmpArr2;
    private double snapTime;
    private double aimTime;
    private double lastPacketTime;
    private double latency;
    private double updateTime;
    private int size;

    public Extrapolator(int size) {
        this.size = size;
        this.snapPos = new float[size];
        this.snapVel = new float[size];
        this.aimPos = new float[size];
        this.lastPacketPos = new float[size];
        this.tmpArr = new float[size];
        this.tmpArr2 = new float[size];
    }

    public boolean addSample(double packetTime, double curTime, float[] pos) {
        float[] vel = this.tmpArr2;
        if (Math.abs(packetTime - this.lastPacketTime) > 1.0E-4) {
            double dt = 1.0 / (packetTime - this.lastPacketTime);
            for (int i = 0; i < this.size; ++i) {
                vel[i] = (float)((double)(pos[i] - this.lastPacketPos[i]) * dt);
            }
        } else {
            this.clear(vel);
        }
        return this.addSample(packetTime, curTime, pos, vel);
    }

    public boolean addSample(double packetTime, double curTime, float[] pos, float[] vel) {
        int i;
        if (!this.estimates(packetTime, curTime)) {
            return false;
        }
        this.copyArray(this.lastPacketPos, pos);
        this.lastPacketTime = packetTime;
        this.readPosition(curTime, this.snapPos);
        this.aimTime = curTime + this.updateTime;
        double dt = this.aimTime - packetTime;
        this.snapTime = curTime;
        for (i = 0; i < this.size; ++i) {
            this.aimPos[i] = (float)((double)pos[i] + (double)vel[i] * dt);
        }
        if (Math.abs(this.aimTime - this.snapTime) < 1.0E-4) {
            this.copyArray(this.snapVel, vel);
        } else {
            dt = 1.0 / (this.aimTime - this.snapTime);
            for (i = 0; i < this.size; ++i) {
                this.snapVel[i] = (float)((double)(this.aimPos[i] - this.snapPos[i]) * dt);
            }
        }
        return true;
    }

    public boolean addSample(double packetTime, double curTime, float pos) {
        this.checkArraySizeOne();
        this.tmpArr[0] = pos;
        return this.addSample(packetTime, curTime, this.tmpArr);
    }

    public boolean addSample(double packetTime, double curTime, float pos, float vel) {
        this.checkArraySizeOne();
        this.tmpArr[0] = pos;
        this.tmpArr2[0] = vel;
        return this.addSample(packetTime, curTime, this.tmpArr, this.tmpArr2);
    }

    public void reset(double packetTime, double curTime, float[] pos) {
        this.reset(packetTime, curTime, pos, this.clear(this.tmpArr));
    }

    public void reset(double packetTime, double curTime, float[] pos, float[] vel) {
        this.lastPacketTime = packetTime;
        this.copyArray(this.lastPacketPos, pos);
        this.snapTime = curTime;
        this.copyArray(this.snapPos, pos);
        this.latency = this.updateTime = curTime - packetTime;
        this.aimTime = curTime + this.updateTime;
        this.copyArray(this.snapVel, vel);
        for (int i = 0; i < this.size; ++i) {
            this.aimPos[i] = (float)((double)this.snapPos[i] + (double)this.snapVel[i] * this.updateTime);
        }
    }

    public void reset(double packetTime, double curTime, float pos) {
        this.checkArraySizeOne();
        this.reset(packetTime, curTime, pos, 0.0f);
    }

    public void reset(double packetTime, double curTime, float pos, float vel) {
        this.checkArraySizeOne();
        this.lastPacketTime = packetTime;
        this.lastPacketPos[0] = pos;
        this.snapTime = curTime;
        this.snapPos[0] = pos;
        this.latency = this.updateTime = curTime - packetTime;
        this.aimTime = curTime + this.updateTime;
        this.snapVel[0] = vel;
        this.aimPos[0] = (float)((double)this.snapPos[0] + (double)this.snapVel[0] * this.updateTime);
    }

    public boolean readPosition(double forTime, float[] outPos) {
        return this.readPosition(forTime, outPos, null);
    }

    public boolean readPosition(double forTime, float[] outPos, float[] outVel) {
        double maxRange;
        boolean isOk = true;
        if (forTime < this.snapTime) {
            forTime = this.snapTime;
            isOk = false;
        }
        if (forTime > (maxRange = this.aimTime + this.updateTime)) {
            forTime = maxRange;
            isOk = false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (outVel != null) {
                outVel[i] = this.snapVel[i];
            }
            outPos[i] = (float)((double)this.snapPos[i] + (double)this.snapVel[i] * (forTime - this.snapTime));
        }
        if (!isOk && outVel != null) {
            this.clear(outVel);
        }
        return isOk;
    }

    public float readPosition(double forTime) {
        this.checkArraySizeOne();
        if (this.readPosition(forTime, this.tmpArr)) {
            return this.tmpArr[0];
        }
        return 0.0f;
    }

    public double estimateLatency() {
        return this.latency;
    }

    public double estimateUpdateTime() {
        return this.updateTime;
    }

    private boolean estimates(double packet, double cur) {
        if (packet <= this.lastPacketTime) {
            return false;
        }
        double lat = cur - packet;
        if (lat < 0.0) {
            lat = 0.0;
        }
        this.latency = lat > this.latency ? (this.latency + lat) * 0.5 : (this.latency * 7.0 + lat) * 0.125;
        double tick = packet - this.lastPacketTime;
        this.updateTime = tick > this.updateTime ? (this.updateTime + tick) * 0.5 : (this.updateTime * 7.0 + tick) * 0.125;
        return true;
    }

    private float[] clear(float[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = 0.0f;
        }
        return arr;
    }

    private void copyArray(float[] dest, float[] src) {
        for (float dest[i] : src) {
        }
    }

    private void checkArraySizeOne() {
        if (this.size != 1) {
            throw new UnsupportedOperationException("This function should be called only when size = 1!");
        }
    }
}

