/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.math;

import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.util.Time;
import java.util.Random;

public final class Mathf {
    public static final int[] signs = new int[]{-1, 1};
    public static final boolean[] booleans = new boolean[]{true, false};
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float E = (float)Math.E;
    public static final float sqrt2 = Mathf.sqrt(2.0f);
    public static final float sqrt3 = Mathf.sqrt(3.0f);
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final RandomXS128 seedr = new RandomXS128();
    public static Random random = new RandomXS128();

    public static float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float absin(float scl, float mag) {
        return Mathf.absin(Time.time(), scl, mag);
    }

    public static float absin(float in, float scl, float mag) {
        return (Mathf.sin(in, scl * 2.0f, mag) + mag) / 2.0f;
    }

    public static float tan(float radians, float scl, float mag) {
        return Mathf.sin(radians / scl) / Mathf.cos(radians / scl) * mag;
    }

    public static float sin(float scl, float mag) {
        return Mathf.sin(Time.time() / scl) * mag;
    }

    public static float sin(float radians, float scl, float mag) {
        return Mathf.sin(radians / scl) * mag;
    }

    public static float cos(float radians, float scl, float mag) {
        return Mathf.cos(radians / scl) * mag;
    }

    public static float angle(float x, float y) {
        float result = Mathf.atan2(x, y) * 57.295776f;
        if (result < 0.0f) {
            result += 360.0f;
        }
        return result;
    }

    public static float atan2(float x, float y) {
        if (Math.abs(x) < 1.0E-7f) {
            if (y > 0.0f) {
                return 1.5707964f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float z = y / x;
        if (Math.abs(z) < 1.0f) {
            float atan = z / (1.0f + 0.28f * z * z);
            if (x < 0.0f) {
                return atan + (y < 0.0f ? (float)(-Math.PI) : (float)Math.PI);
            }
            return atan;
        }
        float atan = 1.5707964f - z / (z * z + 0.28f);
        return y < 0.0f ? atan - (float)Math.PI : atan;
    }

    public static float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static int sign(float f) {
        return f < 0.0f ? -1 : 1;
    }

    public static int sign(boolean b) {
        return b ? 1 : -1;
    }

    public static int num(boolean b) {
        return b ? 1 : 0;
    }

    public static float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static float range(float range) {
        return Mathf.random(-range, range);
    }

    public static int range(int range) {
        return Mathf.random(-range, range);
    }

    public static float range(float min, float max) {
        if (Mathf.chance(0.5)) {
            return Mathf.random(min, max);
        }
        return -Mathf.random(min, max);
    }

    public static boolean chance(double d) {
        return (double)random.nextFloat() < d;
    }

    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static long random(long range) {
        return (long)(random.nextDouble() * (double)range);
    }

    public static long random(long start, long end) {
        return start + (long)(random.nextDouble() * (double)(end - start));
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float chance) {
        return Mathf.random() < chance;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float range) {
        return random.nextFloat() * range;
    }

    public static float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static int randomSeed(long seed, int min, int max) {
        seedr.setSeed(seed);
        if (Mathf.isPowerOfTwo(max)) {
            seedr.nextInt();
        }
        return seedr.nextInt(max - min + 1) + min;
    }

    public static float randomSeed(long seed) {
        seedr.setSeed(seed * 99999L);
        return seedr.nextFloat();
    }

    public static float randomSeedRange(long seed, float range) {
        seedr.setSeed(seed * 99999L);
        return range * (seedr.nextFloat() - 0.5f) * 2.0f;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float max) {
        return (random.nextFloat() - random.nextFloat()) * max;
    }

    public static float randomTriangular(float min, float max) {
        return Mathf.randomTriangular(min, max, (min + max) * 0.5f);
    }

    public static float randomTriangular(float min, float max, float mode) {
        float d;
        float u = random.nextFloat();
        if (u <= (mode - min) / (d = max - min)) {
            return min + (float)Math.sqrt(u * d * (mode - min));
        }
        return max - (float)Math.sqrt((1.0f - u) * d * (max - mode));
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value) {
        return Mathf.clamp(value, 0.0f, 1.0f);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float lerp(float fromValue, float toValue, float progress) {
        return fromValue + (toValue - fromValue) * progress;
    }

    public static float lerpDelta(float fromValue, float toValue, float progress) {
        return Mathf.lerp(fromValue, toValue, Mathf.clamp(progress * Time.delta()));
    }

    public static float slerpRad(float fromRadians, float toRadians, float progress) {
        float delta = (toRadians - fromRadians + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (fromRadians + delta * progress + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float slerp(float fromDegrees, float toDegrees, float progress) {
        float delta = (toDegrees - fromDegrees + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (fromDegrees + delta * progress + 360.0f) % 360.0f;
    }

    public static float slerpDelta(float fromDegrees, float toDegrees, float progress) {
        return Mathf.slerp(fromDegrees, toDegrees, Mathf.clamp(progress * Time.delta()));
    }

    public static int floor(float value) {
        return (int)((double)value + 16384.0) - 16384;
    }

    public static int floorPositive(float value) {
        return (int)value;
    }

    public static int ceil(float value) {
        return 16384 - (int)(16384.0 - (double)value);
    }

    public static int ceilPositive(float value) {
        return (int)((double)value + 0.9999999);
    }

    public static int round(float value) {
        return (int)((double)value + 16384.5) - 16384;
    }

    public static float round(float value, float amount) {
        return (float)((int)(value / amount)) * amount;
    }

    public static int roundPositive(float value) {
        return (int)(value + 0.5f);
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static float log(float a, float value) {
        return (float)(Math.log(value) / Math.log(a));
    }

    public static float log2(float value) {
        return (float)Math.log(value) / 0.30103f;
    }

    public static float mod(float x, float n) {
        return (x % n + n) % n;
    }

    public static int mod(int x, int n) {
        return (x % n + n) % n;
    }

    public static float curve(float f, float offset) {
        if (f < offset) {
            return 0.0f;
        }
        return (f - offset) / (1.0f - offset);
    }

    public static float curve(float f, float offset, float to) {
        if (f < offset) {
            return 0.0f;
        }
        if (f - offset > to) {
            return 1.0f;
        }
        return (f - offset) / to;
    }

    public static float len(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    public static float len2(float x, float y) {
        return x * x + y * y;
    }

    public static float dot(float x1, float y1, float x2, float y2) {
        return x1 * x2 + y1 * y2;
    }

    public static float dst(float x1, float y1) {
        return (float)Math.sqrt(x1 * x1 + y1 * y1);
    }

    public static float dst2(float x1, float y1) {
        return x1 * x1 + y1 * y1;
    }

    public static float dst(float x1, float y1, float x2, float y2) {
        float x_d = x2 - x1;
        float y_d = y2 - y1;
        return (float)Math.sqrt(x_d * x_d + y_d * y_d);
    }

    public static float dst2(float x1, float y1, float x2, float y2) {
        float x_d = x2 - x1;
        float y_d = y2 - y1;
        return x_d * x_d + y_d * y_d;
    }

    public static boolean within(float x1, float y1, float x2, float y2, float dst) {
        return Mathf.dst2(x1, y1, x2, y2) < dst * dst;
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }
}

