/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.net;

import io.anuke.arc.net.Connection;
import io.anuke.arc.net.DcReason;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public interface NetListener {
    default public void connected(Connection connection) {
    }

    default public void disconnected(Connection connection, DcReason reason) {
    }

    default public void received(Connection connection, Object object) {
    }

    default public void idle(Connection connection) {
    }

    public static class LagListener
    extends QueuedListener {
        private final ScheduledExecutorService threadPool;
        private final int lagMillisMin;
        private final int lagMillisMax;
        final LinkedList<Runnable> runnables = new LinkedList();

        public LagListener(int lagMillisMin, int lagMillisMax, NetListener listener) {
            super(listener);
            this.lagMillisMin = lagMillisMin;
            this.lagMillisMax = lagMillisMax;
            this.threadPool = Executors.newScheduledThreadPool(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queue(Runnable runnable) {
            LinkedList<Runnable> linkedList = this.runnables;
            synchronized (linkedList) {
                this.runnables.addFirst(runnable);
            }
            int lag = this.lagMillisMin + (int)(Math.random() * (double)(this.lagMillisMax - this.lagMillisMin));
            this.threadPool.schedule(() -> {
                Runnable runnable1;
                LinkedList<Runnable> linkedList = this.runnables;
                synchronized (linkedList) {
                    runnable1 = this.runnables.removeLast();
                }
                runnable1.run();
            }, (long)lag, TimeUnit.MILLISECONDS);
        }
    }

    public static class ThreadedListener
    extends QueuedListener {
        protected final ExecutorService threadPool;

        public ThreadedListener(NetListener listener) {
            this(listener, Executors.newFixedThreadPool(1));
        }

        public ThreadedListener(NetListener listener, ExecutorService threadPool) {
            super(listener);
            if (threadPool == null) {
                throw new IllegalArgumentException("threadPool cannot be null.");
            }
            this.threadPool = threadPool;
        }

        @Override
        public void queue(Runnable runnable) {
            this.threadPool.execute(runnable);
        }
    }

    public static abstract class QueuedListener
    implements NetListener {
        final NetListener listener;

        public QueuedListener(NetListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener cannot be null.");
            }
            this.listener = listener;
        }

        @Override
        public void connected(Connection connection) {
            this.queue(() -> this.listener.connected(connection));
        }

        @Override
        public void disconnected(Connection connection, DcReason reason) {
            this.queue(() -> this.listener.disconnected(connection, reason));
        }

        @Override
        public void received(Connection connection, Object object) {
            this.queue(() -> this.listener.received(connection, object));
        }

        @Override
        public void idle(Connection connection) {
            this.queue(() -> this.listener.idle(connection));
        }

        protected abstract void queue(Runnable var1);
    }
}

