/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.DelayedRemovalArray;
import io.anuke.arc.collection.SnapshotArray;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.PositionConsumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.ScissorStack;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.Scene;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.ChangeListener;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.EventListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.SceneEvent;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.utils.Disableable;
import io.anuke.arc.scene.utils.Layout;
import io.anuke.arc.util.pooling.Pools;

public class Element
implements Layout {
    public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final DelayedRemovalArray<EventListener> listeners = new DelayedRemovalArray(0);
    private final DelayedRemovalArray<EventListener> captureListeners = new DelayedRemovalArray(0);
    private final Array<Action> actions = new Array(0);
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected float parentAlpha = 1.0f;
    protected Vector2 translation = new Vector2(0.0f, 0.0f);
    Group parent;
    float originX;
    float originY;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float rotation;
    private Scene stage;
    private String name;
    private Touchable touchable = Touchable.enabled;
    private boolean visible = true;
    private Object userObject;
    private boolean needsLayout = true;
    protected boolean fillParent;
    private boolean layoutEnabled = true;
    private BooleanProvider visibility;
    private Runnable update;
    private Supplier<Touchable> touchableSupplier = null;

    public void draw() {
        this.validate();
    }

    public void act(float delta) {
        Array<Action> actions = this.actions;
        if (actions.size > 0) {
            if (this.stage != null && this.stage.getActionsRequestRendering()) {
                Core.graphics.requestRendering();
            }
            for (int i = 0; i < actions.size; ++i) {
                int actionIndex;
                Action action = actions.get(i);
                if (!action.act(delta) || i >= actions.size) continue;
                Action current = actions.get(i);
                int n = actionIndex = current == action ? i : actions.indexOf(action, true);
                if (actionIndex == -1) continue;
                actions.remove(actionIndex);
                action.setActor(null);
                --i;
            }
        }
        if (this.touchableSupplier != null) {
            this.touchable(this.touchableSupplier.get());
        }
        if (this.update != null) {
            this.update.run();
        }
    }

    public void updateVisibility() {
        if (this.visibility != null) {
            this.visible(this.visibility.get());
        }
    }

    public boolean hasMouse() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
        return e == this || e != null && e.isDescendantOf(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire(SceneEvent event) {
        event.targetActor = this;
        Array ancestors = Pools.obtain(Array.class, Array::new);
        Group parent = this.parent;
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.parent;
        }
        try {
            int i;
            T[] ancestorsArray = ancestors.items;
            for (i = ancestors.size - 1; i >= 0; --i) {
                Group currentTarget = (Group)ancestorsArray[i];
                currentTarget.notify(event, true);
                if (!event.stopped) continue;
                boolean bl = event.cancelled;
                return bl;
            }
            this.notify(event, true);
            if (event.stopped) {
                i = event.cancelled ? 1 : 0;
                return i != 0;
            }
            this.notify(event, false);
            if (!event.bubbles) {
                i = event.cancelled;
                return i != 0;
            }
            if (event.stopped) {
                i = event.cancelled;
                return i != 0;
            }
            int n = ancestors.size;
            for (i = 0; i < n; ++i) {
                ((Group)ancestorsArray[i]).notify(event, false);
                if (!event.stopped) continue;
                boolean bl = event.cancelled;
                return bl;
            }
            boolean bl = event.cancelled;
            return bl;
        }
        finally {
            ancestors.clear();
            Pools.free(ancestors);
        }
    }

    public boolean notify(SceneEvent event, boolean capture) {
        DelayedRemovalArray<EventListener> listeners;
        if (event.targetActor == null) {
            throw new IllegalArgumentException("The event target cannot be null.");
        }
        DelayedRemovalArray<EventListener> delayedRemovalArray = listeners = capture ? this.captureListeners : this.listeners;
        if (listeners.size == 0) {
            return event.cancelled;
        }
        event.listenerActor = this;
        event.capture = capture;
        listeners.begin();
        int n = listeners.size;
        for (int i = 0; i < n; ++i) {
            EventListener listener = (EventListener)listeners.get(i);
            if (!listener.handle(event)) continue;
            event.handle();
            if (!(event instanceof InputEvent)) continue;
            InputEvent inputEvent = (InputEvent)event;
            if (inputEvent.type != InputEvent.Type.touchDown) continue;
            this.getScene().addTouchFocus(listener, this, inputEvent.targetActor, inputEvent.pointer, inputEvent.keyCode);
        }
        listeners.end();
        return event.cancelled;
    }

    public Element hit(float x, float y, boolean touchable) {
        if (touchable && this.touchable != Touchable.enabled) {
            return null;
        }
        Element e = this;
        return x >= e.translation.x && x < this.width + e.translation.x && y >= e.translation.y && y < this.height + e.translation.y ? this : null;
    }

    public boolean remove() {
        return this.parent != null && this.parent.removeChild(this, true);
    }

    public void dragged(final PositionConsumer cons) {
        this.addListener(new InputListener(){
            float lastX;
            float lastY;

            @Override
            public void touchDragged(InputEvent event, float mx, float my, int pointer) {
                cons.accept(mx - this.lastX, my - this.lastY);
                this.lastX = mx;
                this.lastY = my;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                this.lastX = x;
                this.lastY = y;
                return true;
            }
        });
    }

    public boolean addListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.listeners.removeValue(listener, true);
    }

    public Array<EventListener> getListeners() {
        return this.listeners;
    }

    public boolean addCaptureListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (!this.captureListeners.contains(listener, true)) {
            this.captureListeners.add(listener);
        }
        return true;
    }

    public boolean removeCaptureListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.captureListeners.removeValue(listener, true);
    }

    public Array<EventListener> getCaptureListeners() {
        return this.captureListeners;
    }

    public void addAction(Action action) {
        action.setActor(this);
        this.actions.add(action);
        if (this.stage != null && this.stage.getActionsRequestRendering()) {
            Core.graphics.requestRendering();
        }
    }

    public void actions(Action ... actions) {
        this.addAction(Actions.sequence(actions));
    }

    public void removeAction(Action action) {
        if (this.actions.removeValue(action, true)) {
            action.setActor(null);
        }
    }

    public Array<Action> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions.size > 0;
    }

    public void clearActions() {
        for (int i = this.actions.size - 1; i >= 0; --i) {
            this.actions.get(i).setActor(null);
        }
        this.actions.clear();
    }

    public void clearListeners() {
        this.listeners.clear();
        this.captureListeners.clear();
    }

    public void clear() {
        this.clearActions();
        this.clearListeners();
    }

    public Scene getScene() {
        return this.stage;
    }

    protected void setScene(Scene stage) {
        this.stage = stage;
    }

    public boolean isDescendantOf(Element actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        Element parent = this;
        while (parent != null) {
            if (parent == actor) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public boolean isAscendantOf(Element actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        while (actor != null) {
            if (actor == this) {
                return true;
            }
            actor = actor.parent;
        }
        return false;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Group getParent() {
        return this.parent;
    }

    protected void setParent(Group parent) {
        this.parent = parent;
    }

    public boolean isTouchable() {
        return this.touchable == Touchable.enabled;
    }

    public Touchable getTouchable() {
        return this.touchable;
    }

    public void touchable(Touchable touchable) {
        this.touchable = touchable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void visible(boolean visible) {
        this.visible = visible;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        if (this.x != x) {
            this.x = x;
            this.positionChanged();
        }
    }

    public float getX(int alignment) {
        float x = this.x;
        if ((alignment & 0x10) != 0) {
            x += this.width;
        } else if ((alignment & 8) == 0) {
            x += this.width / 2.0f;
        }
        return x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        if (this.y != y) {
            this.y = y;
            this.positionChanged();
        }
    }

    public float getY(int alignment) {
        float y = this.y;
        if ((alignment & 2) != 0) {
            y += this.height;
        } else if ((alignment & 4) == 0) {
            y += this.height / 2.0f;
        }
        return y;
    }

    public void setPosition(float x, float y) {
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
            this.positionChanged();
        }
    }

    public void setPosition(float x, float y, int alignment) {
        if ((alignment & 0x10) != 0) {
            x -= this.width;
        } else if ((alignment & 8) == 0) {
            x -= this.width / 2.0f;
        }
        if ((alignment & 2) != 0) {
            y -= this.height;
        } else if ((alignment & 4) == 0) {
            y -= this.height / 2.0f;
        }
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
            this.positionChanged();
        }
    }

    public void moveBy(float x, float y) {
        if (x != 0.0f || y != 0.0f) {
            this.x += x;
            this.y += y;
            this.positionChanged();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        if (this.width != width) {
            this.width = width;
            this.sizeChanged();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        if (this.height != height) {
            this.height = height;
            this.sizeChanged();
        }
    }

    public float getTop() {
        return this.y + this.height;
    }

    public float getRight() {
        return this.x + this.width;
    }

    protected void positionChanged() {
    }

    protected void sizeChanged() {
        this.invalidate();
    }

    protected void rotationChanged() {
    }

    public void setSize(float size) {
        this.setSize(size, size);
    }

    public void setSize(float width, float height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.sizeChanged();
        }
    }

    public void sizeBy(float size) {
        if (size != 0.0f) {
            this.width += size;
            this.height += size;
            this.sizeChanged();
        }
    }

    public void sizeBy(float width, float height) {
        if (width != 0.0f || height != 0.0f) {
            this.width += width;
            this.height += height;
            this.sizeChanged();
        }
    }

    public void setBounds(float x, float y, float width, float height) {
        if (this.x != x || this.y != y) {
            this.x = x;
            this.y = y;
            this.positionChanged();
        }
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.sizeChanged();
        }
    }

    public float getOriginX() {
        return this.originX;
    }

    public void setOriginX(float originX) {
        this.originX = originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOriginY(float originY) {
        this.originY = originY;
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
    }

    public void setOrigin(int alignment) {
        this.originX = (alignment & 8) != 0 ? 0.0f : ((alignment & 0x10) != 0 ? this.width : this.width / 2.0f);
        this.originY = (alignment & 4) != 0 ? 0.0f : ((alignment & 2) != 0 ? this.height : this.height / 2.0f);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scaleXY) {
        this.scaleX = scaleXY;
        this.scaleY = scaleXY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void scaleBy(float scale) {
        this.scaleX += scale;
        this.scaleY += scale;
    }

    public void scaleBy(float scaleX, float scaleY) {
        this.scaleX += scaleX;
        this.scaleY += scaleY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float degrees) {
        if (this.rotation != degrees) {
            this.rotation = degrees;
            this.rotationChanged();
        }
    }

    public void setRotationOrigin(float degrees, int align) {
        this.setOrigin(align);
        if (this.rotation != degrees) {
            this.rotation = degrees;
            this.rotationChanged();
        }
    }

    public void rotateBy(float amountInDegrees) {
        if (amountInDegrees != 0.0f) {
            this.rotation += amountInDegrees;
            this.rotationChanged();
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public int getZIndex() {
        Group parent = this.parent;
        if (parent == null) {
            return -1;
        }
        return parent.children.indexOf(this, true);
    }

    public void setZIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("ZIndex cannot be < 0.");
        }
        Group parent = this.parent;
        if (parent == null) {
            return;
        }
        SnapshotArray<Element> children = parent.children;
        if (children.size == 1) {
            return;
        }
        if (children.get(index = Math.min(index, children.size - 1)) == this) {
            return;
        }
        if (!((Array)children).removeValue(this, true)) {
            return;
        }
        ((Array)children).insert(index, this);
    }

    public boolean clipBegin() {
        return this.clipBegin(this.x, this.y, this.width, this.height);
    }

    public boolean clipBegin(float x, float y, float width, float height) {
        if (width <= 0.0f || height <= 0.0f) {
            return false;
        }
        Rectangle tableBounds = Rectangle.tmp;
        tableBounds.x = x;
        tableBounds.y = y;
        tableBounds.width = width;
        tableBounds.height = height;
        Scene stage = this.stage;
        Rectangle scissorBounds = Pools.obtain(Rectangle.class, Rectangle::new);
        stage.calculateScissors(tableBounds, scissorBounds);
        if (ScissorStack.pushScissors(scissorBounds)) {
            return true;
        }
        Pools.free(scissorBounds);
        return false;
    }

    public void clipEnd() {
        Pools.free(ScissorStack.popScissors());
    }

    public Vector2 screenToLocalCoordinates(Vector2 screenCoords) {
        Scene stage = this.stage;
        if (stage == null) {
            return screenCoords;
        }
        return this.stageToLocalCoordinates(stage.screenToStageCoordinates(screenCoords));
    }

    public Vector2 stageToLocalCoordinates(Vector2 stageCoords) {
        if (this.parent != null) {
            this.parent.stageToLocalCoordinates(stageCoords);
        }
        this.parentToLocalCoordinates(stageCoords);
        return stageCoords;
    }

    public Vector2 localToStageCoordinates(Vector2 localCoords) {
        return this.localToAscendantCoordinates(null, localCoords);
    }

    public Vector2 localToParentCoordinates(Vector2 localCoords) {
        float rotation = -this.rotation;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        float x = this.x;
        float y = this.y;
        if (rotation == 0.0f) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                localCoords.x += x;
                localCoords.y += y;
            } else {
                float originX = this.originX;
                float originY = this.originY;
                localCoords.x = (localCoords.x - originX) * scaleX + originX + x;
                localCoords.y = (localCoords.y - originY) * scaleY + originY + y;
            }
        } else {
            float cos = (float)Math.cos(rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(rotation * ((float)Math.PI / 180));
            float originX = this.originX;
            float originY = this.originY;
            float tox = (localCoords.x - originX) * scaleX;
            float toy = (localCoords.y - originY) * scaleY;
            localCoords.x = tox * cos + toy * sin + originX + x;
            localCoords.y = tox * -sin + toy * cos + originY + y;
        }
        return localCoords;
    }

    public Vector2 localToAscendantCoordinates(Element ascendant, Vector2 localCoords) {
        Element actor = this;
        while (actor != null) {
            actor.localToParentCoordinates(localCoords);
            actor = actor.parent;
            if (actor != ascendant) continue;
            break;
        }
        return localCoords;
    }

    public Vector2 parentToLocalCoordinates(Vector2 parentCoords) {
        float rotation = this.rotation;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        float childX = this.x + this.translation.x;
        float childY = this.y + this.translation.y;
        if (rotation == 0.0f) {
            if (scaleX == 1.0f && scaleY == 1.0f) {
                parentCoords.x -= childX;
                parentCoords.y -= childY;
            } else {
                float originX = this.originX;
                float originY = this.originY;
                parentCoords.x = (parentCoords.x - childX - originX) / scaleX + originX;
                parentCoords.y = (parentCoords.y - childY - originY) / scaleY + originY;
            }
        } else {
            float cos = (float)Math.cos(rotation * ((float)Math.PI / 180));
            float sin = (float)Math.sin(rotation * ((float)Math.PI / 180));
            float originX = this.originX;
            float originY = this.originY;
            float tox = parentCoords.x - childX - originX;
            float toy = parentCoords.y - childY - originY;
            parentCoords.x = (tox * cos + toy * sin) / scaleX + originX;
            parentCoords.y = (tox * -sin + toy * cos) / scaleY + originY;
        }
        return parentCoords;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getPrefWidth() {
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public void setLayoutEnabled(boolean enabled) {
        this.layoutEnabled = enabled;
        if (enabled) {
            this.invalidateHierarchy();
        }
    }

    @Override
    public void validate() {
        if (!this.layoutEnabled) {
            return;
        }
        Group parent = this.getParent();
        if (this.fillParent && parent != null) {
            float parentHeight;
            float parentWidth;
            Scene stage = this.getScene();
            if (stage != null && parent == stage.root) {
                parentWidth = stage.getWidth();
                parentHeight = stage.getHeight();
            } else {
                parentWidth = parent.getWidth();
                parentHeight = parent.getHeight();
            }
            this.setSize(parentWidth, parentHeight);
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void invalidateHierarchy() {
        if (!this.layoutEnabled) {
            return;
        }
        this.invalidate();
        Group parent = this.getParent();
        if (parent != null) {
            parent.invalidateHierarchy();
        }
    }

    @Override
    public void pack() {
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.validate();
    }

    @Override
    public void setFillParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    @Override
    public void layout() {
    }

    public void setTranslation(float x, float y) {
        this.translation.x = x;
        this.translation.y = y;
    }

    public Vector2 getTranslation() {
        return this.translation;
    }

    public void keyDown(KeyCode key, Runnable l) {
        this.keyDown(k -> {
            if (k == key) {
                l.run();
            }
        });
    }

    public void keyDown(final Consumer<KeyCode> cons) {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, KeyCode keycode) {
                cons.accept(keycode);
                return true;
            }
        });
    }

    public void fireClick() {
        for (EventListener listener : this.getListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            ((ClickListener)listener).clicked(new InputEvent(), -1.0f, -1.0f);
        }
    }

    public ClickListener clicked(Runnable r) {
        return this.clicked(KeyCode.MOUSE_LEFT, r);
    }

    public ClickListener clicked(KeyCode button, Runnable r) {
        return this.clicked((ClickListener l) -> l.setButton(button), r);
    }

    public ClickListener clicked(Consumer<ClickListener> tweaker, Runnable r) {
        return this.clicked(tweaker, (ClickListener e) -> r.run());
    }

    public ClickListener clicked(Consumer<ClickListener> tweaker, final Consumer<ClickListener> runner) {
        final Element elem = this;
        ClickListener click = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(runner == null || elem instanceof Disableable && ((Disableable)((Object)elem)).isDisabled())) {
                    runner.accept(this);
                }
            }
        };
        this.addListener(click);
        tweaker.accept(click);
        return click;
    }

    public void tapped(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                r.run();
                return true;
            }
        });
    }

    public void hovered(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
                r.run();
            }
        });
    }

    public void exited(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Element fromActor) {
                r.run();
            }
        });
    }

    public void released(final Runnable r) {
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                r.run();
            }
        });
    }

    public void change() {
        this.fire(new ChangeListener.ChangeEvent());
    }

    public void changed(final Runnable r) {
        final Element elem = this;
        this.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Element actor) {
                if (!(elem instanceof Disableable) || !((Disableable)((Object)elem)).isDisabled()) {
                    r.run();
                }
            }
        });
    }

    public void update(Runnable r) {
        this.update = r;
    }

    public Element visible(BooleanProvider vis) {
        this.visibility = vis;
        return this;
    }

    public void touchable(Supplier<Touchable> touch) {
        this.touchableSupplier = touch;
    }

    public String toString() {
        int dotIndex;
        String name = this.name;
        if (name == null && (dotIndex = (name = super.toString().split("@")[0]).lastIndexOf(46)) != -1) {
            name = name.substring(dotIndex + 1);
        }
        return name;
    }
}

