/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene;

import io.anuke.arc.Application;
import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.SnapshotArray;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Camera;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.ScissorStack;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.EventListener;
import io.anuke.arc.scene.event.FocusListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.arc.util.viewport.ScreenViewport;
import io.anuke.arc.util.viewport.Viewport;

public class Scene
implements InputProcessor,
Disposable {
    public final Group root;
    private final ObjectMap<Class, Object> styleDefaults = new ObjectMap();
    private final Vector2 tempCoords = new Vector2();
    private final Element[] pointerOverActors = new Element[20];
    private final boolean[] pointerTouched = new boolean[20];
    private final int[] pointerScreenX = new int[20];
    private final int[] pointerScreenY = new int[20];
    private final SnapshotArray<TouchFocus> touchFocuses = new SnapshotArray(true, 4, TouchFocus.class);
    private Viewport viewport = new ScreenViewport(){

        @Override
        public void calculateScissors(Matrix3 batchTransform, Rectangle area, Rectangle scissor) {
            ScissorStack.calculateScissors(this.getCamera(), this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight(), batchTransform, area, scissor);
        }
    };
    private int mouseScreenX;
    private int mouseScreenY;
    private Element mouseOverElement;
    private Element keyboardFocus;
    private Element scrollFocus;
    private boolean actionsRequestRendering = true;

    public Scene() {
        this.root = new Group(){};
        this.root.setScene(this);
        this.viewport.update(Core.graphics.getWidth(), Core.graphics.getHeight(), true);
    }

    public Scene(Viewport viewport) {
        this();
        this.viewport = viewport;
    }

    public <T> T getStyle(Class<T> type) {
        return (T)this.styleDefaults.getThrow(type, () -> new IllegalArgumentException("No default style for type: " + type.getSimpleName()));
    }

    public <T> void addStyle(Class<T> type, T style) {
        this.styleDefaults.put(type, style);
    }

    public boolean hasMouse() {
        return this.hit(Core.input.mouseX(), Core.input.mouseY(), true) != null;
    }

    public boolean hasMouse(float mousex, float mousey) {
        return this.hit(mousex, mousey, true) != null;
    }

    public boolean hasDialog() {
        return this.getKeyboardFocus() instanceof Dialog || this.getScrollFocus() instanceof Dialog;
    }

    public Dialog getDialog() {
        if (this.getKeyboardFocus() instanceof Dialog) {
            return (Dialog)this.getKeyboardFocus();
        }
        if (this.getScrollFocus() instanceof Dialog) {
            return (Dialog)this.getScrollFocus();
        }
        return null;
    }

    public void draw() {
        Camera camera = this.viewport.getCamera();
        camera.update();
        if (!this.root.isVisible()) {
            return;
        }
        Draw.proj(camera.projection());
        this.root.draw();
        Draw.flush();
    }

    public void act() {
        this.act(Core.graphics.getDeltaTime());
    }

    public void act(float delta) {
        int n = this.pointerOverActors.length;
        for (int pointer = 0; pointer < n; ++pointer) {
            Element overLast = this.pointerOverActors[pointer];
            if (!this.pointerTouched[pointer]) {
                if (overLast == null) continue;
                this.pointerOverActors[pointer] = null;
                this.screenToStageCoordinates(this.tempCoords.set(this.pointerScreenX[pointer], this.pointerScreenY[pointer]));
                InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
                event.type = InputEvent.Type.exit;
                event.stageX = this.tempCoords.x;
                event.stageY = this.tempCoords.y;
                event.relatedActor = overLast;
                event.pointer = pointer;
                overLast.fire(event);
                Pools.free(event);
                continue;
            }
            this.pointerOverActors[pointer] = this.fireEnterAndExit(overLast, this.pointerScreenX[pointer], this.pointerScreenY[pointer], pointer);
        }
        Application.ApplicationType type = Core.app.getType();
        if (type == Application.ApplicationType.Desktop || type == Application.ApplicationType.WebGL) {
            this.mouseOverElement = this.fireEnterAndExit(this.mouseOverElement, this.mouseScreenX, this.mouseScreenY, -1);
        }
        this.root.act(delta);
    }

    public Element find(String name) {
        return this.root.find(name);
    }

    public Element findVisible(String name) {
        return this.root.findVisible(name);
    }

    public Element find(Predicate<Element> pred) {
        return this.root.find(pred);
    }

    public Table table() {
        Table table = new Table();
        table.setFillParent(true);
        this.add(table);
        return table;
    }

    public Table table(Consumer<Table> cons) {
        Table table = new Table();
        table.setFillParent(true);
        this.add(table);
        cons.accept(table);
        return table;
    }

    public Table table(Drawable style, Consumer<Table> cons) {
        Table table = new Table(style);
        table.setFillParent(true);
        this.add(table);
        cons.accept(table);
        return table;
    }

    private Element fireEnterAndExit(Element overLast, int screenX, int screenY, int pointer) {
        InputEvent event;
        this.screenToStageCoordinates(this.tempCoords.set(screenX, screenY));
        Element over = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (over == overLast) {
            return overLast;
        }
        if (overLast != null) {
            event = Pools.obtain(InputEvent.class, InputEvent::new);
            event.stageX = this.tempCoords.x;
            event.stageY = this.tempCoords.y;
            event.pointer = pointer;
            event.type = InputEvent.Type.exit;
            event.relatedActor = over;
            overLast.fire(event);
            Pools.free(event);
        }
        if (over != null) {
            event = Pools.obtain(InputEvent.class, InputEvent::new);
            event.stageX = this.tempCoords.x;
            event.stageY = this.tempCoords.y;
            event.pointer = pointer;
            event.type = InputEvent.Type.enter;
            event.relatedActor = overLast;
            over.fire(event);
            Pools.free(event);
        }
        return over;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        if (!this.isInsideViewport(screenX, screenY)) {
            return false;
        }
        this.pointerTouched[pointer] = true;
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        this.screenToStageCoordinates(this.tempCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.touchDown;
        event.stageX = this.tempCoords.x;
        event.stageY = this.tempCoords.y;
        event.pointer = pointer;
        event.keyCode = button;
        Element target = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (target == null) {
            if (this.root.getTouchable() == Touchable.enabled) {
                this.root.fire(event);
            }
        } else {
            target.fire(event);
        }
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        this.mouseScreenX = screenX;
        this.mouseScreenY = screenY;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        this.screenToStageCoordinates(this.tempCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.touchDragged;
        event.stageX = this.tempCoords.x;
        event.stageY = this.tempCoords.y;
        event.pointer = pointer;
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] focuses = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = focuses[i];
            if (focus.pointer != pointer || !touchFocuses.contains(focus, true)) continue;
            event.targetActor = focus.target;
            event.listenerActor = focus.listenerActor;
            if (!focus.listener.handle(event)) continue;
            event.handle();
        }
        touchFocuses.end();
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.pointerTouched[pointer] = false;
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        this.screenToStageCoordinates(this.tempCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.touchUp;
        event.stageX = this.tempCoords.x;
        event.stageY = this.tempCoords.y;
        event.pointer = pointer;
        event.keyCode = button;
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] focuses = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = focuses[i];
            if (focus.pointer != pointer || focus.button != button || !touchFocuses.removeValue(focus, true)) continue;
            event.targetActor = focus.target;
            event.listenerActor = focus.listenerActor;
            if (focus.listener.handle(event)) {
                event.handle();
            }
            Pools.free(focus);
        }
        touchFocuses.end();
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (!this.isInsideViewport(screenX, screenY)) {
            return false;
        }
        this.mouseScreenX = screenX;
        this.mouseScreenY = screenY;
        this.screenToStageCoordinates(this.tempCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.mouseMoved;
        event.stageX = this.tempCoords.x;
        event.stageY = this.tempCoords.y;
        Element target = this.hit(this.tempCoords.x, this.tempCoords.y, true);
        if (target == null) {
            target = this.root;
        }
        target.fire(event);
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        Element target = this.scrollFocus == null ? this.root : this.scrollFocus;
        this.screenToStageCoordinates(this.tempCoords.set(this.mouseScreenX, this.mouseScreenY));
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.scrolled;
        event.scrollAmountX = amountX;
        event.scrollAmountY = amountY;
        event.stageX = this.tempCoords.x;
        event.stageY = this.tempCoords.y;
        target.fire(event);
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyDown(KeyCode keyCode) {
        Element target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.keyDown;
        event.keyCode = keyCode;
        target.fire(event);
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyUp(KeyCode keyCode) {
        Element target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.keyUp;
        event.keyCode = keyCode;
        target.fire(event);
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyTyped(char character) {
        Element target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.keyTyped;
        event.character = character;
        target.fire(event);
        boolean handled = event.handled;
        Pools.free(event);
        return handled;
    }

    public void addTouchFocus(EventListener listener, Element listenerActor, Element target, int pointer, KeyCode button) {
        TouchFocus focus = Pools.obtain(TouchFocus.class, TouchFocus::new);
        focus.listenerActor = listenerActor;
        focus.target = target;
        focus.listener = listener;
        focus.pointer = pointer;
        focus.button = button;
        this.touchFocuses.add(focus);
    }

    public void removeTouchFocus(EventListener listener, Element listenerActor, Element target, int pointer, KeyCode button) {
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        for (int i = touchFocuses.size - 1; i >= 0; --i) {
            TouchFocus focus = (TouchFocus)touchFocuses.get(i);
            if (focus.listener != listener || focus.listenerActor != listenerActor || focus.target != target || focus.pointer != pointer || focus.button != button) continue;
            touchFocuses.remove(i);
            Pools.free(focus);
        }
    }

    public void cancelTouchFocus(Element actor) {
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.touchUp;
        event.stageX = -2.1474836E9f;
        event.stageY = -2.1474836E9f;
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] items = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = items[i];
            if (focus.listenerActor != actor || !touchFocuses.removeValue(focus, true)) continue;
            event.targetActor = focus.target;
            event.listenerActor = focus.listenerActor;
            event.pointer = focus.pointer;
            event.keyCode = focus.button;
            focus.listener.handle(event);
        }
        touchFocuses.end();
        Pools.free(event);
    }

    public void cancelTouchFocus() {
        this.cancelTouchFocusExcept(null, null);
    }

    public void cancelTouchFocusExcept(EventListener exceptListener, Element exceptActor) {
        InputEvent event = Pools.obtain(InputEvent.class, InputEvent::new);
        event.type = InputEvent.Type.touchUp;
        event.stageX = -2.1474836E9f;
        event.stageY = -2.1474836E9f;
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] items = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = items[i];
            if (focus.listener == exceptListener && focus.listenerActor == exceptActor || !touchFocuses.removeValue(focus, true)) continue;
            event.targetActor = focus.target;
            event.listenerActor = focus.listenerActor;
            event.pointer = focus.pointer;
            event.keyCode = focus.button;
            focus.listener.handle(event);
        }
        touchFocuses.end();
        Pools.free(event);
    }

    public void add(Element actor) {
        this.root.addChild(actor);
    }

    public void addAction(Action action) {
        this.root.addAction(action);
    }

    public Array<Element> getElements() {
        return this.root.children;
    }

    public boolean addListener(EventListener listener) {
        return this.root.addListener(listener);
    }

    public boolean removeListener(EventListener listener) {
        return this.root.removeListener(listener);
    }

    public boolean addCaptureListener(EventListener listener) {
        return this.root.addCaptureListener(listener);
    }

    public boolean removeCaptureListener(EventListener listener) {
        return this.root.removeCaptureListener(listener);
    }

    public void clear() {
        this.unfocusAll();
        this.root.clear();
    }

    public void unfocusAll() {
        this.setScrollFocus(null);
        this.setKeyboardFocus(null);
        this.cancelTouchFocus();
    }

    public void unfocus(Element actor) {
        this.cancelTouchFocus(actor);
        if (this.scrollFocus != null && this.scrollFocus.isDescendantOf(actor)) {
            this.setScrollFocus(null);
        }
        if (this.keyboardFocus != null && this.keyboardFocus.isDescendantOf(actor)) {
            this.setKeyboardFocus(null);
        }
    }

    public boolean setKeyboardFocus(Element actor) {
        boolean success;
        if (this.keyboardFocus == actor) {
            return true;
        }
        FocusListener.FocusEvent event = Pools.obtain(FocusListener.FocusEvent.class, FocusListener.FocusEvent::new);
        event.type = FocusListener.FocusEvent.Type.keyboard;
        Element oldKeyboardFocus = this.keyboardFocus;
        if (oldKeyboardFocus != null) {
            event.focused = false;
            event.relatedActor = actor;
            oldKeyboardFocus.fire(event);
        }
        boolean bl = success = !event.cancelled;
        if (success) {
            this.keyboardFocus = actor;
            if (actor != null) {
                event.focused = true;
                event.relatedActor = oldKeyboardFocus;
                actor.fire(event);
                boolean bl2 = success = !event.cancelled;
                if (!success) {
                    this.setKeyboardFocus(oldKeyboardFocus);
                }
            }
        }
        Pools.free(event);
        return success;
    }

    public Element getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public boolean setScrollFocus(Element actor) {
        boolean success;
        if (this.scrollFocus == actor) {
            return true;
        }
        FocusListener.FocusEvent event = Pools.obtain(FocusListener.FocusEvent.class, FocusListener.FocusEvent::new);
        event.type = FocusListener.FocusEvent.Type.scroll;
        Element oldScrollFocus = this.scrollFocus;
        if (oldScrollFocus != null) {
            event.focused = false;
            event.relatedActor = actor;
            oldScrollFocus.fire(event);
        }
        boolean bl = success = !event.cancelled;
        if (success) {
            this.scrollFocus = actor;
            if (actor != null) {
                event.focused = true;
                event.relatedActor = oldScrollFocus;
                actor.fire(event);
                boolean bl2 = success = !event.cancelled;
                if (!success) {
                    this.setScrollFocus(oldScrollFocus);
                }
            }
        }
        Pools.free(event);
        return success;
    }

    public Element getScrollFocus() {
        return this.scrollFocus;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public float getWidth() {
        return this.viewport.getWorldWidth();
    }

    public float getHeight() {
        return this.viewport.getWorldHeight();
    }

    public Camera getCamera() {
        return this.viewport.getCamera();
    }

    public Element hit(float stageX, float stageY, boolean touchable) {
        this.root.parentToLocalCoordinates(this.tempCoords.set(stageX, stageY));
        return this.root.hit(this.tempCoords.x, this.tempCoords.y, touchable);
    }

    public Vector2 screenToStageCoordinates(Vector2 screenCoords) {
        this.viewport.unproject(screenCoords);
        return screenCoords;
    }

    public Vector2 stageToScreenCoordinates(Vector2 stageCoords) {
        this.viewport.project(stageCoords);
        stageCoords.y = (float)this.viewport.getScreenHeight() - stageCoords.y;
        return stageCoords;
    }

    public Vector2 toScreenCoordinates(Vector2 coords, Matrix3 transformMatrix) {
        return this.viewport.toScreenCoordinates(coords, transformMatrix);
    }

    public void calculateScissors(Rectangle localRect, Rectangle scissorRect) {
        Matrix3 transformMatrix = Draw.trans();
        this.viewport.calculateScissors(transformMatrix, localRect, scissorRect);
    }

    public boolean getActionsRequestRendering() {
        return this.actionsRequestRendering;
    }

    public void setActionsRequestRendering(boolean actionsRequestRendering) {
        this.actionsRequestRendering = actionsRequestRendering;
    }

    protected boolean isInsideViewport(int screenX, int screenY) {
        int x0 = this.viewport.getScreenX();
        int x1 = x0 + this.viewport.getScreenWidth();
        int y0 = this.viewport.getScreenY();
        int y1 = y0 + this.viewport.getScreenHeight();
        screenY = Core.graphics.getHeight() - screenY;
        return screenX >= x0 && screenX < x1 && screenY >= y0 && screenY < y1;
    }

    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
    }

    @Override
    public void dispose() {
    }

    public static final class TouchFocus
    implements Pool.Poolable {
        EventListener listener;
        Element listenerActor;
        Element target;
        int pointer;
        KeyCode button;

        @Override
        public void reset() {
            this.listenerActor = null;
            this.listener = null;
            this.target = null;
        }
    }
}

