/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.actions;

import io.anuke.arc.collection.Array;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.actions.DelegateAction;

public class AfterAction
extends DelegateAction {
    private Array<Action> waitForActions = new Array(false, 4);

    @Override
    public void setTarget(Element target) {
        if (target != null) {
            this.waitForActions.addAll(target.getActions());
        }
        super.setTarget(target);
    }

    @Override
    public void restart() {
        super.restart();
        this.waitForActions.clear();
    }

    @Override
    protected boolean delegate(float delta) {
        Array<Action> currentActions = this.target.getActions();
        if (currentActions.size == 1) {
            this.waitForActions.clear();
        }
        for (int i = this.waitForActions.size - 1; i >= 0; --i) {
            Action action = this.waitForActions.get(i);
            int index = currentActions.indexOf(action, true);
            if (index != -1) continue;
            this.waitForActions.remove(i);
        }
        return this.waitForActions.size <= 0 && this.action.act(delta);
    }
}

