/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.event;

import io.anuke.arc.input.GestureDetector;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.EventListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.SceneEvent;

public class ElementGestureListener
implements EventListener {
    static final Vector2 tmpCoords = new Vector2();
    static final Vector2 tmpCoords2 = new Vector2();
    private final GestureDetector detector;
    InputEvent event;
    Element actor;
    Element touchDownTarget;

    public ElementGestureListener() {
        this(20.0f, 0.4f, 1.1f, 0.15f);
    }

    public ElementGestureListener(float halfTapSquareSize, float tapCountInterval, float longPressDuration, float maxFlingDelay) {
        this.detector = new GestureDetector(halfTapSquareSize, tapCountInterval, longPressDuration, maxFlingDelay, new GestureDetector.GestureListener(){
            private final Vector2 initialPointer1 = new Vector2();
            private final Vector2 initialPointer2 = new Vector2();
            private final Vector2 pointer1 = new Vector2();
            private final Vector2 pointer2 = new Vector2();

            @Override
            public boolean tap(float stageX, float stageY, int count, KeyCode button) {
                ElementGestureListener.this.actor.stageToLocalCoordinates(tmpCoords.set(stageX, stageY));
                ElementGestureListener.this.tap(ElementGestureListener.this.event, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y, count, button);
                return true;
            }

            @Override
            public boolean longPress(float stageX, float stageY) {
                ElementGestureListener.this.actor.stageToLocalCoordinates(tmpCoords.set(stageX, stageY));
                return ElementGestureListener.this.longPress(ElementGestureListener.this.actor, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y);
            }

            @Override
            public boolean fling(float velocityX, float velocityY, KeyCode button) {
                this.stageToLocalAmount(tmpCoords.set(velocityX, velocityY));
                ElementGestureListener.this.fling(ElementGestureListener.this.event, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y, button);
                return true;
            }

            @Override
            public boolean pan(float stageX, float stageY, float deltaX, float deltaY) {
                this.stageToLocalAmount(tmpCoords.set(deltaX, deltaY));
                deltaX = ElementGestureListener.tmpCoords.x;
                deltaY = ElementGestureListener.tmpCoords.y;
                ElementGestureListener.this.actor.stageToLocalCoordinates(tmpCoords.set(stageX, stageY));
                ElementGestureListener.this.pan(ElementGestureListener.this.event, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y, deltaX, deltaY);
                return true;
            }

            @Override
            public boolean zoom(float initialDistance, float distance) {
                ElementGestureListener.this.zoom(ElementGestureListener.this.event, initialDistance, distance);
                return true;
            }

            @Override
            public boolean pinch(Vector2 stageInitialPointer1, Vector2 stageInitialPointer2, Vector2 stagePointer1, Vector2 stagePointer2) {
                ElementGestureListener.this.actor.stageToLocalCoordinates(this.initialPointer1.set(stageInitialPointer1));
                ElementGestureListener.this.actor.stageToLocalCoordinates(this.initialPointer2.set(stageInitialPointer2));
                ElementGestureListener.this.actor.stageToLocalCoordinates(this.pointer1.set(stagePointer1));
                ElementGestureListener.this.actor.stageToLocalCoordinates(this.pointer2.set(stagePointer2));
                ElementGestureListener.this.pinch(ElementGestureListener.this.event, this.initialPointer1, this.initialPointer2, this.pointer1, this.pointer2);
                return true;
            }

            private void stageToLocalAmount(Vector2 amount) {
                ElementGestureListener.this.actor.stageToLocalCoordinates(amount);
                amount.sub(ElementGestureListener.this.actor.stageToLocalCoordinates(tmpCoords2.set(0.0f, 0.0f)));
            }
        });
    }

    @Override
    public boolean handle(SceneEvent e) {
        if (!(e instanceof InputEvent)) {
            return false;
        }
        InputEvent event = (InputEvent)e;
        switch (event.type) {
            case touchDown: {
                this.actor = event.listenerActor;
                this.touchDownTarget = event.targetActor;
                this.detector.touchDown(event.stageX, event.stageY, event.pointer, event.keyCode);
                this.actor.stageToLocalCoordinates(tmpCoords.set(event.stageX, event.stageY));
                this.touchDown(event, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y, event.pointer, event.keyCode);
                return true;
            }
            case touchUp: {
                if (event.isTouchFocusCancel()) {
                    return false;
                }
                this.event = event;
                this.actor = event.listenerActor;
                this.detector.touchUp(event.stageX, event.stageY, event.pointer, event.keyCode);
                this.actor.stageToLocalCoordinates(tmpCoords.set(event.stageX, event.stageY));
                this.touchUp(event, ElementGestureListener.tmpCoords.x, ElementGestureListener.tmpCoords.y, event.pointer, event.keyCode);
                return true;
            }
            case touchDragged: {
                this.event = event;
                this.actor = event.listenerActor;
                this.detector.touchDragged(event.stageX, event.stageY, event.pointer);
                return true;
            }
        }
        return false;
    }

    public void touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
    }

    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
    }

    public void tap(InputEvent event, float x, float y, int count, KeyCode button) {
    }

    public boolean longPress(Element actor, float x, float y) {
        return false;
    }

    public void fling(InputEvent event, float velocityX, float velocityY, KeyCode button) {
    }

    public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
    }

    public void zoom(InputEvent event, float initialDistance, float distance) {
    }

    public void pinch(InputEvent event, Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
    }

    public GestureDetector getGestureDetector() {
        return this.detector;
    }

    public Element getTouchDownTarget() {
        return this.touchDownTarget;
    }
}

