/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.event;

import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.EventListener;
import io.anuke.arc.scene.event.SceneEvent;

public abstract class FocusListener
implements EventListener {
    @Override
    public boolean handle(SceneEvent event) {
        if (!(event instanceof FocusEvent)) {
            return false;
        }
        FocusEvent focusEvent = (FocusEvent)event;
        switch (focusEvent.type) {
            case keyboard: {
                this.keyboardFocusChanged(focusEvent, event.targetActor, focusEvent.focused);
                break;
            }
            case scroll: {
                this.scrollFocusChanged(focusEvent, event.targetActor, focusEvent.focused);
            }
        }
        return false;
    }

    public void keyboardFocusChanged(FocusEvent event, Element element, boolean focused) {
    }

    public void scrollFocusChanged(FocusEvent event, Element element, boolean focused) {
    }

    public static class FocusEvent
    extends SceneEvent {
        public boolean focused;
        public Type type;
        public Element relatedActor;

        @Override
        public void reset() {
            super.reset();
            this.relatedActor = null;
        }

        public static enum Type {
            keyboard,
            scroll;

        }
    }
}

