/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.event;

import io.anuke.arc.Core;
import io.anuke.arc.Graphics;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.utils.Disableable;

public class HandCursorListener
extends ClickListener {
    private BooleanProvider enabled = () -> true;

    public void setEnabled(BooleanProvider vis) {
        this.enabled = vis;
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
        super.enter(event, x, y, pointer, fromActor);
        if (pointer != -1 || !this.enabled.get() || HandCursorListener.isDisabled(event.targetActor) || HandCursorListener.isDisabled(fromActor)) {
            return;
        }
        Core.graphics.cursor(Graphics.Cursor.SystemCursor.hand);
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
        super.exit(event, x, y, pointer, toActor);
        if (pointer == -1) {
            Core.graphics.restoreCursor();
        }
    }

    static boolean isDisabled(Element element) {
        return element != null && (element instanceof Disableable && ((Disableable)((Object)element)).isDisabled() || !element.isVisible() || HandCursorListener.isDisabled(element.getParent()));
    }
}

