/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.style;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.style.BaseDrawable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TransformDrawable;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Tmp;

public class TextureRegionDrawable
extends BaseDrawable
implements TransformDrawable {
    private TextureRegion region;
    private Color tint = new Color(1.0f, 1.0f, 1.0f);

    public TextureRegionDrawable() {
    }

    public TextureRegionDrawable(TextureRegion region) {
        this.setRegion(region);
    }

    public TextureRegionDrawable(TextureRegionDrawable drawable) {
        super(drawable);
        this.setRegion(drawable.region);
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
        Draw.rect(this.region, x + width / 2.0f, y + height / 2.0f, width, height);
    }

    @Override
    public void draw(float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        Draw.color(Tmp.c1.set(this.tint).mul(Draw.getColor()).toFloatBits());
        Draw.rect(this.region, x + width / 2.0f, y + height / 2.0f, width * scaleX, height * scaleY, originX, originY, rotation);
    }

    public TextureRegion getRegion() {
        return this.region;
    }

    public void setRegion(TextureRegion region) {
        this.region = region;
        this.setMinWidth(Scl.scl(region.getWidth()));
        this.setMinHeight(Scl.scl(region.getHeight()));
    }

    public Drawable tint(float r, float g, float b, float a) {
        return this.tint(Tmp.c1.set(r, g, b, a));
    }

    public Drawable tint(Color tint) {
        TextureRegionDrawable drawable = new TextureRegionDrawable(this.region);
        drawable.tint.set(tint);
        return drawable;
    }
}

