/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.event.ClickListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.arc.scene.utils.Layout;
import io.anuke.arc.scene.utils.Selection;

public class TreeElement
extends WidgetGroup {
    final Array<Node> rootNodes = new Array();
    final Selection<Node> selection = new Selection<Node>(){

        @Override
        protected void changed() {
            switch (this.size()) {
                case 0: {
                    TreeElement.this.rangeStart = null;
                    break;
                }
                case 1: {
                    TreeElement.this.rangeStart = (Node)this.first();
                }
            }
        }
    };
    TreeStyle style;
    float ySpacing = 4.0f;
    float iconSpacingLeft = 2.0f;
    float iconSpacingRight = 2.0f;
    float padding = 0.0f;
    float indentSpacing;
    Node overNode;
    Node rangeStart;
    private float leftColumnWidth;
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid = true;
    private Node foundNode;
    private ClickListener clickListener;

    public TreeElement() {
        this(Core.scene.getStyle(TreeStyle.class));
    }

    public TreeElement(TreeStyle style) {
        this.selection.setActor(this);
        this.selection.setMultiple(true);
        this.setStyle(style);
        this.initialize();
    }

    static boolean findExpandedObjects(Array<Node> nodes, Array<Object> objects) {
        boolean expanded = false;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            if (!node.expanded || TreeElement.findExpandedObjects(node.children, objects)) continue;
            objects.add(node.object);
        }
        return expanded;
    }

    static Node findNode(Array<Node> nodes, Object object) {
        Node node;
        int i;
        int n = nodes.size;
        for (i = 0; i < n; ++i) {
            node = nodes.get(i);
            if (!object.equals(node.object)) continue;
            return node;
        }
        n = nodes.size;
        for (i = 0; i < n; ++i) {
            node = nodes.get(i);
            Node found = TreeElement.findNode(node.children, object);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static void collapseAll(Array<Node> nodes) {
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            node.setExpanded(false);
            TreeElement.collapseAll(node.children);
        }
    }

    static void expandAll(Array<Node> nodes) {
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            nodes.get(i).expandAll();
        }
    }

    private void initialize() {
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Node node = TreeElement.this.getNodeAt(y);
                if (node == null) {
                    return;
                }
                if (node != TreeElement.this.getNodeAt(this.getTouchDownY())) {
                    return;
                }
                if (TreeElement.this.selection.getMultiple() && TreeElement.this.selection.hasItems() && Core.input.shift()) {
                    float end;
                    float start;
                    if (TreeElement.this.rangeStart == null) {
                        TreeElement.this.rangeStart = node;
                    }
                    Node rangeStart = TreeElement.this.rangeStart;
                    if (!Core.input.ctrl()) {
                        TreeElement.this.selection.clear();
                    }
                    if ((start = rangeStart.element.getY()) > (end = node.element.getY())) {
                        TreeElement.this.selectNodes(TreeElement.this.rootNodes, end, start);
                    } else {
                        TreeElement.this.selectNodes(TreeElement.this.rootNodes, start, end);
                        TreeElement.this.selection.items().orderedItems().reverse();
                    }
                    TreeElement.this.selection.fireChangeEvent();
                    TreeElement.this.rangeStart = rangeStart;
                    return;
                }
                if (!(node.children.size <= 0 || TreeElement.this.selection.getMultiple() && Core.input.ctrl())) {
                    float rowX = node.element.getX();
                    if (node.icon != null) {
                        rowX -= TreeElement.this.iconSpacingRight + node.icon.getMinWidth();
                    }
                    if (x < rowX) {
                        node.setExpanded(!node.expanded);
                        return;
                    }
                }
                if (!node.isSelectable()) {
                    return;
                }
                TreeElement.this.selection.choose(node);
                if (!TreeElement.this.selection.isEmpty()) {
                    TreeElement.this.rangeStart = node;
                }
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                TreeElement.this.setOverNode(TreeElement.this.getNodeAt(y));
                return false;
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
                super.exit(event, x, y, pointer, toActor);
                if (toActor == null || !toActor.isDescendantOf(TreeElement.this)) {
                    TreeElement.this.setOverNode(null);
                }
            }
        };
        this.addListener(this.clickListener);
    }

    public void add(Node node) {
        this.insert(this.rootNodes.size, node);
    }

    public void insert(int index, Node node) {
        this.remove(node);
        node.parent = null;
        this.rootNodes.insert(index, node);
        node.addToTree(this);
        this.invalidateHierarchy();
    }

    public void remove(Node node) {
        if (node.parent != null) {
            node.parent.remove(node);
            return;
        }
        this.rootNodes.removeValue(node, true);
        node.removeFromTree(this);
        this.invalidateHierarchy();
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.setOverNode(null);
        this.rootNodes.clear();
        this.selection.clear();
    }

    public Array<Node> getNodes() {
        return this.rootNodes;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = this.style.plus.getMinWidth();
        this.prefWidth = Math.max(this.prefWidth, this.style.minus.getMinWidth());
        this.prefHeight = this.getHeight();
        this.leftColumnWidth = 0.0f;
        this.computeSize(this.rootNodes, this.indentSpacing);
        this.leftColumnWidth += this.iconSpacingLeft + this.padding;
        this.prefWidth += this.leftColumnWidth + this.padding;
        this.prefHeight = this.getHeight() - this.prefHeight;
    }

    private void computeSize(Array<Node> nodes, float indent) {
        float ySpacing = this.ySpacing;
        float spacing = this.iconSpacingLeft + this.iconSpacingRight;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            float rowWidth = indent + this.iconSpacingRight;
            Element element = node.element;
            if (element instanceof Layout) {
                rowWidth += element.getPrefWidth();
                node.height = element.getPrefHeight();
                element.pack();
            } else {
                rowWidth += element.getWidth();
                node.height = element.getHeight();
            }
            if (node.icon != null) {
                rowWidth += spacing + node.icon.getMinWidth();
                node.height = Math.max(node.height, node.icon.getMinHeight());
            }
            this.prefWidth = Math.max(this.prefWidth, rowWidth);
            this.prefHeight -= node.height + ySpacing;
            if (!node.expanded) continue;
            this.computeSize(node.children, indent + this.indentSpacing);
        }
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        this.layout(this.rootNodes, this.leftColumnWidth + this.indentSpacing + this.iconSpacingRight, this.getHeight() - this.ySpacing / 2.0f);
    }

    private float layout(Array<Node> nodes, float indent, float y) {
        float ySpacing = this.ySpacing;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            float x = indent;
            if (node.icon != null) {
                x += node.icon.getMinWidth();
            }
            node.element.setPosition(x, y -= node.getHeight());
            y -= ySpacing;
            if (!node.expanded) continue;
            y = this.layout(node.children, indent + this.indentSpacing, y);
        }
        return y;
    }

    @Override
    public void draw() {
        this.drawBackground();
        Color color = this.getColor();
        Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
        this.draw(this.rootNodes, this.leftColumnWidth);
        super.draw();
    }

    protected void drawBackground() {
        if (this.style.background != null) {
            Color color = this.getColor();
            Draw.color(color.r, color.g, color.b, color.a * this.parentAlpha);
            this.style.background.draw(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    private void draw(Array<Node> nodes, float indent) {
        Drawable plus = this.style.plus;
        Drawable minus = this.style.minus;
        float x = this.getX();
        float y = this.getY();
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            Element element = node.element;
            if (this.selection.contains(node) && this.style.selection != null) {
                this.style.selection.draw(x, y + element.getY() - this.ySpacing / 2.0f, this.getWidth(), node.height + this.ySpacing);
            } else if (node == this.overNode && this.style.over != null) {
                this.style.over.draw(x, y + element.getY() - this.ySpacing / 2.0f, this.getWidth(), node.height + this.ySpacing);
            }
            if (node.icon != null) {
                float iconY = element.getY() + (float)Math.round((node.height - node.icon.getMinHeight()) / 2.0f);
                Draw.color(element.getColor());
                node.icon.draw(x + node.element.getX() - this.iconSpacingRight - node.icon.getMinWidth(), y + iconY, node.icon.getMinWidth(), node.icon.getMinHeight());
                Draw.color(Color.white);
            }
            if (node.children.size == 0) continue;
            Drawable expandIcon = node.expanded ? minus : plus;
            float iconY = element.getY() + (float)Math.round((node.height - expandIcon.getMinHeight()) / 2.0f);
            expandIcon.draw(x + indent - this.iconSpacingLeft, y + iconY, expandIcon.getMinWidth(), expandIcon.getMinHeight());
            if (!node.expanded) continue;
            this.draw(node.children, indent + this.indentSpacing);
        }
    }

    public Node getNodeAt(float y) {
        this.foundNode = null;
        this.getNodeAt(this.rootNodes, y, this.getHeight());
        return this.foundNode;
    }

    private float getNodeAt(Array<Node> nodes, float y, float rowY) {
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            float height = node.height;
            if (y >= (rowY -= node.getHeight() - height) - height - this.ySpacing && y < rowY) {
                this.foundNode = node;
                return -1.0f;
            }
            rowY -= height + this.ySpacing;
            if (!node.expanded || (rowY = this.getNodeAt(node.children, y, rowY)) != -1.0f) continue;
            return -1.0f;
        }
        return rowY;
    }

    void selectNodes(Array<Node> nodes, float low, float high) {
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes.get(i);
            if (node.element.getY() < low) break;
            if (!node.isSelectable()) continue;
            if (node.element.getY() <= high) {
                this.selection.add(node);
            }
            if (!node.expanded) continue;
            this.selectNodes(node.children, low, high);
        }
    }

    public Selection<Node> getSelection() {
        return this.selection;
    }

    public TreeStyle getStyle() {
        return this.style;
    }

    public void setStyle(TreeStyle style) {
        this.style = style;
        this.indentSpacing = Math.max(style.plus.getMinWidth(), style.minus.getMinWidth()) + this.iconSpacingLeft;
    }

    public Array<Node> getRootNodes() {
        return this.rootNodes;
    }

    public Node getOverNode() {
        return this.overNode;
    }

    public void setOverNode(Node overNode) {
        this.overNode = overNode;
    }

    public Object getOverObject() {
        if (this.overNode == null) {
            return null;
        }
        return this.overNode.getObject();
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public float getIndentSpacing() {
        return this.indentSpacing;
    }

    public float getYSpacing() {
        return this.ySpacing;
    }

    public void setYSpacing(float ySpacing) {
        this.ySpacing = ySpacing;
    }

    public void setIconSpacing(float left, float right) {
        this.iconSpacingLeft = left;
        this.iconSpacingRight = right;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public void findExpandedObjects(Array objects) {
        TreeElement.findExpandedObjects(this.rootNodes, objects);
    }

    public void restoreExpandedObjects(Array objects) {
        int n = objects.size;
        for (int i = 0; i < n; ++i) {
            Node node = this.findNode(objects.get(i));
            if (node == null) continue;
            node.setExpanded(true);
            node.expandTo();
        }
    }

    public Node findNode(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        return TreeElement.findNode(this.rootNodes, object);
    }

    public void collapseAll() {
        TreeElement.collapseAll(this.rootNodes);
    }

    public void expandAll() {
        TreeElement.expandAll(this.rootNodes);
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public static class TreeStyle {
        public Drawable plus;
        public Drawable minus;
        public Drawable over;
        public Drawable selection;
        public Drawable background;

        public TreeStyle() {
        }

        public TreeStyle(Drawable plus, Drawable minus, Drawable selection) {
            this.plus = plus;
            this.minus = minus;
            this.selection = selection;
        }

        public TreeStyle(TreeStyle style) {
            this.plus = style.plus;
            this.minus = style.minus;
            this.selection = style.selection;
        }
    }

    public static class Node {
        final Element element;
        final Array<Node> children = new Array(0);
        Node parent;
        boolean selectable = true;
        boolean expanded;
        Drawable icon;
        float height;
        Object object;

        public Node(Element element) {
            if (element == null) {
                throw new IllegalArgumentException("element cannot be null.");
            }
            this.element = element;
        }

        protected void addToTree(TreeElement tree) {
            tree.addChild(this.element);
            if (!this.expanded) {
                return;
            }
            int n = this.children.size;
            for (int i = 0; i < n; ++i) {
                this.children.get(i).addToTree(tree);
            }
        }

        protected void removeFromTree(TreeElement tree) {
            tree.removeChild(this.element);
            if (!this.expanded) {
                return;
            }
            T[] children = this.children.items;
            int n = this.children.size;
            for (int i = 0; i < n; ++i) {
                ((Node)children[i]).removeFromTree(tree);
            }
        }

        public void add(Node node) {
            this.insert(this.children.size, node);
        }

        public void addAll(Array<Node> nodes) {
            int n = nodes.size;
            for (int i = 0; i < n; ++i) {
                this.insert(this.children.size, nodes.get(i));
            }
        }

        public void insert(int index, Node node) {
            node.parent = this;
            this.children.insert(index, node);
            this.updateChildren();
        }

        public void remove() {
            TreeElement tree = this.getTree();
            if (tree != null) {
                tree.remove(this);
            } else if (this.parent != null) {
                this.parent.remove(this);
            }
        }

        public void remove(Node node) {
            this.children.removeValue(node, true);
            if (!this.expanded) {
                return;
            }
            TreeElement tree = this.getTree();
            if (tree == null) {
                return;
            }
            node.removeFromTree(tree);
            if (this.children.size == 0) {
                this.expanded = false;
            }
        }

        public void removeAll() {
            TreeElement tree = this.getTree();
            if (tree != null) {
                int n = this.children.size;
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).removeFromTree(tree);
                }
            }
            this.children.clear();
        }

        public TreeElement getTree() {
            Group parent = this.element.getParent();
            if (!(parent instanceof TreeElement)) {
                return null;
            }
            return (TreeElement)parent;
        }

        public Element getActor() {
            return this.element;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            if (expanded == this.expanded) {
                return;
            }
            this.expanded = expanded;
            if (this.children.size == 0) {
                return;
            }
            TreeElement tree = this.getTree();
            if (tree == null) {
                return;
            }
            if (expanded) {
                int n = this.children.size;
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).addToTree(tree);
                }
            } else {
                int n = this.children.size;
                for (int i = 0; i < n; ++i) {
                    this.children.get(i).removeFromTree(tree);
                }
            }
            tree.invalidateHierarchy();
        }

        public Array<Node> getChildren() {
            return this.children;
        }

        public void updateChildren() {
            if (!this.expanded) {
                return;
            }
            TreeElement tree = this.getTree();
            if (tree == null) {
                return;
            }
            int n = this.children.size;
            for (int i = 0; i < n; ++i) {
                this.children.get(i).addToTree(tree);
            }
        }

        public Node getParent() {
            return this.parent;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public int getLevel() {
            int level = 0;
            Node current = this;
            do {
                ++level;
            } while ((current = current.getParent()) != null);
            return level;
        }

        public Node findNode(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            if (object.equals(this.object)) {
                return this;
            }
            return TreeElement.findNode(this.children, object);
        }

        public void collapseAll() {
            this.setExpanded(false);
            TreeElement.collapseAll(this.children);
        }

        public void expandAll() {
            this.setExpanded(true);
            if (this.children.size > 0) {
                TreeElement.expandAll(this.children);
            }
        }

        public void expandTo() {
            Node node = this.parent;
            while (node != null) {
                node.setExpanded(true);
                node = node.parent;
            }
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }

        public void findExpandedObjects(Array<Object> objects) {
            if (this.expanded && !TreeElement.findExpandedObjects(this.children, objects)) {
                objects.add(this.object);
            }
        }

        public void restoreExpandedObjects(Array objects) {
            int n = objects.size;
            for (int i = 0; i < n; ++i) {
                Node node = this.findNode(objects.get(i));
                if (node == null) continue;
                node.setExpanded(true);
                node.expandTo();
            }
        }

        public float getHeight() {
            return this.height;
        }
    }
}

