/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui.layout;

import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Style;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.StaticReset;
import io.anuke.arc.util.pooling.Pool;

public class Cell<T extends Element>
implements Pool.Poolable {
    private static Cell defaults;
    private static StaticReset reset;
    static final float unset = Float.NEGATIVE_INFINITY;
    float minWidth;
    float minHeight;
    float maxWidth;
    float maxHeight;
    float padTop;
    float padLeft;
    float padBottom;
    float padRight;
    float fillX;
    float fillY;
    int align;
    int expandX;
    int expandY;
    int colspan;
    boolean uniformX;
    boolean uniformY;
    Element element;
    float elementX;
    float elementY;
    float elementWidth;
    float elementHeight;
    boolean endRow;
    int column;
    int row;
    int cellAboveIndex;
    float computedPadTop;
    float computedPadLeft;
    float computedPadBottom;
    float computedPadRight;
    private Table table;

    public Cell() {
        this.reset();
    }

    public static Cell defaults() {
        if (reset.check()) {
            defaults = new Cell();
            Cell.defaults.minWidth = Float.NEGATIVE_INFINITY;
            Cell.defaults.minHeight = Float.NEGATIVE_INFINITY;
            Cell.defaults.maxWidth = Float.NEGATIVE_INFINITY;
            Cell.defaults.maxHeight = Float.NEGATIVE_INFINITY;
            Cell.defaults.padTop = 0.0f;
            Cell.defaults.padLeft = 0.0f;
            Cell.defaults.padBottom = 0.0f;
            Cell.defaults.padRight = 0.0f;
            Cell.defaults.fillX = 0.0f;
            Cell.defaults.fillY = 0.0f;
            Cell.defaults.align = 0;
            Cell.defaults.expandX = 0;
            Cell.defaults.expandY = 0;
            Cell.defaults.colspan = 1;
            Cell.defaults.uniformX = false;
            Cell.defaults.uniformY = false;
        }
        return defaults;
    }

    public void setLayout(Table table) {
        this.table = table;
    }

    public <A extends Element> Cell<A> setElement(A newElement) {
        if (this.element != newElement) {
            if (this.element != null) {
                this.element.remove();
            }
            this.element = newElement;
            if (newElement != null) {
                this.table.addChild(newElement);
            }
        }
        return this;
    }

    public Cell<T> clearElement() {
        this.setElement(null);
        return this;
    }

    public T get() {
        return (T)this.element;
    }

    public boolean hasElement() {
        return this.element != null;
    }

    public float prefWidth() {
        return this.element == null ? 0.0f : this.element.getPrefWidth();
    }

    public float prefHeight() {
        return this.element == null ? 0.0f : this.element.getPrefHeight();
    }

    public float maxWidth() {
        return this.maxWidth == Float.NEGATIVE_INFINITY ? (this.element == null ? 0.0f : this.element.getMaxWidth()) : this.maxWidth;
    }

    public float maxHeight() {
        return this.maxHeight == Float.NEGATIVE_INFINITY ? (this.element == null ? 0.0f : this.element.getMaxHeight()) : this.maxHeight;
    }

    public float minWidth() {
        return this.minWidth == Float.NEGATIVE_INFINITY ? (this.element == null ? 0.0f : this.element.getMinWidth()) : this.minWidth;
    }

    public float minHeight() {
        return this.minHeight == Float.NEGATIVE_INFINITY ? (this.element == null ? 0.0f : this.element.getMinHeight()) : this.minHeight;
    }

    public Cell<T> size(float size) {
        this.maxWidth = this.maxHeight = this.scl(size);
        this.minHeight = this.maxHeight;
        this.minWidth = this.maxHeight;
        return this;
    }

    public Cell<T> size(float width, float height) {
        this.minWidth = this.maxWidth = this.scl(width);
        this.minHeight = this.maxHeight = this.scl(height);
        return this;
    }

    public Cell<T> name(String name) {
        ((Element)this.get()).setName(name);
        return this;
    }

    public Cell<T> update(Consumer<T> updater) {
        Object t = this.get();
        ((Element)t).update(() -> updater.accept(t));
        return this;
    }

    public Cell<T> disabled(Predicate<T> vis) {
        if (this.get() instanceof Button) {
            Object t = this.get();
            ((Button)this.get()).setDisabled(() -> vis.test(t));
        }
        return this;
    }

    public Cell<T> disabled(boolean disabled) {
        if (this.get() instanceof Button) {
            ((Button)this.get()).setDisabled(disabled);
        }
        return this;
    }

    public Cell<T> touchable(Touchable touchable) {
        ((Element)this.get()).touchable(touchable);
        return this;
    }

    public Cell<T> touchable(Supplier<Touchable> touchable) {
        ((Element)this.get()).touchable(touchable);
        return this;
    }

    public Cell<T> visible(BooleanProvider prov) {
        ((Element)this.get()).visible(prov);
        return this;
    }

    public Cell<T> visible(boolean visible) {
        ((Element)this.get()).visible(visible);
        return this;
    }

    public Cell<T> valid(TextField.TextFieldValidator val) {
        if (this.get() instanceof TextField) {
            ((TextField)this.get()).setValidator(val);
        }
        return this;
    }

    public Cell<T> wrap() {
        if (this.get() instanceof Label) {
            ((Label)this.get()).setWrap(true);
        } else if (this.get() instanceof TextButton) {
            ((TextButton)this.get()).getLabel().setWrap(true);
        }
        return this;
    }

    public Cell<T> labelAlign(int label, int line) {
        if (this.get() instanceof Label) {
            ((Label)this.get()).setAlignment(label, line);
        }
        return this;
    }

    public <N extends Button> Cell<T> group(ButtonGroup<N> group) {
        if (this.get() instanceof Button) {
            group.add((N)((Button)this.get()));
        }
        return this;
    }

    public Cell<T> checked(boolean toggle) {
        if (this.get() instanceof Button) {
            ((Button)this.get()).setChecked(toggle);
        }
        return this;
    }

    public Cell<T> checked(Predicate<T> toggle) {
        Object t = this.get();
        if (t instanceof Button) {
            ((Element)t).update(() -> ((Button)t).setChecked(toggle.test(t)));
        }
        return this;
    }

    public Cell<T> fontScale(float scale) {
        if (this.element instanceof Label) {
            ((Label)this.element).setFontScale(scale);
        }
        return this;
    }

    public Cell<T> color(Color color) {
        ((Element)this.get()).setColor(color);
        return this;
    }

    public Cell<T> margin(float margin) {
        if (this.get() instanceof Table) {
            ((Table)this.get()).margin(margin);
        }
        return this;
    }

    public Cell<T> marginTop(float margin) {
        if (this.get() instanceof Table) {
            ((Table)this.get()).marginTop(margin);
        }
        return this;
    }

    public Cell<T> marginBottom(float margin) {
        if (this.get() instanceof Table) {
            ((Table)this.get()).marginBottom(margin);
        }
        return this;
    }

    public Cell<T> marginLeft(float margin) {
        if (this.get() instanceof Table) {
            ((Table)this.get()).marginLeft(margin);
        }
        return this;
    }

    public Cell<T> marginRight(float margin) {
        if (this.get() instanceof Table) {
            ((Table)this.get()).marginRight(margin);
        }
        return this;
    }

    public Cell<T> width(float width) {
        this.minWidth = this.maxWidth = this.scl(width);
        return this;
    }

    public Cell<T> style(Style style) {
        if (this.element instanceof Label) {
            ((Label)this.element).setStyle((Label.LabelStyle)style);
        } else if (this.element instanceof Button) {
            ((Button)this.element).setStyle((Button.ButtonStyle)style);
        } else if (this.element instanceof ScrollPane) {
            ((ScrollPane)this.element).setStyle((ScrollPane.ScrollPaneStyle)style);
        }
        return this;
    }

    public Cell<T> height(float height) {
        this.minHeight = this.maxHeight = this.scl(height);
        return this;
    }

    public Cell<T> minSize(float size) {
        this.minWidth = this.minHeight = this.scl(size);
        return this;
    }

    public Cell<T> minSize(float width, float height) {
        this.minWidth = this.minHeight = this.scl(width);
        return this;
    }

    public Cell<T> minWidth(float minWidth) {
        this.minWidth = this.scl(minWidth);
        return this;
    }

    public Cell<T> minHeight(float minHeight) {
        this.minHeight = this.scl(minHeight);
        return this;
    }

    public Cell<T> maxSize(float size) {
        this.maxWidth = this.maxHeight = this.scl(size);
        return this;
    }

    public Cell<T> maxSize(float width, float height) {
        this.maxWidth = this.maxHeight = this.scl(width);
        return this;
    }

    public Cell<T> maxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Cell<T> maxHeight(float maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Cell<T> pad(float pad) {
        this.padBottom = this.padRight = this.scl(pad);
        this.padLeft = this.padRight;
        this.padTop = this.padRight;
        return this;
    }

    public Cell<T> pad(float top, float left, float bottom, float right) {
        this.padTop = this.scl(top);
        this.padLeft = this.scl(left);
        this.padBottom = this.scl(bottom);
        this.padRight = this.scl(right);
        return this;
    }

    public Cell<T> padTop(float padTop) {
        this.padTop = this.scl(padTop);
        return this;
    }

    public Cell<T> padLeft(float padLeft) {
        this.padLeft = this.scl(padLeft);
        return this;
    }

    public Cell<T> padBottom(float padBottom) {
        this.padBottom = this.scl(padBottom);
        return this;
    }

    public Cell<T> padRight(float padRight) {
        this.padRight = this.scl(padRight);
        return this;
    }

    public Cell<T> fill() {
        this.fillX = 1.0f;
        this.fillY = 1.0f;
        return this;
    }

    public Cell<T> fillX() {
        this.fillX = 1.0f;
        return this;
    }

    public Cell<T> fillY() {
        this.fillY = 1.0f;
        return this;
    }

    public Cell<T> fill(float x, float y) {
        this.fillX = x;
        this.fillY = y;
        return this;
    }

    public Cell<T> fill(boolean x, boolean y) {
        this.fillX = x ? 1.0f : 0.0f;
        this.fillY = y ? 1.0f : 0.0f;
        return this;
    }

    public Cell<T> fill(boolean fill) {
        this.fillX = fill ? 1.0f : 0.0f;
        this.fillY = fill ? 1.0f : 0.0f;
        return this;
    }

    public Cell<T> align(int align) {
        this.align = align;
        return this;
    }

    public Cell<T> center() {
        this.align = 1;
        return this;
    }

    public Cell<T> top() {
        this.align = (this.align | 2) & 0xFFFFFFFB;
        return this;
    }

    public Cell<T> left() {
        this.align = (this.align | 8) & 0xFFFFFFEF;
        return this;
    }

    public Cell<T> bottom() {
        this.align = (this.align | 4) & 0xFFFFFFFD;
        return this;
    }

    public Cell<T> right() {
        this.align = (this.align | 0x10) & 0xFFFFFFF7;
        return this;
    }

    public Cell<T> grow() {
        this.expandX = 1;
        this.expandY = 1;
        this.fillX = 1.0f;
        this.fillY = 1.0f;
        return this;
    }

    public Cell<T> growX() {
        this.expandX = 1;
        this.fillX = 1.0f;
        return this;
    }

    public Cell<T> growY() {
        this.expandY = 1;
        this.fillY = 1.0f;
        return this;
    }

    public Cell<T> expand() {
        this.expandX = 1;
        this.expandY = 1;
        return this;
    }

    public Cell<T> expandX() {
        this.expandX = 1;
        return this;
    }

    public Cell<T> expandY() {
        this.expandY = 1;
        return this;
    }

    public Cell<T> expand(int x, int y) {
        this.expandX = x;
        this.expandY = y;
        return this;
    }

    public Cell<T> expand(boolean x, boolean y) {
        this.expandX = x ? 1 : 0;
        this.expandY = y ? 1 : 0;
        return this;
    }

    public Cell<T> colspan(int colspan) {
        this.colspan = colspan;
        return this;
    }

    public Cell<T> uniform() {
        this.uniformX = true;
        this.uniformY = true;
        return this;
    }

    public Cell<T> uniformX() {
        this.uniformX = true;
        return this;
    }

    public Cell<T> uniformY() {
        this.uniformY = true;
        return this;
    }

    public Cell<T> uniform(boolean x, boolean y) {
        this.uniformX = x;
        this.uniformY = y;
        return this;
    }

    public void setBounds(float x, float y, float width, float height) {
        this.elementX = x;
        this.elementY = y;
        this.elementWidth = width;
        this.elementHeight = height;
    }

    public boolean isEndRow() {
        return this.endRow;
    }

    public void row() {
        this.table.row();
    }

    public Table getTable() {
        return this.table;
    }

    void clear() {
        this.minWidth = Float.NEGATIVE_INFINITY;
        this.minHeight = Float.NEGATIVE_INFINITY;
        this.maxWidth = Float.NEGATIVE_INFINITY;
        this.maxHeight = Float.NEGATIVE_INFINITY;
        this.padTop = 0.0f;
        this.padLeft = 0.0f;
        this.padBottom = 0.0f;
        this.padRight = 0.0f;
        this.fillX = 0.0f;
        this.fillY = 0.0f;
        this.align = 0;
        this.expandX = 0;
        this.expandY = 0;
        this.colspan = 1;
        this.uniformX = false;
        this.uniformY = false;
    }

    float scl(float value) {
        return Scl.scl(value);
    }

    @Override
    public void reset() {
        this.element = null;
        this.table = null;
        this.endRow = false;
        this.cellAboveIndex = -1;
        Cell defaults = Cell.defaults();
        if (defaults != null) {
            this.set(defaults);
        }
    }

    public Cell<T> set(Cell cell) {
        this.minWidth = cell.minWidth;
        this.minHeight = cell.minHeight;
        this.maxWidth = cell.maxWidth;
        this.maxHeight = cell.maxHeight;
        this.padTop = cell.padTop;
        this.padLeft = cell.padLeft;
        this.padBottom = cell.padBottom;
        this.padRight = cell.padRight;
        this.fillX = cell.fillX;
        this.fillY = cell.fillY;
        this.align = cell.align;
        this.expandX = cell.expandX;
        this.expandY = cell.expandY;
        this.colspan = cell.colspan;
        this.uniformX = cell.uniformX;
        this.uniformY = cell.uniformY;
        return this;
    }

    public String toString() {
        return this.element != null ? this.element.toString() : super.toString();
    }

    static {
        reset = new StaticReset();
    }
}

