/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.scene.ui.layout;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.scene.Action;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.scene.ui.layout.WidgetGroup;
import io.anuke.arc.util.ArcRuntimeException;

public class Collapser
extends WidgetGroup {
    private Table table;
    private CollapseAction collapseAction = new CollapseAction();
    private boolean collapsed;
    private boolean actionRunning;
    private float currentHeight;
    private float seconds = 0.5f;

    public Collapser(Consumer<Table> cons, boolean collapsed) {
        this.table = new Table();
        this.collapsed = collapsed;
        this.setTransform(true);
        cons.accept(this.table);
        this.updateTouchable();
        this.addChild(this.table);
    }

    public void toggle() {
        this.setCollapsed(!this.isCollapsed());
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.updateTouchable();
        if (this.table == null) {
            return;
        }
        this.actionRunning = true;
        if (withAnimation) {
            this.addAction(this.collapseAction);
        } else {
            if (collapse) {
                this.currentHeight = 0.0f;
                this.collapsed = true;
            } else {
                this.currentHeight = this.table.getPrefHeight();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private void updateTouchable() {
        this.touchable(this.collapsed ? Touchable.disabled : Touchable.enabled);
    }

    @Override
    public void draw() {
        if (this.currentHeight > 1.0f) {
            Draw.flush();
            if (this.clipBegin(this.getX(), this.getY(), this.getWidth(), this.currentHeight)) {
                super.draw();
                Draw.flush();
                this.clipEnd();
            }
        }
    }

    @Override
    public void layout() {
        if (this.table == null) {
            return;
        }
        this.table.setBounds(0.0f, 0.0f, this.getWidth(), this.getHeight());
        if (!this.actionRunning) {
            this.currentHeight = this.collapsed ? 0.0f : this.table.getPrefHeight();
        }
    }

    @Override
    public float getPrefWidth() {
        return this.table == null ? 0.0f : this.table.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.table == null) {
            return 0.0f;
        }
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefHeight();
        }
        return this.currentHeight;
    }

    public void setTable(Table table) {
        this.table = table;
        this.clearChildren();
        this.addChild(table);
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.getChildren().size > 1) {
            throw new ArcRuntimeException("Only one actor can be added to CollapsibleWidget");
        }
    }

    private class CollapseAction
    extends Action {
        private CollapseAction() {
        }

        @Override
        public boolean act(float delta) {
            if (Collapser.this.collapsed) {
                Collapser.this.currentHeight = Collapser.this.currentHeight - delta * Collapser.this.table.getPrefHeight() / Collapser.this.seconds;
                if (Collapser.this.currentHeight <= 0.0f) {
                    Collapser.this.currentHeight = 0.0f;
                    Collapser.this.actionRunning = false;
                }
            } else {
                Collapser.this.currentHeight = Collapser.this.currentHeight + delta * Collapser.this.table.getPrefHeight() / Collapser.this.seconds;
                if (Collapser.this.currentHeight > Collapser.this.table.getPrefHeight()) {
                    Collapser.this.currentHeight = Collapser.this.table.getPrefHeight();
                    Collapser.this.actionRunning = false;
                }
            }
            Collapser.this.invalidateHierarchy();
            return !Collapser.this.actionRunning;
        }
    }
}

