/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Time;

public class Bench {
    private static long totalStart;
    private static String lastName;
    private static ObjectMap<String, Long> times;
    private static long last;

    public static void begin(String name) {
        if (lastName != null) {
            Bench.endi();
        } else {
            totalStart = Time.millis();
        }
        last = Time.millis();
        lastName = name;
    }

    public static void end() {
        Bench.endi();
        long total = Time.timeSinceMillis(totalStart);
        times.each((name, time) -> Log.info("[PERF] {0}: {1}ms ({2}%)", name, time, (int)((float)time.longValue() / (float)total * 100.0f)));
        Log.info("[PERF] TOTAL: {0}ms", total);
    }

    private static void endi() {
        times.put(lastName, Time.timeSinceMillis(last));
        lastName = null;
    }

    static {
        times = new ObjectMap();
    }
}

