/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.util.Time;
import java.util.Arrays;

public class Interval {
    float[] times;

    public Interval(int capacity) {
        this.times = new float[capacity];
    }

    public Interval() {
        this(1);
    }

    public boolean get(float time) {
        return this.get(0, time);
    }

    public boolean get(int id, float time) {
        if (id >= this.times.length) {
            throw new RuntimeException("Out of bounds! Max timer size is " + this.times.length + "!");
        }
        boolean got = this.check(id, time);
        if (got) {
            this.times[id] = Time.time();
        }
        return got;
    }

    public boolean check(int id, float time) {
        return Time.time() - this.times[id] >= time || Time.time() < this.times[id];
    }

    public void reset(int id, float time) {
        this.times[id] = Time.time() - time;
    }

    public void clear() {
        Arrays.fill(this.times, 0.0f);
    }

    public float getTime(int id) {
        return Time.time() - this.times[id];
    }

    public float[] getTimes() {
        return this.times;
    }
}

