/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.Net;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.async.AsyncExecutor;
import io.anuke.arc.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class NetJavaImpl {
    private final AsyncExecutor asyncExecutor = new AsyncExecutor(6);

    public void http(Net.HttpRequest request, Consumer<Net.HttpResponse> success, Consumer<Throwable> failure) {
        if (request.url == null) {
            failure.accept(new ArcRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            URL url;
            Net.HttpMethod method = request.method;
            if (method == Net.HttpMethod.GET) {
                String queryString = "";
                String value = request.content;
                if (value != null && !"".equals(value)) {
                    queryString = "?" + value;
                }
                url = new URL(request.url + queryString);
            } else {
                url = new URL(request.url);
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            boolean doingOutPut = method == Net.HttpMethod.POST || method == Net.HttpMethod.PUT;
            connection.setDoOutput(doingOutPut);
            connection.setDoInput(true);
            connection.setRequestMethod(method.toString());
            HttpURLConnection.setFollowRedirects(request.followRedirects);
            request.headers.each(connection::addRequestProperty);
            connection.setConnectTimeout(request.timeout);
            connection.setReadTimeout(request.timeout);
            this.asyncExecutor.submit(() -> {
                try {
                    if (doingOutPut) {
                        String contentAsString = request.content;
                        if (contentAsString != null) {
                            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
                            try {
                                writer.write(contentAsString);
                            }
                            finally {
                                Streams.closeQuietly(writer);
                            }
                        }
                        InputStream contentAsStream = request.contentStream;
                        if (contentAsStream != null) {
                            OutputStream os = connection.getOutputStream();
                            try {
                                Streams.copyStream(contentAsStream, os);
                            }
                            finally {
                                Streams.closeQuietly(os);
                            }
                        }
                    }
                    connection.connect();
                    HttpClientResponse clientResponse = new HttpClientResponse(connection);
                    try {
                        success.accept(clientResponse);
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                catch (Exception e) {
                    connection.disconnect();
                    failure.accept(e);
                }
                return null;
            });
        }
        catch (Exception e) {
            failure.accept(e);
        }
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private final HttpURLConnection connection;
        private Net.HttpStatus status;

        public HttpClientResponse(HttpURLConnection connection) {
            this.connection = connection;
            try {
                this.status = Net.HttpStatus.byCode(connection.getResponseCode());
            }
            catch (IOException e) {
                this.status = Net.HttpStatus.UNNOWN_STATUS;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getResult() {
            InputStream input = this.getInputStream();
            if (input == null) {
                return Streams.EMPTY_BYTES;
            }
            try {
                byte[] byArray = Streams.copyStreamToByteArray(input, this.connection.getContentLength());
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = Streams.EMPTY_BYTES;
                return byArray;
            }
            finally {
                Streams.closeQuietly(input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getResultAsString() {
            InputStream input = this.getInputStream();
            if (input == null) {
                return "";
            }
            try {
                String string = Streams.copyStreamToString(input, this.connection.getContentLength());
                return string;
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            finally {
                Streams.closeQuietly(input);
            }
        }

        @Override
        public InputStream getResultAsStream() {
            return this.getInputStream();
        }

        @Override
        public Net.HttpStatus getStatus() {
            return this.status;
        }

        @Override
        public String getHeader(String name) {
            return this.connection.getHeaderField(name);
        }

        @Override
        public ObjectMap<String, Array<String>> getHeaders() {
            ObjectMap<String, Array<String>> out = new ObjectMap<String, Array<String>>();
            Map<String, List<String>> fields = this.connection.getHeaderFields();
            for (String key : fields.keySet()) {
                out.put(key, Array.with(fields.get(key).toArray(new String[0])));
            }
            return out;
        }

        private InputStream getInputStream() {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                return this.connection.getErrorStream();
            }
        }
    }
}

