/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.Core;
import io.anuke.arc.files.FileHandle;

public class OS {
    public static boolean isWindows = System.getProperty("os.name").contains("Windows");
    public static boolean isLinux = System.getProperty("os.name").contains("Linux");
    public static boolean isMac = System.getProperty("os.name").contains("Mac");
    public static boolean isIos = false;
    public static boolean isAndroid = false;
    public static boolean isARM = System.getProperty("os.arch").startsWith("arm") || System.getProperty("os.arch").startsWith("aarch64");
    public static boolean is64Bit = System.getProperty("os.arch").contains("64") || System.getProperty("os.arch").startsWith("armv8");

    public static String getAppDataDirectoryString(String appname) {
        if (isWindows) {
            return OS.getEnv("AppData") + "\\\\" + appname;
        }
        if (isIos || isAndroid) {
            return Core.files.getLocalStoragePath();
        }
        if (isLinux) {
            if (System.getenv("XDG_DATA_HOME") != null) {
                String dir = System.getenv("XDG_DATA_HOME");
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                return dir + appname + "/";
            }
            return OS.getProperty("user.home") + "/.local/share/" + appname + "/";
        }
        if (isMac) {
            return OS.getProperty("user.home") + "/Library/Application Support/" + appname + "/";
        }
        return null;
    }

    public static FileHandle getAppDataDirectory(String appname) {
        return Core.files.absolute(OS.getAppDataDirectoryString(appname));
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static String getEnv(String name) {
        return System.getenv(name);
    }

    public static String getPropertyNotNull(String name) {
        String s = OS.getProperty(name);
        return s == null ? "" : s;
    }

    static {
        boolean isMOEiOS = "iOS".equals(System.getProperty("moe.platform.name"));
        String vm = System.getProperty("java.runtime.name");
        if (vm != null && vm.contains("Android Runtime")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (isMOEiOS || !isAndroid && !isWindows && !isLinux && !isMac) {
            isIos = true;
            isAndroid = false;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
    }
}

