/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util;

import io.anuke.arc.collection.Array;
import io.anuke.arc.util.PerformanceCounter;
import io.anuke.arc.util.Time;

public class PerformanceCounters {
    private static final float nano2seconds = 1.0E-9f;
    public final Array<PerformanceCounter> counters = new Array();
    private long lastTick = 0L;

    public PerformanceCounter add(String name, int windowSize) {
        PerformanceCounter result = new PerformanceCounter(name, windowSize);
        this.counters.add(result);
        return result;
    }

    public PerformanceCounter add(String name) {
        PerformanceCounter result = new PerformanceCounter(name);
        this.counters.add(result);
        return result;
    }

    public void tick() {
        long t = Time.nanos();
        if (this.lastTick > 0L) {
            this.tick((float)(t - this.lastTick) * 1.0E-9f);
        }
        this.lastTick = t;
    }

    public void tick(float deltaTime) {
        for (int i = 0; i < this.counters.size; ++i) {
            this.counters.get(i).tick(deltaTime);
        }
    }

    public String toString() {
        this.counters.sort((a, b) -> -Float.compare(a.load.value, b.load.value));
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        for (int i = 0; i < this.counters.size; ++i) {
            this.counters.get(i).toString(sb);
            if (i == this.counters.size - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

