/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util.io;

import java.io.DataOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ByteBufferOutput
implements DataOutput {
    private ByteBuffer buffer;

    public ByteBufferOutput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferOutput() {
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int i) {
        this.buffer.put((byte)i);
    }

    @Override
    public void write(byte[] bytes) {
        this.buffer.put(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) {
        this.buffer.put(bytes, i, i1);
    }

    @Override
    public void writeBoolean(boolean b) {
        this.buffer.put(b ? (byte)1 : 0);
    }

    @Override
    public void writeByte(int i) {
        this.buffer.put((byte)i);
    }

    @Override
    public void writeShort(int i) {
        this.buffer.putShort((short)i);
    }

    @Override
    public void writeChar(int i) {
        this.buffer.putChar((char)i);
    }

    @Override
    public void writeInt(int i) {
        this.buffer.putInt(i);
    }

    @Override
    public void writeLong(long l) {
        this.buffer.putLong(l);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void writeChars(String s) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void writeUTF(String s) {
        try {
            byte[] bytes = s.getBytes("UTF-8");
            if (bytes.length >= Short.MAX_VALUE) {
                throw new IllegalArgumentException("Input string is too long!");
            }
            this.buffer.putShort((short)bytes.length);
            this.buffer.put(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

