/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.util.noise;

import java.util.Random;

public final class Noise {
    private static final int P = 8;
    private static final int B = 256;
    private static final int M = 255;
    private static final int NP = 8;
    private static final int N = 256;
    public static int seed = 100;
    private static int[] p = new int[514];
    private static double[][] g2 = new double[514][2];
    private static double[] g1 = new double[514];
    private static double[][] points = new double[32][3];

    private static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static double s_curve(double t) {
        return t * t * (3.0 - t - t);
    }

    public static double noise(double x) {
        double t = x + 256.0;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        double rx0 = t - (double)((int)t);
        double rx1 = rx0 - 1.0;
        double sx = Noise.s_curve(rx0);
        double u = rx0 * g1[p[bx0]];
        double v = rx1 * g1[p[bx1]];
        return Noise.lerp(sx, u, v);
    }

    public static double snoise(int x, int y, float scale, float mag, float exp) {
        return Math.pow(Noise.noise((float)x / scale, (float)y / scale) * (double)mag, exp);
    }

    public static float snoise(int x, int y, float scale, float mag) {
        return (float)(Noise.noise((float)x / scale, (float)y / scale) * (double)mag);
    }

    public static float snoise3(int x, int y, int z, float scale, float mag) {
        return (float)(Noise.noise((float)x / scale, (float)y / scale, (float)z / scale) * (double)mag);
    }

    public static float nnoise(int x, int y, float scale, float mag) {
        return (float)((double)Noise.snoise(x, y, scale, mag) / 2.0);
    }

    public static float nnoise(int x, int y, float scale, float mag, float xp) {
        return (float)(Noise.snoise(x, y, scale, mag, xp) / 2.0);
    }

    public static float fnoise(float x, float y, float scale, float mag) {
        return (float)(Noise.noise(x / scale, y / scale) * (double)mag);
    }

    public static double noise(double x, double y) {
        double t = x + 256.0;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        double rx0 = t - (double)((int)t);
        double rx1 = rx0 - 1.0;
        t = y + 256.0;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        double ry0 = t - (double)((int)t);
        double ry1 = ry0 - 1.0;
        int i = p[bx0];
        int j = p[bx1];
        int b00 = p[i + by0];
        int b10 = p[j + by0];
        int b01 = p[i + by1];
        int b11 = p[j + by1];
        double sx = Noise.s_curve(rx0);
        double sy = Noise.s_curve(ry0);
        double[] q = g2[b00];
        double u = rx0 * q[0] + ry0 * q[1];
        q = g2[b10];
        double v = rx1 * q[0] + ry0 * q[1];
        double a = Noise.lerp(sx, u, v);
        q = g2[b01];
        u = rx0 * q[0] + ry1 * q[1];
        q = g2[b11];
        v = rx1 * q[0] + ry1 * q[1];
        double b = Noise.lerp(sx, u, v);
        return Noise.lerp(sy, a, b);
    }

    static double noise(double x, double y, double z) {
        int bx = (int)(Math.floor(x) % 256.0);
        if (bx < 0) {
            bx += 256;
        }
        double rx0 = x - Math.floor(x);
        double rx1 = rx0 - 1.0;
        int by = (int)(Math.floor(y) % 256.0);
        if (by < 0) {
            by += 256;
        }
        double ry0 = y - Math.floor(y);
        double ry1 = ry0 - 1.0;
        int bz = (int)(Math.floor(z) % 256.0);
        if (bz < 0) {
            bz += 256;
        }
        double rz = z - Math.floor(z);
        if (bx < 0 || bx >= 514) {
            System.out.println(bx);
        }
        int b0 = p[bx];
        int b1 = p[++bx];
        int b00 = p[b0 + by];
        int b10 = p[b1 + by];
        int b01 = p[b0 + ++by];
        int b11 = p[b1 + by];
        double sx = Noise.s_curve(rx0);
        double sy = Noise.s_curve(ry0);
        double sz = Noise.s_curve(rz);
        double[] q = Noise.G(b00 + bz);
        double u = rx0 * q[0] + ry0 * q[1] + rz * q[2];
        q = Noise.G(b10 + bz);
        double v = rx1 * q[0] + ry0 * q[1] + rz * q[2];
        double a = Noise.lerp(sx, u, v);
        q = Noise.G(b01 + bz);
        u = rx0 * q[0] + ry1 * q[1] + rz * q[2];
        q = Noise.G(b11 + bz);
        v = rx1 * q[0] + ry1 * q[1] + rz * q[2];
        double b = Noise.lerp(sx, u, v);
        double c = Noise.lerp(sy, a, b);
        q = Noise.G(b00 + ++bz);
        u = rx0 * q[0] + ry0 * q[1] + (rz -= 1.0) * q[2];
        q = Noise.G(b10 + bz);
        v = rx1 * q[0] + ry0 * q[1] + rz * q[2];
        a = Noise.lerp(sx, u, v);
        q = Noise.G(b01 + bz);
        u = rx0 * q[0] + ry1 * q[1] + rz * q[2];
        q = Noise.G(b11 + bz);
        v = rx1 * q[0] + ry1 * q[1] + rz * q[2];
        b = Noise.lerp(sx, u, v);
        double d = Noise.lerp(sy, a, b);
        return Noise.lerp(sz, c, d);
    }

    private static double[] G(int i) {
        return points[i % 32];
    }

    public static void setSeed(int s) {
        seed = s;
        Noise.init();
    }

    private static void init() {
        int j;
        int k;
        int i;
        Random r = new Random(seed);
        for (i = 0; i < 256; ++i) {
            double W;
            double V;
            double U;
            double Lo;
            double Hi;
            double w;
            double v;
            double u;
            Noise.p[i] = i;
            Noise.g1[i] = 2.0 * r.nextDouble() - 1.0;
            while ((u = 2.0 * r.nextDouble() - 1.0) * u + (v = 2.0 * r.nextDouble() - 1.0) * v > 1.0 || Math.abs(u) > 2.5 * Math.abs(v) || Math.abs(v) > 2.5 * Math.abs(u) || Math.abs(Math.abs(u) - Math.abs(v)) < 0.4) {
            }
            Noise.g2[i][0] = u;
            Noise.g2[i][1] = v;
            Noise.normalize2(g2[i]);
            do {
                u = 2.0 * r.nextDouble() - 1.0;
                v = 2.0 * r.nextDouble() - 1.0;
                w = 2.0 * r.nextDouble() - 1.0;
                U = Math.abs(u);
                V = Math.abs(v);
                W = Math.abs(w);
                Lo = Math.min(U, Math.min(V, W));
                Hi = Math.max(U, Math.max(V, W));
            } while (u * u + v * v + w * w > 1.0 || Hi > 4.0 * Lo || Math.min(Math.abs(U - V), Math.min(Math.abs(U - W), Math.abs(V - W))) < 0.2);
        }
        while (--i > 0) {
            k = p[i];
            j = (int)(r.nextLong() & 0xFFL);
            Noise.p[i] = p[j];
            Noise.p[j] = k;
        }
        for (i = 0; i < 258; ++i) {
            Noise.p[256 + i] = p[i];
            Noise.g1[256 + i] = g1[i];
            for (j = 0; j < 2; ++j) {
                Noise.g2[256 + i][j] = g2[i][j];
            }
        }
        double d = Math.sqrt(0.3333333333333333);
        Noise.points[3][2] = d;
        Noise.points[3][1] = d;
        Noise.points[3][0] = d;
        double r2 = Math.sqrt(0.5);
        double s = Math.sqrt(2.0 + r2 + r2);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                Noise.points[i][j] = (i == j ? 1.0 + r2 + r2 : r2) / s;
            }
        }
        for (i = 0; i <= 1; ++i) {
            for (j = 0; j <= 1; ++j) {
                for (k = 0; k <= 1; ++k) {
                    int n = i + j * 2 + k * 4;
                    if (n <= 0) continue;
                    for (int m = 0; m < 4; ++m) {
                        Noise.points[4 * n + m][0] = (double)(i == 0 ? 1 : -1) * points[m][0];
                        Noise.points[4 * n + m][1] = (double)(j == 0 ? 1 : -1) * points[m][1];
                        Noise.points[4 * n + m][2] = (double)(k == 0 ? 1 : -1) * points[m][2];
                    }
                }
            }
        }
    }

    private static void normalize2(double[] v) {
        double s = Math.sqrt(v[0] * v[0] + v[1] * v[1]);
        v[0] = v[0] / s;
        v[1] = v[1] / s;
    }

    static {
        Noise.init();
    }
}

