/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry;

import io.anuke.arc.ApplicationCore;
import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.SpriteBatch;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.ContentLoader;
import io.anuke.mindustry.core.Control;
import io.anuke.mindustry.core.Logic;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.core.NetServer;
import io.anuke.mindustry.core.Platform;
import io.anuke.mindustry.core.Renderer;
import io.anuke.mindustry.core.UI;
import io.anuke.mindustry.game.Content;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Musics;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.maps.MapPreviewLoader;
import io.anuke.mindustry.net.Net;

public abstract class ClientLauncher
extends ApplicationCore
implements Platform {
    private static final int loadingFPS = 20;
    private float smoothProgress;
    private long lastTime;
    private long beginTime;
    private boolean finished = false;

    @Override
    public void setup() {
        Vars.platform = this;
        Log.setUseColors(false);
        this.beginTime = Time.millis();
        Time.setDeltaProvider(() -> {
            float result = Core.graphics.getDeltaTime() * 60.0f;
            return Float.isNaN(result) || Float.isInfinite(result) ? 1.0f : Mathf.clamp(result, 1.0E-4f, 6.0f);
        });
        Core.batch = new SpriteBatch();
        Core.assets = new AssetManager();
        Core.assets.setLoader(Texture.class, ".msav", new MapPreviewLoader());
        Core.assets.load("sprites/error.png", Texture.class);
        Core.atlas = TextureAtlas.blankAtlas();
        Vars.net = new Net(Vars.platform.getNet());
        UI.loadSystemCursors();
        Core.assets.load(new Vars());
        UI.loadDefaultFont();
        Core.assets.load(new AssetDescriptor<TextureAtlas>((String)"sprites/sprites.atlas", TextureAtlas.class)).loaded = t -> {
            Core.atlas = (TextureAtlas)t;
        };
        Core.assets.loadRun("maps", Map.class, () -> Vars.maps.loadPreviews());
        Musics.load();
        Sounds.load();
        Core.assets.loadRun("contentcreate", Content.class, () -> {
            Vars.content.createContent();
            Vars.content.loadColors();
        });
        Vars.logic = new Logic();
        this.add(Vars.logic);
        Vars.control = new Control();
        this.add(Vars.control);
        Vars.renderer = new Renderer();
        this.add(Vars.renderer);
        Vars.ui = new UI();
        this.add(Vars.ui);
        Vars.netServer = new NetServer();
        this.add(Vars.netServer);
        Vars.netClient = new NetClient();
        this.add(Vars.netClient);
        Core.assets.loadRun("contentinit", ContentLoader.class, () -> {
            Vars.content.init();
            Vars.content.load();
        });
    }

    @Override
    public void add(ApplicationListener module) {
        super.add(module);
        if (module instanceof Loadable) {
            Core.assets.load((Loadable)((Object)module));
        }
    }

    @Override
    public void resize(int width, int height) {
        if (Core.assets == null) {
            return;
        }
        if (!Core.assets.isFinished()) {
            Draw.proj().setOrtho(0.0f, 0.0f, width, height);
        } else {
            super.resize(width, height);
        }
    }

    @Override
    public void update() {
        int targetfps;
        if (!this.finished) {
            this.drawLoading();
            if (Core.assets.update(50)) {
                Log.info("Total time to load: {0}", Time.timeSinceMillis(this.beginTime));
                for (ApplicationListener listener : this.modules) {
                    listener.init();
                }
                super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                this.finished = true;
                Events.fire(new EventType.ClientLoadEvent());
            }
        } else {
            super.update();
        }
        if ((targetfps = Core.settings.getInt("fpscap", 120)) > 0 && targetfps <= 240) {
            long target = 1000000000 / targetfps;
            long elapsed = Time.timeSinceNanos(this.lastTime);
            if (elapsed < target) {
                try {
                    Thread.sleep((target - elapsed) / 1000000L, (int)((target - elapsed) % 1000000L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.lastTime = Time.nanos();
    }

    @Override
    public void init() {
        this.setup();
    }

    @Override
    public void resume() {
        if (this.finished) {
            super.resume();
        }
    }

    @Override
    public void pause() {
        if (this.finished) {
            super.pause();
        }
    }

    void drawLoading() {
        this.smoothProgress = Mathf.lerpDelta(this.smoothProgress, Core.assets.getProgress(), 0.1f);
        Core.graphics.clear(Pal.darkerGray);
        Draw.proj().setOrtho(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        float height = Scl.scl(50.0f);
        Draw.color(Color.black);
        Fill.poly((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f, 6, Mathf.dst((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f) * this.smoothProgress);
        Draw.reset();
        float w = (float)Core.graphics.getWidth() * 0.6f;
        Draw.color(Color.black);
        Fill.rect((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f, w, height);
        Draw.color(Pal.accent);
        Fill.crect((float)Core.graphics.getWidth() / 2.0f - w / 2.0f, (float)Core.graphics.getHeight() / 2.0f - height / 2.0f, w * this.smoothProgress, height);
        for (int i : Mathf.signs) {
            Fill.tri((float)Core.graphics.getWidth() / 2.0f + w / 2.0f * (float)i, (float)Core.graphics.getHeight() / 2.0f + height / 2.0f, (float)Core.graphics.getWidth() / 2.0f + w / 2.0f * (float)i, (float)Core.graphics.getHeight() / 2.0f - height / 2.0f, (float)Core.graphics.getWidth() / 2.0f + w / 2.0f * (float)i + height / 2.0f * (float)i, (float)Core.graphics.getHeight() / 2.0f);
        }
        if (Core.assets.isLoaded("outline")) {
            BitmapFont font = (BitmapFont)Core.assets.get("outline");
            font.draw((int)(Core.assets.getProgress() * 100.0f) + "%", (float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f + Scl.scl(10.0f), 1);
            font.draw(Core.bundle.get("loading", "").replace("[accent]", ""), (float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f + height / 2.0f + Scl.scl(20.0f), 1);
            if (Core.assets.getCurrentLoading() != null) {
                String name = Core.assets.getCurrentLoading().fileName.toLowerCase();
                String key = name.contains("content") ? "content" : (name.contains("msav") || name.contains("maps") ? "map" : (name.contains("ogg") || name.contains("mp3") ? "sound" : (name.contains("png") ? "image" : "system")));
                font.draw(Core.bundle.get("load." + key, ""), (float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f - height / 2.0f - Scl.scl(10.0f), 1);
            }
        }
        Draw.flush();
    }
}

