/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry;

import io.anuke.arc.Application;
import io.anuke.arc.Core;
import io.anuke.arc.KeyBinds;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.I18NBundle;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.ai.BlockIndexer;
import io.anuke.mindustry.ai.Pathfinder;
import io.anuke.mindustry.ai.WaveSpawner;
import io.anuke.mindustry.core.ContentLoader;
import io.anuke.mindustry.core.Control;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.core.Logic;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.core.NetServer;
import io.anuke.mindustry.core.Platform;
import io.anuke.mindustry.core.Renderer;
import io.anuke.mindustry.core.UI;
import io.anuke.mindustry.core.World;
import io.anuke.mindustry.entities.Entities;
import io.anuke.mindustry.entities.EntityCollisions;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.EffectEntity;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.DefaultWaves;
import io.anuke.mindustry.game.GlobalData;
import io.anuke.mindustry.game.LoopControl;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Version;
import io.anuke.mindustry.gen.Serialization;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.maps.Maps;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.plugin.Plugins;
import io.anuke.mindustry.world.blocks.defense.ForceProjector;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;

public class Vars
implements Loadable {
    public static boolean loadLocales = true;
    public static final int bufferSize = 8192;
    public static final Charset charset = Charset.forName("UTF-8");
    public static final String appName = "Mindustry";
    public static final String donationURL = "https://anuke.itch.io/mindustry/purchase";
    public static final String discordURL = "https://discord.gg/mindustry";
    public static final String crashReportURL = "http://mins.us.to/report";
    public static final Array<String> defaultServers = Array.with(new String[0]);
    public static final float mineTransferRange = 220.0f;
    public static final Team defaultTeam = Team.sharded;
    public static final Team waveTeam = Team.crux;
    public static final boolean enableUnitEditing = false;
    public static final int maxTextLength = 150;
    public static final int maxNameLength = 40;
    public static final float itemSize = 5.0f;
    public static final float worldBounds = 100.0f;
    public static final float finalWorldBounds = 600.0f;
    public static final float boundsCountdown = 420.0f;
    public static boolean updateEditorOnChange = false;
    public static final int tilesize = 8;
    public static final Color[] playerColors = new Color[]{Color.valueOf("82759a"), Color.valueOf("c0c1c5"), Color.valueOf("fff0e7"), Color.valueOf("7d2953"), Color.valueOf("ff074e"), Color.valueOf("ff072a"), Color.valueOf("ff76a6"), Color.valueOf("a95238"), Color.valueOf("ffa108"), Color.valueOf("feeb2c"), Color.valueOf("ffcaa8"), Color.valueOf("008551"), Color.valueOf("00e339"), Color.valueOf("423c7b"), Color.valueOf("4b5ef1"), Color.valueOf("2cabfe")};
    public static final int port = 6567;
    public static final int multicastPort = 20151;
    public static final String multicastGroup = "227.2.7.7";
    public static boolean disableUI;
    public static boolean testMobile;
    public static boolean mobile;
    public static boolean ios;
    public static boolean android;
    public static boolean headless;
    public static boolean steam;
    public static FileHandle dataDirectory;
    public static FileHandle screenshotDirectory;
    public static FileHandle customMapDirectory;
    public static FileHandle mapPreviewDirectory;
    public static FileHandle tmpDirectory;
    public static FileHandle saveDirectory;
    public static FileHandle pluginDirectory;
    public static final String mapExtension = "msav";
    public static final String saveExtension = "msav";
    public static Locale[] locales;
    public static Net net;
    public static ContentLoader content;
    public static GameState state;
    public static GlobalData data;
    public static EntityCollisions collisions;
    public static DefaultWaves defaultWaves;
    public static LoopControl loops;
    public static Platform platform;
    public static Plugins plugins;
    public static World world;
    public static Maps maps;
    public static WaveSpawner spawner;
    public static BlockIndexer indexer;
    public static Pathfinder pathfinder;
    public static Control control;
    public static Logic logic;
    public static Renderer renderer;
    public static UI ui;
    public static NetServer netServer;
    public static NetClient netClient;
    public static Entities entities;
    public static EntityGroup<Player> playerGroup;
    public static EntityGroup<TileEntity> tileGroup;
    public static EntityGroup<Bullet> bulletGroup;
    public static EntityGroup<EffectEntity> effectGroup;
    public static EntityGroup<DrawTrait> groundEffectGroup;
    public static EntityGroup<ForceProjector.ShieldEntity> shieldGroup;
    public static EntityGroup<Puddle> puddleGroup;
    public static EntityGroup<Fire> fireGroup;
    public static EntityGroup<BaseUnit>[] unitGroups;
    public static Player player;

    @Override
    public void loadAsync() {
        Vars.loadSettings();
        Vars.init();
    }

    /*
     * WARNING - void declaration
     */
    public static void init() {
        Serialization.init();
        if (loadLocales) {
            void var1_2;
            String[] stra = Core.files.internal("locales").readString().split("\n");
            locales = new Locale[stra.length];
            boolean bl = false;
            while (var1_2 < locales.length) {
                String code = stra[var1_2];
                Vars.locales[var1_2] = code.contains("_") ? new Locale(code.split("_")[0], code.split("_")[1]) : new Locale(code);
                ++var1_2;
            }
            Arrays.sort(locales, Structs.comparing(l -> l.getDisplayName((Locale)l), String.CASE_INSENSITIVE_ORDER));
        }
        Version.init();
        content = new ContentLoader();
        loops = new LoopControl();
        defaultWaves = new DefaultWaves();
        collisions = new EntityCollisions();
        world = new World();
        maps = new Maps();
        spawner = new WaveSpawner();
        indexer = new BlockIndexer();
        pathfinder = new Pathfinder();
        entities = new Entities();
        playerGroup = entities.add(Player.class).enableMapping();
        tileGroup = entities.add(TileEntity.class, false);
        bulletGroup = entities.add(Bullet.class).enableMapping();
        effectGroup = entities.add(EffectEntity.class, false);
        groundEffectGroup = entities.add(DrawTrait.class, false);
        puddleGroup = entities.add(Puddle.class).enableMapping();
        shieldGroup = entities.add(ForceProjector.ShieldEntity.class, false);
        fireGroup = entities.add(Fire.class).enableMapping();
        unitGroups = new EntityGroup[Team.all.length];
        for (Team team : Team.all) {
            Vars.unitGroups[team.ordinal()] = entities.add(BaseUnit.class).enableMapping();
        }
        for (EntityGroup entityGroup : entities.all()) {
            entityGroup.setRemoveListener(entity -> {
                if (entity instanceof SyncTrait && net.client()) {
                    netClient.addRemovedEntity(entity.getID());
                }
            });
        }
        state = new GameState();
        data = new GlobalData();
        mobile = Core.app.getType() == Application.ApplicationType.Android || Core.app.getType() == Application.ApplicationType.iOS || testMobile;
        ios = Core.app.getType() == Application.ApplicationType.iOS;
        android = Core.app.getType() == Application.ApplicationType.Android;
        dataDirectory = Core.settings.getDataDirectory();
        screenshotDirectory = dataDirectory.child("screenshots/");
        customMapDirectory = dataDirectory.child("maps/");
        mapPreviewDirectory = dataDirectory.child("previews/");
        saveDirectory = dataDirectory.child("saves/");
        tmpDirectory = dataDirectory.child("tmp/");
        pluginDirectory = dataDirectory.child("plugins/");
        maps.load();
    }

    public static void loadSettings() {
        Core.settings.setAppName(appName);
        if (steam) {
            Core.settings.setDataDirectory(Core.files.local("saves/"));
        }
        Core.settings.defaults("locale", "default");
        Core.keybinds.setDefaults(Binding.values(), new KeyBinds.Section[0]);
        Core.settings.load();
        Scl.setProduct((float)Core.settings.getInt("uiscale", 100) / 100.0f);
        if (!loadLocales) {
            return;
        }
        try {
            FileHandle handle = Core.files.local("bundle");
            Locale locale = Locale.ENGLISH;
            Core.bundle = I18NBundle.createBundle(handle, locale);
            Log.info("NOTE: external translation bundle has been loaded.");
            if (!headless) {
                Time.run(10.0f, () -> ui.showInfo("Note: You have successfully loaded an external translation bundle."));
            }
        }
        catch (Throwable e) {
            Locale locale;
            FileHandle handle = Core.files.internal("bundles/bundle");
            String loc = Core.settings.getString("locale");
            if (loc.equals("default")) {
                locale = Locale.getDefault();
            } else {
                Locale lastLocale;
                if (loc.contains("_")) {
                    String[] split = loc.split("_");
                    lastLocale = new Locale(split[0], split[1]);
                } else {
                    lastLocale = new Locale(loc);
                }
                locale = lastLocale;
            }
            Locale.setDefault(locale);
            Core.bundle = I18NBundle.createBundle(handle, locale);
        }
    }

    static {
        platform = new Platform(){};
    }
}

