/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ai;

import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.GridBits;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.IntQueue;
import io.anuke.arc.function.BiConsumer;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.TaskQueue;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.async.Threads;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.PathTile;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;

public class Pathfinder
implements Runnable {
    private static final long maxUpdate = Time.millisToNanos(4L);
    private static final int updateFPS = 60;
    private static final int updateInterval = 16;
    private static final int impassable = -1;
    private int[][] tiles;
    private Array<PathData> list = new Array();
    private PathData[][] pathMap = new PathData[Team.all.length][PathTarget.all.length];
    private GridBits created = new GridBits(Team.all.length, PathTarget.all.length);
    private TaskQueue queue = new TaskQueue();
    private Thread thread;

    public Pathfinder() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.stop();
            this.tiles = new int[Vars.world.width()][Vars.world.height()];
            this.pathMap = new PathData[Team.all.length][PathTarget.all.length];
            this.created = new GridBits(Team.all.length, PathTarget.all.length);
            this.list = new Array();
            for (int x = 0; x < Vars.world.width(); ++x) {
                for (int y = 0; y < Vars.world.height(); ++y) {
                    this.tiles[x][y] = this.packTile(Vars.world.rawTile(x, y));
                }
            }
            this.preloadPath(Vars.waveTeam, PathTarget.enemyCores);
            this.start();
        });
        Events.on(EventType.ResetEvent.class, event -> this.stop());
        Events.on(EventType.TileChangeEvent.class, event -> this.updateTile(event.tile));
    }

    private int packTile(Tile tile) {
        return PathTile.get(tile.cost, tile.getTeamID(), (byte)0, !tile.solid() && tile.floor().drownTime <= 0.0f);
    }

    private void start() {
        this.stop();
        this.thread = Threads.daemon(this);
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.clear();
    }

    public int debugValue(Team team, int x, int y) {
        if (this.pathMap[team.ordinal()][PathTarget.enemyCores.ordinal()] == null) {
            return 0;
        }
        return this.pathMap[team.ordinal()][PathTarget.enemyCores.ordinal()].weights[x][y];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTile(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        short x = tile.x;
        short y = tile.y;
        tile.getLinkedTiles(t -> {
            this.tiles[t.x][t.y] = this.packTile((Tile)t);
        });
        PathData[][] pathDataArray = this.pathMap;
        int n = pathDataArray.length;
        for (int i = 0; i < n; ++i) {
            PathData[] arr;
            for (PathData path : arr = pathDataArray[i]) {
                if (path == null) continue;
                IntArray intArray = path.targets;
                synchronized (intArray) {
                    path.targets.clear();
                    path.target.getTargets(path.team, path.targets);
                }
            }
        }
        this.queue.post(() -> {
            for (PathData data : this.list) {
                this.updateTargets(data, x, y);
            }
        });
    }

    @Override
    public void run() {
        while (!Vars.net.client()) {
            try {
                this.queue.run();
                for (PathData data : this.list) {
                    this.updateFrontier(data, maxUpdate / (long)this.list.size);
                }
                try {
                    Thread.sleep(16L);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public Tile getTargetTile(Tile tile, Team team, PathTarget target) {
        if (tile == null) {
            return null;
        }
        PathData data = this.pathMap[team.ordinal()][target.ordinal()];
        if (data == null) {
            if (!this.created.get(team.ordinal(), target.ordinal())) {
                this.created.set(team.ordinal(), target.ordinal());
                IntArray targets = target.getTargets(team, new IntArray());
                this.queue.post(() -> this.createPath(team, target, targets));
            }
            return tile;
        }
        int[][] values = data.weights;
        int value = values[tile.x][tile.y];
        Tile current = null;
        int tl = 0;
        for (Point2 point : Geometry.d8) {
            int dx = tile.x + point.x;
            int dy = tile.y + point.y;
            Tile other = Vars.world.tile(dx, dy);
            if (other == null || values[dx][dy] >= value || current != null && values[dx][dy] >= tl || other.solid() || !(other.floor().drownTime <= 0.0f) || point.x != 0 && point.y != 0 && (Vars.world.solid(tile.x + point.x, tile.y) || Vars.world.solid(tile.x, tile.y + point.y))) continue;
            current = other;
            tl = values[dx][dy];
        }
        if (current == null || tl == -1) {
            return tile;
        }
        return current;
    }

    private boolean passable(int x, int y, Team team) {
        int tile = this.tiles[x][y];
        return PathTile.passable(tile) || PathTile.team(tile) != team.ordinal() && PathTile.team(tile) != Team.derelict.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargets(PathData path, int x, int y) {
        if (!Structs.inBounds(x, y, path.weights)) {
            return;
        }
        if (path.weights[x][y] == 0) {
            path.frontier.clear();
        } else if (!path.frontier.isEmpty()) {
            return;
        }
        if (!this.passable(x, y, path.team)) {
            path.weights[x][y] = -1;
        }
        ++path.search;
        path.frontier.clear();
        IntArray intArray = path.targets;
        synchronized (intArray) {
            for (int i = 0; i < path.targets.size; ++i) {
                int pos = path.targets.get(i);
                short tx = Pos.x(pos);
                short ty = Pos.y(pos);
                path.weights[tx][ty] = 0;
                path.searches[tx][ty] = (short)path.search;
                path.frontier.addFirst(pos);
            }
        }
    }

    private void preloadPath(Team team, PathTarget target) {
        this.updateFrontier(this.createPath(team, target, target.getTargets(team, new IntArray())), -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathData createPath(Team team, PathTarget target, IntArray targets) {
        PathData path = new PathData(team, target, Vars.world.width(), Vars.world.height());
        this.list.add(path);
        this.pathMap[team.ordinal()][target.ordinal()] = path;
        IntArray intArray = path.targets;
        synchronized (intArray) {
            path.targets.clear();
            path.targets.addAll(targets);
        }
        for (int x = 0; x < Vars.world.width(); ++x) {
            for (int y = 0; y < Vars.world.height(); ++y) {
                path.weights[x][y] = -1;
            }
        }
        for (int i = 0; i < path.targets.size; ++i) {
            int pos = path.targets.get(i);
            path.weights[Pos.x((int)pos)][Pos.y((int)pos)] = 0;
            path.frontier.addFirst(pos);
        }
        return path;
    }

    private void updateFrontier(PathData path, long nsToRun) {
        long start = Time.nanos();
        while (path.frontier.size > 0 && (nsToRun < 0L || Time.timeSinceNanos(start) <= nsToRun)) {
            Tile tile = Vars.world.tile(path.frontier.removeLast());
            if (tile == null || path.weights == null) {
                return;
            }
            int cost = path.weights[tile.x][tile.y];
            if (path.frontier.size >= Vars.world.width() * Vars.world.height()) {
                path.frontier.clear();
                return;
            }
            if (cost == -1) continue;
            for (Point2 point : Geometry.d4) {
                int dx = tile.x + point.x;
                int dy = tile.y + point.y;
                Tile other = Vars.world.tile(dx, dy);
                if (other == null || path.weights[dx][dy] <= cost + other.cost && path.searches[dx][dy] >= path.search || !this.passable(dx, dy, path.team)) continue;
                if (other.cost < 0) {
                    throw new IllegalArgumentException("Tile cost cannot be negative! " + other);
                }
                path.frontier.addFirst(Pos.get(dx, dy));
                path.weights[dx][dy] = cost + other.cost;
                path.searches[dx][dy] = (short)path.search;
            }
        }
    }

    class PathTileStruct {
        byte cost;
        byte team;
        byte type;
        boolean passable;

        PathTileStruct() {
        }
    }

    class PathData {
        final Team team;
        final PathTarget target;
        final int[][] weights;
        final short[][] searches;
        final IntQueue frontier = new IntQueue();
        final IntArray targets = new IntArray();
        int search = 1;

        PathData(Team team, PathTarget target, int width, int height) {
            this.team = team;
            this.target = target;
            this.weights = new int[width][height];
            this.searches = new short[width][height];
            this.frontier.ensureCapacity((width + height) * 3);
        }
    }

    public static enum PathTarget {
        enemyCores((team, out) -> {
            for (Tile other : Vars.indexer.getEnemy((Team)((Object)team), BlockFlag.core)) {
                out.add(other.pos());
            }
            if (Vars.state.rules.waves && team == Vars.defaultTeam) {
                for (Tile other : Vars.spawner.getGroundSpawns()) {
                    out.add(other.pos());
                }
            }
        }),
        rallyPoints((team, out) -> {
            for (Tile other : Vars.indexer.getAllied((Team)((Object)team), BlockFlag.rally)) {
                out.add(other.pos());
            }
        });

        public static final PathTarget[] all;
        private final BiConsumer<Team, IntArray> targeter;

        private PathTarget(BiConsumer<Team, IntArray> targeter) {
            this.targeter = targeter;
        }

        public IntArray getTargets(Team team, IntArray out) {
            this.targeter.accept(team, out);
            return out;
        }

        static {
            all = PathTarget.values();
        }
    }
}

