/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ai;

import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.PositionConsumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Tile;

public class WaveSpawner {
    private static final float margin = 40.0f;
    private static final float coreMargin = 24.0f;
    private Array<FlyerSpawn> flySpawns = new Array();
    private Array<Tile> groundSpawns = new Array();
    private boolean spawning = false;

    public WaveSpawner() {
        Events.on(EventType.WorldLoadEvent.class, e -> this.reset());
    }

    public int countSpawns() {
        return this.groundSpawns.size;
    }

    public Array<Tile> getGroundSpawns() {
        return this.groundSpawns;
    }

    public boolean playerNear() {
        return this.groundSpawns.contains((Tile)((Object)((Predicate<Tile>)g -> Mathf.dst(g.x * 8, g.y * 8, Vars.player.x, Vars.player.y) < Vars.state.rules.dropZoneRadius)));
    }

    public void spawnEnemies() {
        this.spawning = true;
        for (SpawnGroup group : Vars.state.rules.spawns) {
            float spread;
            int spawned = group.getUnitsSpawned(Vars.state.wave - 1);
            if (group.type.isFlying) {
                spread = 26.666666f;
                this.eachFlyerSpawn((spawnX, spawnY) -> {
                    for (int i = 0; i < spawned; ++i) {
                        BaseUnit unit = group.createUnit(Vars.waveTeam);
                        unit.set(spawnX + Mathf.range(spread), spawnY + Mathf.range(spread));
                        unit.add();
                    }
                });
                continue;
            }
            spread = 16.0f;
            this.eachGroundSpawn((spawnX, spawnY, doShockwave) -> {
                for (int i = 0; i < spawned; ++i) {
                    Tmp.v1.rnd(spread);
                    BaseUnit unit = group.createUnit(Vars.waveTeam);
                    unit.set(spawnX + Tmp.v1.x, spawnY + Tmp.v1.y);
                    Time.run(Math.min(i * 5, 120), () -> this.spawnEffect(unit));
                }
            });
        }
        this.eachGroundSpawn((spawnX, spawnY, doShockwave) -> {
            if (doShockwave) {
                Time.run(20.0f, () -> Effects.effect(Fx.spawnShockwave, spawnX, spawnY, Vars.state.rules.dropZoneRadius));
                Time.run(40.0f, () -> Damage.damage(Vars.waveTeam, spawnX, spawnY, Vars.state.rules.dropZoneRadius, 1.0E8f, true));
            }
        });
        Time.runTask(121.0f, () -> {
            this.spawning = false;
        });
    }

    private void eachGroundSpawn(SpawnConsumer cons) {
        for (Tile spawn : this.groundSpawns) {
            cons.accept(spawn.worldx(), spawn.worldy(), true);
        }
        if (Vars.state.rules.attackMode && Vars.state.teams.isActive(Vars.waveTeam) && !Vars.state.teams.get((Team)Vars.defaultTeam).cores.isEmpty()) {
            Tile firstCore = Vars.state.teams.get((Team)Vars.defaultTeam).cores.first();
            for (Tile core : Vars.state.teams.get((Team)Vars.waveTeam).cores) {
                Tmp.v1.set(firstCore).sub(core.worldx(), core.worldy()).limit(24.0f + (float)(core.block().size * 8));
                cons.accept(core.worldx() + Tmp.v1.x, core.worldy() + Tmp.v1.y, false);
            }
        }
    }

    private void eachFlyerSpawn(PositionConsumer cons) {
        for (FlyerSpawn spawn : this.flySpawns) {
            float trns = (Vars.world.width() + Vars.world.height()) * 8;
            float spawnX = Mathf.clamp((float)(Vars.world.width() * 8) / 2.0f + Angles.trnsx(spawn.angle, trns), -40.0f, (float)(Vars.world.width() * 8) + 40.0f);
            float spawnY = Mathf.clamp((float)(Vars.world.height() * 8) / 2.0f + Angles.trnsy(spawn.angle, trns), -40.0f, (float)(Vars.world.height() * 8) + 40.0f);
            cons.accept(spawnX, spawnY);
        }
        if (Vars.state.rules.attackMode && Vars.state.teams.isActive(Vars.waveTeam)) {
            for (Tile core : Vars.state.teams.get((Team)Vars.waveTeam).cores) {
                cons.accept(core.worldx(), core.worldy());
            }
        }
    }

    public boolean isSpawning() {
        return this.spawning && !Vars.net.client();
    }

    private void reset() {
        this.flySpawns.clear();
        this.groundSpawns.clear();
        for (int x = 0; x < Vars.world.width(); ++x) {
            for (int y = 0; y < Vars.world.height(); ++y) {
                if (Vars.world.tile(x, y).overlay() != Blocks.spawn) continue;
                this.addSpawns(x, y);
            }
        }
    }

    private void addSpawns(int x, int y) {
        this.groundSpawns.add(Vars.world.tile(x, y));
        FlyerSpawn fspawn = new FlyerSpawn();
        fspawn.angle = Angles.angle((float)Vars.world.width() / 2.0f, (float)Vars.world.height() / 2.0f, x, y);
        this.flySpawns.add(fspawn);
    }

    private void spawnEffect(BaseUnit unit) {
        Effects.effect(Fx.unitSpawn, unit.x, unit.y, 0.0f, unit);
        Time.run(30.0f, () -> {
            unit.add();
            Effects.effect(Fx.spawn, unit);
        });
    }

    private class FlyerSpawn {
        float angle;

        private FlyerSpawn() {
        }
    }

    private static interface SpawnConsumer {
        public void accept(float var1, float var2, boolean var3);
    }
}

