/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.bullet.BombBulletType;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.ContentList;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.Weapon;

public class Mechs
implements ContentList {
    public static Mech alpha;
    public static Mech delta;
    public static Mech tau;
    public static Mech omega;
    public static Mech dart;
    public static Mech javelin;
    public static Mech trident;
    public static Mech glaive;
    public static Mech starter;

    @Override
    public void load() {
        alpha = new Mech("alpha-mech", false){
            {
                this.drillPower = 1;
                this.mineSpeed = 1.5f;
                this.mass = 1.2f;
                this.speed = 0.5f;
                this.itemCapacity = 40;
                this.boostSpeed = 0.95f;
                this.buildPower = 1.2f;
                this.engineColor = Color.valueOf("ffd37f");
                this.health = 250.0f;
                this.weapon = new Weapon("blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 14.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.shellEjectSmall;
                        this.bullet = Bullets.standardMechSmall;
                    }
                };
            }

            @Override
            public void updateAlt(Player player) {
                player.healBy(Time.delta() * 0.09f);
            }
        };
        delta = new Mech("delta-mech", false){
            float cooldown;
            {
                this.cooldown = 120.0f;
                this.drillPower = -1;
                this.speed = 0.75f;
                this.boostSpeed = 0.95f;
                this.itemCapacity = 15;
                this.mass = 0.9f;
                this.health = 150.0f;
                this.buildPower = 0.9f;
                this.weaponOffsetX = -1.0f;
                this.weaponOffsetY = -1.0f;
                this.engineColor = Color.valueOf("d3ddff");
                this.weapon = new Weapon("shockgun"){
                    {
                        this.shake = 2.0f;
                        this.length = 1.0f;
                        this.reload = 55.0f;
                        this.shotDelay = 3.0f;
                        this.roundrobin = true;
                        this.shots = 2;
                        this.inaccuracy = 0.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = Bullets.lightning;
                        this.shootSound = Sounds.spark;
                    }
                };
            }

            @Override
            public void onLand(Player player) {
                if (player.timer.get(3, this.cooldown)) {
                    Effects.shake(1.0f, 1.0f, player);
                    Effects.effect(Fx.landShock, player);
                    for (int i = 0; i < 8; ++i) {
                        Time.run(Mathf.random(8.0f), () -> Lightning.create(player.getTeam(), Pal.lancerLaser, 17.0f * Vars.state.rules.playerDamageMultiplier, player.x, player.y, Mathf.random(360.0f), 14));
                    }
                }
            }
        };
        tau = new Mech("tau-mech", false){
            float healRange;
            float healAmount;
            float healReload;
            boolean wasHealed;
            {
                this.healRange = 60.0f;
                this.healAmount = 10.0f;
                this.healReload = 160.0f;
                this.drillPower = 4;
                this.mineSpeed = 3.0f;
                this.itemCapacity = 70;
                this.weaponOffsetY = -1.0f;
                this.weaponOffsetX = 1.0f;
                this.mass = 1.75f;
                this.speed = 0.44f;
                this.drag = 0.35f;
                this.boostSpeed = 0.8f;
                this.canHeal = true;
                this.health = 200.0f;
                this.buildPower = 1.6f;
                this.engineColor = Pal.heal;
                this.weapon = new Weapon("heal-blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 24.0f;
                        this.roundrobin = false;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.bullet = Bullets.healBullet;
                        this.shootSound = Sounds.pew;
                    }
                };
            }

            @Override
            public void updateAlt(Player player) {
                if (player.timer.get(3, this.healReload)) {
                    this.wasHealed = false;
                    Units.nearby(player.getTeam(), player.x, player.y, this.healRange, unit -> {
                        if (unit.health < unit.maxHealth()) {
                            Effects.effect(Fx.heal, unit);
                            this.wasHealed = true;
                        }
                        unit.healBy(this.healAmount);
                    });
                    if (this.wasHealed) {
                        Effects.effect(Fx.healWave, player);
                    }
                }
            }
        };
        omega = new Mech("omega-mech", false){
            protected TextureRegion armorRegion;
            {
                this.drillPower = 2;
                this.mineSpeed = 1.5f;
                this.itemCapacity = 80;
                this.speed = 0.36f;
                this.boostSpeed = 0.6f;
                this.mass = 4.0f;
                this.shake = 4.0f;
                this.weaponOffsetX = 1.0f;
                this.weaponOffsetY = 0.0f;
                this.engineColor = Color.valueOf("feb380");
                this.health = 350.0f;
                this.buildPower = 1.5f;
                this.weapon = new Weapon("swarmer"){
                    {
                        this.length = 1.5f;
                        this.recoil = 4.0f;
                        this.reload = 38.0f;
                        this.shots = 4;
                        this.spacing = 8.0f;
                        this.inaccuracy = 8.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.shake = 3.0f;
                        this.bullet = Bullets.missileSwarm;
                        this.shootSound = Sounds.shootBig;
                    }
                };
            }

            @Override
            public float getRotationAlpha(Player player) {
                return 0.6f - player.shootHeat * 0.3f;
            }

            @Override
            public float spreadX(Player player) {
                return player.shootHeat * 2.0f;
            }

            @Override
            public void load() {
                super.load();
                this.armorRegion = Core.atlas.find(this.name + "-armor");
            }

            @Override
            public void updateAlt(Player player) {
                float scl = 1.0f - player.shootHeat / 2.0f;
                player.velocity().scl(scl);
            }

            @Override
            public float getExtraArmor(Player player) {
                return player.shootHeat * 30.0f;
            }

            @Override
            public void draw(Player player) {
                if (player.shootHeat <= 0.01f) {
                    return;
                }
                Shaders.build.progress = player.shootHeat;
                Shaders.build.region = this.armorRegion;
                Shaders.build.time = Time.time() / 10.0f;
                Shaders.build.color.set((Color)Pal.accent).a = player.shootHeat;
                Draw.shader(Shaders.build);
                Draw.rect(this.armorRegion, player.x, player.y, player.rotation);
                Draw.shader();
            }
        };
        dart = new Mech("dart-ship", true){
            {
                this.drillPower = 1;
                this.mineSpeed = 0.9f;
                this.speed = 0.5f;
                this.drag = 0.09f;
                this.health = 200.0f;
                this.weaponOffsetX = -1.0f;
                this.weaponOffsetY = -1.0f;
                this.engineColor = Pal.lightTrail;
                this.cellTrnsY = 1.0f;
                this.buildPower = 1.1f;
                this.weapon = new Weapon("blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 15.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.shellEjectSmall;
                        this.bullet = Bullets.standardCopper;
                    }
                };
            }

            @Override
            public boolean alwaysUnlocked() {
                return true;
            }
        };
        javelin = new Mech("javelin-ship", true){
            float minV;
            float maxV;
            TextureRegion shield;
            {
                this.minV = 3.6f;
                this.maxV = 6.0f;
                this.drillPower = -1;
                this.speed = 0.11f;
                this.drag = 0.01f;
                this.mass = 2.0f;
                this.health = 170.0f;
                this.engineColor = Color.valueOf("d3ddff");
                this.cellTrnsY = 1.0f;
                this.weapon = new Weapon("missiles"){
                    {
                        this.length = 1.5f;
                        this.reload = 70.0f;
                        this.shots = 4;
                        this.inaccuracy = 2.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 0.2f;
                        this.spacing = 1.0f;
                        this.bullet = Bullets.missileJavelin;
                        this.shootSound = Sounds.missile;
                    }
                };
            }

            @Override
            public void load() {
                super.load();
                this.shield = Core.atlas.find(this.name + "-shield");
            }

            @Override
            public float getRotationAlpha(Player player) {
                return 0.5f;
            }

            @Override
            public void updateAlt(Player player) {
                float scl = this.scld(player);
                if (Mathf.chance((double)Time.delta() * (0.15 * (double)scl))) {
                    Effects.effect(Fx.hitLancer, Pal.lancerLaser, player.x, player.y);
                    Lightning.create(player.getTeam(), Pal.lancerLaser, 10.0f * Vars.state.rules.playerDamageMultiplier, player.x + player.velocity().x, player.y + player.velocity().y, player.rotation, 14);
                }
            }

            @Override
            public void draw(Player player) {
                float scl = this.scld(player);
                if (scl < 0.01f) {
                    return;
                }
                Draw.color(Pal.lancerLaser);
                Draw.alpha(scl / 2.0f);
                Draw.blend(Blending.additive);
                Draw.rect(this.shield, player.x + Mathf.range(scl / 2.0f), player.y + Mathf.range(scl / 2.0f), player.rotation - 90.0f);
                Draw.blend();
            }

            float scld(Player player) {
                return Mathf.clamp((player.velocity().len() - this.minV) / (this.maxV - this.minV));
            }
        };
        trident = new Mech("trident-ship", true){
            {
                this.drillPower = 2;
                this.speed = 0.15f;
                this.drag = 0.034f;
                this.mass = 2.5f;
                this.turnCursor = false;
                this.health = 250.0f;
                this.itemCapacity = 30;
                this.engineColor = Color.valueOf("84f491");
                this.cellTrnsY = 1.0f;
                this.buildPower = 2.5f;
                this.weapon = new Weapon("bomber"){
                    {
                        this.length = 0.0f;
                        this.width = 2.0f;
                        this.reload = 25.0f;
                        this.shots = 2;
                        this.shotDelay = 1.0f;
                        this.shots = 8;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 1.0f;
                        this.inaccuracy = 20.0f;
                        this.ignoreRotation = true;
                        this.bullet = new BombBulletType(16.0f, 25.0f, "shell"){
                            {
                                this.bulletWidth = 10.0f;
                                this.bulletHeight = 14.0f;
                                this.hitEffect = Fx.flakExplosion;
                                this.shootEffect = Fx.none;
                                this.smokeEffect = Fx.none;
                                shootSound = Sounds.artillery;
                            }
                        };
                    }
                };
            }

            @Override
            public boolean canShoot(Player player) {
                return player.velocity().len() > 1.2f;
            }
        };
        glaive = new Mech("glaive-ship", true){
            {
                this.drillPower = 4;
                this.mineSpeed = 1.3f;
                this.speed = 0.32f;
                this.drag = 0.06f;
                this.mass = 3.0f;
                this.health = 240.0f;
                this.itemCapacity = 60;
                this.engineColor = Color.valueOf("feb380");
                this.cellTrnsY = 1.0f;
                this.buildPower = 1.2f;
                this.weapon = new Weapon("bomber"){
                    {
                        this.length = 1.5f;
                        this.reload = 13.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.shellEjectSmall;
                        this.bullet = Bullets.standardGlaive;
                        this.shootSound = Sounds.shootSnap;
                    }
                };
            }
        };
        starter = dart;
    }
}

