/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.collection.Array;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.game.ContentList;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.world.Block;

public class TechTree
implements ContentList {
    public static Array<TechNode> all;
    public static TechNode root;

    @Override
    public void load() {
        all = new Array();
        root = this.node(Blocks.coreShard, () -> {
            this.node(Blocks.conveyor, () -> this.node(Blocks.junction, () -> {
                this.node(Blocks.itemBridge);
                this.node(Blocks.router, () -> {
                    this.node(Blocks.launchPad, () -> this.node(Blocks.launchPadLarge, () -> {}));
                    this.node(Blocks.distributor);
                    this.node(Blocks.sorter, () -> {
                        this.node(Blocks.message);
                        this.node(Blocks.overflowGate);
                    });
                    this.node(Blocks.container, () -> {
                        this.node(Blocks.unloader);
                        this.node(Blocks.vault, () -> {});
                    });
                    this.node(Blocks.titaniumConveyor, () -> {
                        this.node(Blocks.phaseConveyor, () -> this.node(Blocks.massDriver, () -> {}));
                        this.node(Blocks.armoredConveyor, () -> {});
                    });
                });
            }));
            this.node(Blocks.duo, () -> {
                this.node(Blocks.scatter, () -> this.node(Blocks.hail, () -> this.node(Blocks.salvo, () -> {
                    this.node(Blocks.swarmer, () -> this.node(Blocks.cyclone, () -> this.node(Blocks.spectre, () -> {})));
                    this.node(Blocks.ripple, () -> this.node(Blocks.fuse, () -> {}));
                })));
                this.node(Blocks.scorch, () -> this.node(Blocks.arc, () -> {
                    this.node(Blocks.wave, () -> {});
                    this.node(Blocks.lancer, () -> {
                        this.node(Blocks.meltdown, () -> {});
                        this.node(Blocks.shockMine, () -> {});
                    });
                }));
                this.node(Blocks.copperWall, () -> {
                    this.node(Blocks.copperWallLarge);
                    this.node(Blocks.titaniumWall, () -> {
                        this.node(Blocks.door, () -> this.node(Blocks.doorLarge));
                        this.node(Blocks.titaniumWallLarge);
                        this.node(Blocks.thoriumWall, () -> {
                            this.node(Blocks.thoriumWallLarge);
                            this.node(Blocks.surgeWall, () -> {
                                this.node(Blocks.surgeWallLarge);
                                this.node(Blocks.phaseWall, () -> this.node(Blocks.phaseWallLarge));
                            });
                        });
                    });
                });
            });
            this.node(Blocks.mechanicalDrill, () -> {
                this.node(Blocks.graphitePress, () -> {
                    this.node(Blocks.pneumaticDrill, () -> {
                        this.node(Blocks.cultivator, () -> {});
                        this.node(Blocks.laserDrill, () -> {
                            this.node(Blocks.blastDrill, () -> {});
                            this.node(Blocks.waterExtractor, () -> this.node(Blocks.oilExtractor, () -> {}));
                        });
                    });
                    this.node(Blocks.pyratiteMixer, () -> this.node(Blocks.blastMixer, () -> {}));
                    this.node(Blocks.siliconSmelter, () -> {
                        this.node(Blocks.sporePress, () -> {
                            this.node(Blocks.coalCentrifuge, () -> {});
                            this.node(Blocks.multiPress, () -> {});
                            this.node(Blocks.plastaniumCompressor, () -> this.node(Blocks.phaseWeaver, () -> {}));
                        });
                        this.node(Blocks.kiln, () -> this.node(Blocks.incinerator, () -> this.node(Blocks.melter, () -> {
                            this.node(Blocks.surgeSmelter, () -> {});
                            this.node(Blocks.separator, () -> this.node(Blocks.pulverizer, () -> {}));
                            this.node(Blocks.cryofluidMixer, () -> {});
                        })));
                    });
                });
                this.node(Blocks.mechanicalPump, () -> this.node(Blocks.conduit, () -> this.node(Blocks.liquidJunction, () -> {
                    this.node(Blocks.liquidRouter, () -> {
                        this.node(Blocks.liquidTank);
                        this.node(Blocks.pulseConduit, () -> this.node(Blocks.phaseConduit, () -> {}));
                        this.node(Blocks.rotaryPump, () -> this.node(Blocks.thermalPump, () -> {}));
                    });
                    this.node(Blocks.bridgeConduit);
                })));
                this.node(Blocks.combustionGenerator, () -> {
                    this.node(Blocks.powerNode, () -> {
                        this.node(Blocks.powerNodeLarge, () -> this.node(Blocks.surgeTower, () -> {}));
                        this.node(Blocks.battery, () -> this.node(Blocks.batteryLarge, () -> {}));
                        this.node(Blocks.mender, () -> this.node(Blocks.mendProjector, () -> {
                            this.node(Blocks.forceProjector, () -> this.node(Blocks.overdriveProjector, () -> {}));
                            this.node(Blocks.repairPoint, () -> {});
                        }));
                        this.node(Blocks.turbineGenerator, () -> this.node(Blocks.thermalGenerator, () -> this.node(Blocks.differentialGenerator, () -> this.node(Blocks.thoriumReactor, () -> {
                            this.node(Blocks.impactReactor, () -> {});
                            this.node(Blocks.rtgGenerator, () -> {});
                        }))));
                        this.node(Blocks.solarPanel, () -> this.node(Blocks.largeSolarPanel, () -> {}));
                    });
                    this.node(Blocks.draugFactory, () -> {
                        this.node(Blocks.spiritFactory, () -> this.node(Blocks.phantomFactory));
                        this.node(Blocks.daggerFactory, () -> {
                            this.node(Blocks.commandCenter, () -> {});
                            this.node(Blocks.crawlerFactory, () -> this.node(Blocks.titanFactory, () -> this.node(Blocks.fortressFactory, () -> {})));
                            this.node(Blocks.wraithFactory, () -> this.node(Blocks.ghoulFactory, () -> this.node(Blocks.revenantFactory, () -> {})));
                        });
                    });
                    this.node(Blocks.dartPad, () -> this.node(Blocks.deltaPad, () -> {
                        this.node(Blocks.javelinPad, () -> this.node(Blocks.tridentPad, () -> this.node(Blocks.glaivePad)));
                        this.node(Blocks.tauPad, () -> this.node(Blocks.omegaPad, () -> {}));
                    }));
                });
            });
        });
    }

    private TechNode node(Block block, Runnable children) {
        ItemStack[] requirements = new ItemStack[block.buildRequirements.length];
        for (int i = 0; i < requirements.length; ++i) {
            requirements[i] = new ItemStack(block.buildRequirements[i].item, 30 + block.buildRequirements[i].amount * 6);
        }
        return new TechNode(block, requirements, children);
    }

    private TechNode node(Block block) {
        return this.node(block, () -> {});
    }

    public static class TechNode {
        static TechNode context;
        public final Block block;
        public final ItemStack[] requirements;
        public final Array<TechNode> children = new Array();

        TechNode(Block block, ItemStack[] requirements, Runnable children) {
            if (context != null) {
                TechNode.context.children.add(this);
            }
            this.block = block;
            this.requirements = requirements;
            TechNode last = context;
            context = this;
            children.run();
            context = last;
            all.add(this);
        }
    }
}

