/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.collection.ObjectSet;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.bullet.BombBulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.type.base.Crawler;
import io.anuke.mindustry.entities.type.base.Dagger;
import io.anuke.mindustry.entities.type.base.Draug;
import io.anuke.mindustry.entities.type.base.Eruptor;
import io.anuke.mindustry.entities.type.base.Fortress;
import io.anuke.mindustry.entities.type.base.Ghoul;
import io.anuke.mindustry.entities.type.base.Phantom;
import io.anuke.mindustry.entities.type.base.Revenant;
import io.anuke.mindustry.entities.type.base.Spirit;
import io.anuke.mindustry.entities.type.base.Titan;
import io.anuke.mindustry.entities.type.base.Wraith;
import io.anuke.mindustry.game.ContentList;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Weapon;

public class UnitTypes
implements ContentList {
    public static UnitType draug;
    public static UnitType spirit;
    public static UnitType phantom;
    public static UnitType wraith;
    public static UnitType ghoul;
    public static UnitType revenant;
    public static UnitType lich;
    public static UnitType reaper;
    public static UnitType dagger;
    public static UnitType crawler;
    public static UnitType titan;
    public static UnitType fortress;
    public static UnitType eruptor;
    public static UnitType chaosArray;
    public static UnitType eradicator;

    @Override
    public void load() {
        draug = new UnitType("draug", Draug.class, Draug::new){
            {
                this.isFlying = true;
                this.drag = 0.01f;
                this.speed = 0.3f;
                this.maxVelocity = 1.2f;
                this.range = 50.0f;
                this.health = 80.0f;
                this.minePower = 0.9f;
                this.engineSize = 1.8f;
                this.engineOffset = 5.7f;
                this.weapon = new Weapon("you have incurred my wrath. prepare to die."){
                    {
                        this.bullet = Bullets.lancerLaser;
                    }
                };
            }
        };
        spirit = new UnitType("spirit", Spirit.class, Spirit::new){
            {
                this.isFlying = true;
                this.drag = 0.01f;
                this.speed = 0.4f;
                this.maxVelocity = 1.6f;
                this.range = 50.0f;
                this.health = 60.0f;
                this.engineSize = 1.8f;
                this.engineOffset = 5.7f;
                this.weapon = new Weapon("heal-blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 40.0f;
                        this.width = 0.5f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.bullet = Bullets.healBullet;
                        this.shootSound = Sounds.pew;
                    }
                };
            }
        };
        phantom = new UnitType("phantom", Phantom.class, Phantom::new){
            {
                this.isFlying = true;
                this.drag = 0.01f;
                this.mass = 2.0f;
                this.speed = 0.45f;
                this.maxVelocity = 1.9f;
                this.range = 70.0f;
                this.itemCapacity = 70;
                this.health = 220.0f;
                this.buildPower = 0.9f;
                this.minePower = 1.1f;
                this.engineOffset = 6.5f;
                this.toMine = ObjectSet.with(Items.lead, Items.copper, Items.titanium);
                this.weapon = new Weapon("heal-blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 20.0f;
                        this.width = 0.5f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.bullet = Bullets.healBullet;
                    }
                };
            }
        };
        dagger = new UnitType("dagger", Dagger.class, Dagger::new){
            {
                this.maxVelocity = 1.1f;
                this.speed = 0.2f;
                this.drag = 0.4f;
                this.hitsize = 8.0f;
                this.mass = 1.75f;
                this.health = 130.0f;
                this.weapon = new Weapon("chain-blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 28.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.shellEjectSmall;
                        this.bullet = Bullets.standardCopper;
                    }
                };
            }
        };
        crawler = new UnitType("crawler", Crawler.class, Crawler::new){
            {
                this.maxVelocity = 1.27f;
                this.speed = 0.285f;
                this.drag = 0.4f;
                this.hitsize = 8.0f;
                this.mass = 1.75f;
                this.health = 120.0f;
                this.weapon = new Weapon("bomber"){
                    {
                        this.reload = 12.0f;
                        this.ejectEffect = Fx.none;
                        this.shootSound = Sounds.explosion;
                        this.bullet = new BombBulletType(2.0f, 3.0f, "clear"){
                            {
                                this.hitEffect = Fx.pulverize;
                                this.lifetime = 30.0f;
                                this.speed = 1.1f;
                                this.splashDamageRadius = 55.0f;
                                this.splashDamage = 30.0f;
                            }

                            @Override
                            public void init(Bullet b) {
                                if (b.getOwner() instanceof Unit) {
                                    ((Unit)b.getOwner()).kill();
                                }
                                b.time(b.lifetime());
                            }
                        };
                    }
                };
            }
        };
        titan = new UnitType("titan", Titan.class, Titan::new){
            {
                this.maxVelocity = 0.8f;
                this.speed = 0.22f;
                this.drag = 0.4f;
                this.mass = 3.5f;
                this.hitsize = 9.0f;
                this.range = 10.0f;
                this.rotatespeed = 0.1f;
                this.health = 460.0f;
                this.immunities.add(StatusEffects.burning);
                this.weapon = new Weapon("flamethrower"){
                    {
                        this.shootSound = Sounds.flame;
                        this.length = 1.0f;
                        this.reload = 14.0f;
                        range = 30.0f;
                        this.roundrobin = true;
                        this.recoil = 1.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = Bullets.basicFlame;
                    }
                };
            }
        };
        fortress = new UnitType("fortress", Fortress.class, Fortress::new){
            {
                this.maxVelocity = 0.78f;
                this.speed = 0.15f;
                this.drag = 0.4f;
                this.mass = 5.0f;
                this.hitsize = 10.0f;
                this.rotatespeed = 0.06f;
                this.targetAir = false;
                this.health = 750.0f;
                this.weapon = new Weapon("artillery"){
                    {
                        this.length = 1.0f;
                        this.reload = 60.0f;
                        this.width = 10.0f;
                        this.roundrobin = true;
                        this.recoil = 4.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.shellEjectMedium;
                        this.bullet = Bullets.artilleryUnit;
                        this.shootSound = Sounds.artillery;
                    }
                };
            }
        };
        eruptor = new UnitType("eruptor", Eruptor.class, Eruptor::new){
            {
                this.maxVelocity = 0.81f;
                this.speed = 0.16f;
                this.drag = 0.4f;
                this.mass = 5.0f;
                this.hitsize = 9.0f;
                this.rotatespeed = 0.05f;
                this.targetAir = false;
                this.health = 600.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning, StatusEffects.melting);
                this.weapon = new Weapon("eruption"){
                    {
                        this.length = 3.0f;
                        this.reload = 10.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.bullet = Bullets.eruptorShot;
                        this.recoil = 1.0f;
                        this.width = 7.0f;
                        this.shootSound = Sounds.flame;
                    }
                };
            }
        };
        chaosArray = new UnitType("chaos-array", Dagger.class, Dagger::new){
            {
                this.maxVelocity = 0.68f;
                this.speed = 0.12f;
                this.drag = 0.4f;
                this.mass = 5.0f;
                this.hitsize = 20.0f;
                this.rotatespeed = 0.06f;
                this.health = 3000.0f;
                this.weapon = new Weapon("chaos"){
                    {
                        this.length = 8.0f;
                        this.reload = 50.0f;
                        this.width = 17.0f;
                        this.roundrobin = true;
                        this.recoil = 3.0f;
                        this.shake = 2.0f;
                        this.shots = 4;
                        this.spacing = 4.0f;
                        this.shotDelay = 5.0f;
                        this.ejectEffect = Fx.shellEjectMedium;
                        this.bullet = Bullets.flakSurge;
                        this.shootSound = Sounds.shootBig;
                    }
                };
            }
        };
        eradicator = new UnitType("eradicator", Dagger.class, Dagger::new){
            {
                this.maxVelocity = 0.68f;
                this.speed = 0.12f;
                this.drag = 0.4f;
                this.mass = 5.0f;
                this.hitsize = 20.0f;
                this.rotatespeed = 0.06f;
                this.health = 9000.0f;
                this.weapon = new Weapon("eradication"){
                    {
                        this.length = 13.0f;
                        this.reload = 30.0f;
                        this.width = 22.0f;
                        this.roundrobin = true;
                        this.recoil = 3.0f;
                        this.shake = 2.0f;
                        this.inaccuracy = 3.0f;
                        this.shots = 4;
                        this.spacing = 0.0f;
                        this.shotDelay = 3.0f;
                        this.ejectEffect = Fx.shellEjectMedium;
                        this.bullet = Bullets.standardThoriumBig;
                        this.shootSound = Sounds.shootBig;
                    }
                };
            }
        };
        wraith = new UnitType("wraith", Wraith.class, Wraith::new){
            {
                this.speed = 0.3f;
                this.maxVelocity = 1.9f;
                this.drag = 0.01f;
                this.mass = 1.5f;
                this.isFlying = true;
                this.health = 75.0f;
                this.engineOffset = 5.5f;
                this.range = 140.0f;
                this.weapon = new Weapon("chain-blaster"){
                    {
                        this.length = 1.5f;
                        this.reload = 28.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.shellEjectSmall;
                        this.bullet = Bullets.standardCopper;
                        this.shootSound = Sounds.shoot;
                    }
                };
            }
        };
        ghoul = new UnitType("ghoul", Ghoul.class, Ghoul::new){
            {
                this.health = 220.0f;
                this.speed = 0.2f;
                this.maxVelocity = 1.4f;
                this.mass = 3.0f;
                this.drag = 0.01f;
                this.isFlying = true;
                this.targetAir = false;
                this.engineOffset = 7.8f;
                this.range = 140.0f;
                this.weapon = new Weapon("bomber"){
                    {
                        this.length = 0.0f;
                        this.width = 2.0f;
                        this.reload = 12.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 1.0f;
                        this.inaccuracy = 40.0f;
                        this.ignoreRotation = true;
                        this.bullet = Bullets.bombExplosive;
                        this.shootSound = Sounds.none;
                    }
                };
            }
        };
        revenant = new UnitType("revenant", Revenant.class, Revenant::new){
            {
                this.health = 1000.0f;
                this.mass = 5.0f;
                this.hitsize = 20.0f;
                this.speed = 0.1f;
                this.maxVelocity = 1.0f;
                this.drag = 0.01f;
                this.range = 80.0f;
                this.shootCone = 40.0f;
                this.isFlying = true;
                this.rotateWeapon = true;
                this.engineOffset = 12.0f;
                this.engineSize = 3.0f;
                this.rotatespeed = 0.01f;
                this.attackLength = 90.0f;
                this.baseRotateSpeed = 0.06f;
                this.weapon = new Weapon("revenant-missiles"){
                    {
                        this.length = 3.0f;
                        this.reload = 70.0f;
                        this.width = 10.0f;
                        this.shots = 2;
                        this.inaccuracy = 2.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 0.2f;
                        this.spacing = 1.0f;
                        this.shootSound = Sounds.missile;
                        this.bullet = Bullets.missileRevenant;
                    }
                };
            }
        };
        lich = new UnitType("lich", Revenant.class, Revenant::new){
            {
                this.health = 6000.0f;
                this.mass = 20.0f;
                this.hitsize = 40.0f;
                this.speed = 0.01f;
                this.maxVelocity = 0.6f;
                this.drag = 0.02f;
                this.range = 80.0f;
                this.shootCone = 20.0f;
                this.isFlying = true;
                this.rotateWeapon = true;
                this.engineOffset = 21.0f;
                this.engineSize = 5.3f;
                this.rotatespeed = 0.01f;
                this.attackLength = 90.0f;
                this.baseRotateSpeed = 0.04f;
                this.weapon = new Weapon("lich-missiles"){
                    {
                        this.length = 4.0f;
                        this.reload = 160.0f;
                        this.width = 22.0f;
                        this.shots = 16;
                        shootCone = 100.0f;
                        this.shotDelay = 2.0f;
                        this.inaccuracy = 10.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.velocityRnd = 0.2f;
                        this.spacing = 1.0f;
                        this.bullet = Bullets.missileRevenant;
                        this.shootSound = Sounds.artillery;
                    }
                };
            }
        };
        reaper = new UnitType("reaper", Revenant.class, Revenant::new){
            {
                this.health = 11000.0f;
                this.mass = 30.0f;
                this.hitsize = 56.0f;
                this.speed = 0.01f;
                this.maxVelocity = 0.6f;
                this.drag = 0.02f;
                this.range = 80.0f;
                this.shootCone = 30.0f;
                this.isFlying = true;
                this.rotateWeapon = true;
                this.engineOffset = 40.0f;
                this.engineSize = 7.3f;
                this.rotatespeed = 0.01f;
                this.baseRotateSpeed = 0.04f;
                this.weapon = new Weapon("reaper-gun"){
                    {
                        this.length = 3.0f;
                        this.reload = 10.0f;
                        this.width = 32.0f;
                        this.shots = 1;
                        shootCone = 100.0f;
                        this.shake = 1.0f;
                        this.inaccuracy = 3.0f;
                        this.roundrobin = true;
                        this.ejectEffect = Fx.none;
                        this.bullet = new BasicBulletType(7.0f, 42.0f, "bullet"){
                            {
                                this.bulletWidth = 15.0f;
                                this.bulletHeight = 21.0f;
                                this.shootEffect = Fx.shootBig;
                            }

                            @Override
                            public float range() {
                                return 165.0f;
                            }
                        };
                        this.shootSound = Sounds.shootBig;
                    }
                };
            }
        };
    }
}

