/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.content;

import io.anuke.arc.collection.Array;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.content.Loadouts;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.game.ContentList;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.maps.generators.MapGenerator;
import io.anuke.mindustry.maps.zonegen.DesertWastesGenerator;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;

public class Zones
implements ContentList {
    public static Zone groundZero;
    public static Zone desertWastes;
    public static Zone craters;
    public static Zone frozenForest;
    public static Zone ruinousShores;
    public static Zone stainedMountains;
    public static Zone tarFields;
    public static Zone fungalPass;
    public static Zone saltFlats;
    public static Zone overgrowth;
    public static Zone impact0078;
    public static Zone crags;
    public static Zone desolateRift;
    public static Zone nuclearComplex;

    @Override
    public void load() {
        groundZero = new Zone("groundZero", new MapGenerator("groundZero", 1)){
            {
                this.baseLaunchCost = ItemStack.with(Items.copper, -60);
                this.startingItems = ItemStack.list(Items.copper, 60);
                this.alwaysUnlocked = true;
                this.conditionWave = 5;
                this.launchPeriod = 5;
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead};
            }
        };
        desertWastes = new Zone("desertWastes", new DesertWastesGenerator(260, 260)){
            {
                this.startingItems = ItemStack.list(Items.copper, 120);
                this.conditionWave = 20;
                this.launchPeriod = 10;
                this.loadout = Loadouts.advancedShard;
                this.zoneRequirements = Zone.ZoneRequirement.with(groundZero, 20);
                this.blockRequirements = new Block[]{Blocks.combustionGenerator};
                this.resources = new Item[]{Items.copper, Items.lead, Items.coal, Items.sand};
                this.rules = r -> {
                    r.waves = true;
                    r.waveTimer = true;
                    r.launchWaveMultiplier = 3.0f;
                    r.waveSpacing = 3000.0f;
                    r.spawns = Array.with(new SpawnGroup(UnitTypes.crawler){
                        {
                            this.unitScaling = 3.0f;
                        }
                    }, new SpawnGroup(UnitTypes.dagger){
                        {
                            this.unitScaling = 4.0f;
                            this.begin = 2;
                            this.spacing = 2;
                        }
                    }, new SpawnGroup(UnitTypes.wraith){
                        {
                            this.unitScaling = 3.0f;
                            this.begin = 11;
                            this.spacing = 3;
                        }
                    }, new SpawnGroup(UnitTypes.eruptor){
                        {
                            this.unitScaling = 3.0f;
                            this.begin = 22;
                            this.unitAmount = 1;
                            this.spacing = 4;
                        }
                    }, new SpawnGroup(UnitTypes.titan){
                        {
                            this.unitScaling = 3.0f;
                            this.begin = 37;
                            this.unitAmount = 2;
                            this.spacing = 4;
                        }
                    }, new SpawnGroup(UnitTypes.fortress){
                        {
                            this.unitScaling = 2.0f;
                            this.effect = StatusEffects.boss;
                            this.begin = 41;
                            this.spacing = 20;
                        }
                    });
                };
            }
        };
        saltFlats = new Zone("saltFlats", new MapGenerator("saltFlats")){
            {
                this.startingItems = ItemStack.list(Items.copper, 200, Items.silicon, 200, Items.lead, 200);
                this.loadout = Loadouts.basicFoundation;
                this.conditionWave = 10;
                this.launchPeriod = 5;
                this.zoneRequirements = Zone.ZoneRequirement.with(desertWastes, 60);
                this.blockRequirements = new Block[]{Blocks.daggerFactory, Blocks.draugFactory, Blocks.door, Blocks.waterExtractor};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.sand, Items.titanium};
            }
        };
        frozenForest = new Zone("frozenForest", new MapGenerator("frozenForest", 1).decor(new MapGenerator.Decoration(Blocks.snow, Blocks.sporeCluster, 0.02))){
            {
                this.loadout = Loadouts.basicFoundation;
                this.baseLaunchCost = ItemStack.with(new Object[0]);
                this.startingItems = ItemStack.list(Items.copper, 250);
                this.conditionWave = 10;
                this.blockRequirements = new Block[]{Blocks.junction, Blocks.router};
                this.zoneRequirements = Zone.ZoneRequirement.with(groundZero, 10);
                this.resources = new Item[]{Items.copper, Items.lead, Items.coal};
            }
        };
        craters = new Zone("craters", new MapGenerator("craters", 1).decor(new MapGenerator.Decoration(Blocks.snow, Blocks.sporeCluster, 0.004))){
            {
                this.startingItems = ItemStack.list(Items.copper, 100);
                this.conditionWave = 10;
                this.zoneRequirements = Zone.ZoneRequirement.with(frozenForest, 10);
                this.blockRequirements = new Block[]{Blocks.mender, Blocks.combustionGenerator};
                this.resources = new Item[]{Items.copper, Items.lead, Items.coal, Items.sand, Items.scrap};
            }
        };
        ruinousShores = new Zone("ruinousShores", new MapGenerator("ruinousShores", 1)){
            {
                this.loadout = Loadouts.basicFoundation;
                this.baseLaunchCost = ItemStack.with(new Object[0]);
                this.startingItems = ItemStack.list(Items.copper, 140, Items.lead, 50);
                this.conditionWave = 20;
                this.launchPeriod = 20;
                this.zoneRequirements = Zone.ZoneRequirement.with(desertWastes, 20, craters, 15);
                this.blockRequirements = new Block[]{Blocks.graphitePress, Blocks.combustionGenerator, Blocks.kiln, Blocks.mechanicalPump};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.sand};
            }
        };
        stainedMountains = new Zone("stainedMountains", new MapGenerator("stainedMountains", 2).decor(new MapGenerator.Decoration(Blocks.shale, Blocks.shaleBoulder, 0.02))){
            {
                this.loadout = Loadouts.basicFoundation;
                this.startingItems = ItemStack.list(Items.copper, 200, Items.lead, 50);
                this.conditionWave = 10;
                this.launchPeriod = 10;
                this.zoneRequirements = Zone.ZoneRequirement.with(frozenForest, 15);
                this.blockRequirements = new Block[]{Blocks.pneumaticDrill, Blocks.powerNode, Blocks.turbineGenerator};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.titanium, Items.sand};
            }
        };
        fungalPass = new Zone("fungalPass", new MapGenerator("fungalPass")){
            {
                this.startingItems = ItemStack.list(Items.copper, 250, Items.lead, 250, Items.metaglass, 100, Items.graphite, 100);
                this.zoneRequirements = Zone.ZoneRequirement.with(stainedMountains, 15);
                this.blockRequirements = new Block[]{Blocks.daggerFactory, Blocks.crawlerFactory, Blocks.door, Blocks.siliconSmelter};
                this.resources = new Item[]{Items.copper, Items.lead, Items.coal, Items.titanium, Items.sand};
            }
        };
        overgrowth = new Zone("overgrowth", new MapGenerator("overgrowth")){
            {
                this.startingItems = ItemStack.list(Items.copper, 1500, Items.lead, 1000, Items.silicon, 500, Items.metaglass, 250);
                this.conditionWave = 12;
                this.launchPeriod = 4;
                this.loadout = Loadouts.basicNucleus;
                this.zoneRequirements = Zone.ZoneRequirement.with(craters, 40, fungalPass, 10);
                this.blockRequirements = new Block[]{Blocks.cultivator, Blocks.sporePress, Blocks.titanFactory, Blocks.wraithFactory};
                this.resources = new Item[]{Items.copper, Items.lead, Items.coal, Items.titanium, Items.sand, Items.thorium, Items.scrap};
            }
        };
        tarFields = new Zone("tarFields", new MapGenerator("tarFields").decor(new MapGenerator.Decoration(Blocks.shale, Blocks.shaleBoulder, 0.02))){
            {
                this.loadout = Loadouts.basicFoundation;
                this.startingItems = ItemStack.list(Items.copper, 250, Items.lead, 100);
                this.conditionWave = 15;
                this.launchPeriod = 10;
                this.zoneRequirements = Zone.ZoneRequirement.with(ruinousShores, 20);
                this.blockRequirements = new Block[]{Blocks.coalCentrifuge, Blocks.conduit, Blocks.wave};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.titanium, Items.thorium, Items.sand};
            }
        };
        desolateRift = new Zone("desolateRift", new MapGenerator("desolateRift")){
            {
                this.loadout = Loadouts.basicNucleus;
                this.baseLaunchCost = ItemStack.with(new Object[0]);
                this.startingItems = ItemStack.list(Items.copper, 1000, Items.lead, 1000, Items.graphite, 250, Items.titanium, 250, Items.silicon, 250);
                this.conditionWave = 3;
                this.launchPeriod = 2;
                this.zoneRequirements = Zone.ZoneRequirement.with(tarFields, 20);
                this.blockRequirements = new Block[]{Blocks.thermalGenerator, Blocks.thoriumReactor};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.titanium, Items.sand, Items.thorium};
            }
        };
        nuclearComplex = new Zone("nuclearComplex", new MapGenerator("nuclearProductionComplex", 1).decor(new MapGenerator.Decoration(Blocks.snow, Blocks.sporeCluster, 0.01))){
            {
                this.loadout = Loadouts.basicNucleus;
                this.baseLaunchCost = ItemStack.with(new Object[0]);
                this.startingItems = ItemStack.list(Items.copper, 1250, Items.lead, 1500, Items.silicon, 400, Items.metaglass, 250);
                this.conditionWave = 30;
                this.launchPeriod = 15;
                this.zoneRequirements = Zone.ZoneRequirement.with(fungalPass, 8);
                this.blockRequirements = new Block[]{Blocks.thermalGenerator, Blocks.laserDrill};
                this.resources = new Item[]{Items.copper, Items.scrap, Items.lead, Items.coal, Items.titanium, Items.thorium, Items.sand};
            }
        };
    }
}

