/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.Events;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.base.BaseDrone;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.game.Teams;

public class GameState {
    public int wave = 1;
    public float wavetime;
    public boolean gameOver = false;
    public boolean launched = false;
    public Rules rules = new Rules();
    public Stats stats = new Stats();
    public Teams teams = new Teams();
    public int enemies;
    private State state = State.menu;

    public int enemies() {
        return Vars.net.client() ? this.enemies : Vars.unitGroups[Vars.waveTeam.ordinal()].count(b -> !(b instanceof BaseDrone));
    }

    public BaseUnit boss() {
        return Vars.unitGroups[Vars.waveTeam.ordinal()].find(BaseUnit::isBoss);
    }

    public void set(State astate) {
        Events.fire(new EventType.StateChangeEvent(this.state, astate));
        this.state = astate;
    }

    public boolean isEditor() {
        return this.rules.editor;
    }

    public boolean isPaused() {
        return this.is(State.paused) && !Vars.net.active() || this.gameOver && !Vars.net.active();
    }

    public boolean is(State astate) {
        return this.state == astate;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        paused,
        playing,
        menu;

    }
}

