/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Events;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Stats;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.gen.BrokenBlock;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;

public class Logic
implements ApplicationListener {
    public Logic() {
        Events.on(EventType.WaveEvent.class, event -> {
            if (Vars.world.isZone()) {
                Vars.world.getZone().updateWave(Vars.state.wave);
            }
            for (Player p : Vars.playerGroup.all()) {
                p.respawns = Vars.state.rules.respawns;
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, event -> {
            Tile tile = event.tile;
            Block block = tile.block();
            if (block instanceof BuildBlock) {
                BuildBlock.BuildEntity entity = (BuildBlock.BuildEntity)tile.entity();
                if (entity.cblock != null && entity.cblock.synthetic()) {
                    block = entity.cblock;
                } else {
                    return;
                }
            }
            Teams.TeamData data = Vars.state.teams.get(tile.getTeam());
            data.brokenBlocks.addFirst(BrokenBlock.get(tile.x, tile.y, tile.rotation(), block.id));
        });
    }

    public void handleContent(UnlockableContent content) {
        if (!Vars.headless) {
            Vars.data.unlockContent(content);
        }
    }

    public void play() {
        Vars.state.set(GameState.State.playing);
        Vars.state.wavetime = Vars.state.rules.waveSpacing * 2.0f;
        Events.fire(new EventType.PlayEvent());
        if (!Vars.world.isZone()) {
            for (Team team : Team.all) {
                if (Vars.state.teams.get((Team)team).cores.isEmpty()) continue;
                TileEntity entity = Vars.state.teams.get((Team)team).cores.first().entity;
                entity.items.clear();
                for (ItemStack stack : Vars.state.rules.loadout) {
                    entity.items.add(stack.item, stack.amount);
                }
            }
        }
    }

    public void reset() {
        Vars.state.wave = 1;
        Vars.state.wavetime = Vars.state.rules.waveSpacing;
        Vars.state.launched = false;
        Vars.state.gameOver = false;
        Vars.state.teams = new Teams();
        Vars.state.rules = new Rules();
        Vars.state.stats = new Stats();
        Vars.entities.clear();
        Time.clear();
        TileEntity.sleepingEntities = 0;
        Events.fire(new EventType.ResetEvent());
    }

    public void runWave() {
        Vars.spawner.spawnEnemies();
        ++Vars.state.wave;
        Vars.state.wavetime = Vars.world.isZone() && Vars.world.getZone().isBossWave(Vars.state.wave) ? Vars.state.rules.waveSpacing * Vars.state.rules.bossWaveMultiplier : (Vars.world.isZone() && Vars.world.getZone().isLaunchWave(Vars.state.wave) ? Vars.state.rules.waveSpacing * Vars.state.rules.launchWaveMultiplier : Vars.state.rules.waveSpacing);
        Events.fire(new EventType.WaveEvent());
    }

    private void checkGameOver() {
        if (!Vars.state.rules.attackMode && Vars.state.teams.get((Team)Vars.defaultTeam).cores.size == 0 && !Vars.state.gameOver) {
            Vars.state.gameOver = true;
            Events.fire(new EventType.GameOverEvent(Vars.waveTeam));
        } else if (Vars.state.rules.attackMode) {
            Team alive = null;
            for (Team team : Team.all) {
                if (Vars.state.teams.get((Team)team).cores.size <= 0) continue;
                if (alive != null) {
                    return;
                }
                alive = team;
            }
            if (alive != null && !Vars.state.gameOver) {
                if (Vars.world.isZone() && alive == Vars.defaultTeam) {
                    Call.launchZone();
                } else {
                    Events.fire(new EventType.GameOverEvent(alive));
                }
                Vars.state.gameOver = true;
            }
        }
    }

    public static void launchZone() {
        if (!Vars.headless) {
            Vars.ui.hudfrag.showLaunch();
        }
        for (Tile tile : new ObjectSet.ObjectSetIterator<Tile>(Vars.state.teams.get((Team)Vars.defaultTeam).cores)) {
            Effects.effect(Fx.launch, tile);
        }
        Time.runTask(30.0f, () -> {
            for (Tile tile : new ObjectSet.ObjectSetIterator<Tile>(Vars.state.teams.get((Team)Vars.defaultTeam).cores)) {
                for (Item item : Vars.content.items()) {
                    Vars.data.addItem(item, tile.entity.items.get(item));
                }
                Vars.world.removeBlock(tile);
            }
            Vars.state.launched = true;
            Vars.state.gameOver = true;
            Events.fire(new EventType.LaunchEvent());
            Events.fire(new EventType.GameOverEvent(Vars.defaultTeam));
        });
    }

    public static void onGameOver(Team winner) {
        Vars.state.stats.wavesLasted = Vars.state.wave;
        Vars.ui.restart.show(winner);
        Vars.netClient.setQuiet();
    }

    @Override
    public void update() {
        if (!Vars.state.is(GameState.State.menu)) {
            if (!Vars.state.isPaused()) {
                Time.update();
                if (Vars.state.rules.waves && Vars.state.rules.waveTimer && !Vars.state.gameOver && (!Vars.state.rules.waitForWaveToEnd || Vars.unitGroups[Vars.waveTeam.ordinal()].size() == 0)) {
                    Vars.state.wavetime = Math.max(Vars.state.wavetime - Time.delta(), 0.0f);
                }
                if (!Vars.net.client() && Vars.state.wavetime <= 0.0f && Vars.state.rules.waves) {
                    this.runWave();
                }
                if (!Vars.headless) {
                    Vars.effectGroup.update();
                    Vars.groundEffectGroup.update();
                }
                if (!Vars.state.isEditor()) {
                    for (EntityGroup<BaseUnit> group : Vars.unitGroups) {
                        group.update();
                    }
                    Vars.puddleGroup.update();
                    Vars.shieldGroup.update();
                    Vars.bulletGroup.update();
                    Vars.tileGroup.update();
                    Vars.fireGroup.update();
                } else {
                    for (EntityGroup<BaseUnit> group : Vars.unitGroups) {
                        group.updateEvents();
                        Vars.collisions.updatePhysics(group);
                    }
                }
                Vars.playerGroup.update();
                if (Vars.headless) {
                    Vars.effectGroup.update();
                }
                if (!Vars.state.isEditor()) {
                    for (EntityGroup<BaseUnit> group : Vars.unitGroups) {
                        if (group.isEmpty()) continue;
                        Vars.collisions.collideGroups(Vars.bulletGroup, group);
                    }
                    Vars.collisions.collideGroups(Vars.bulletGroup, Vars.playerGroup);
                }
            }
            if (!(Vars.net.client() || Vars.world.isInvalidMap() || Vars.state.isEditor())) {
                this.checkGameOver();
            }
        }
    }
}

