/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Camera;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.PixmapIO;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.BufferUtils;
import io.anuke.arc.util.ScreenUtils;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.effect.GroundEffectEntity;
import io.anuke.mindustry.entities.traits.BelowLiquidTrait;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.EffectEntity;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.graphics.BlockRenderer;
import io.anuke.mindustry.graphics.Bloom;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.MinimapRenderer;
import io.anuke.mindustry.graphics.OverlayRenderer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Pixelator;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.input.DesktopInput;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.blocks.defense.ForceProjector;
import java.nio.Buffer;

public class Renderer
implements ApplicationListener {
    public final BlockRenderer blocks = new BlockRenderer();
    public final MinimapRenderer minimap = new MinimapRenderer();
    public final OverlayRenderer overlays = new OverlayRenderer();
    public final Pixelator pixelator = new Pixelator();
    public FrameBuffer shieldBuffer = new FrameBuffer(2, 2);
    private Bloom bloom;
    private Color clearColor;
    private float targetscale;
    private float camerascale = this.targetscale = Scl.scl(4.0f);
    private float landscale = 0.0f;
    private float landTime;
    private float minZoomScl = Scl.scl(0.01f);
    private Rectangle rect = new Rectangle();
    private Rectangle rect2 = new Rectangle();
    private float shakeIntensity;
    private float shaketime;

    public Renderer() {
        Core.camera = new Camera();
        Shaders.init();
        Effects.setScreenShakeProvider((intensity, duration) -> {
            this.shakeIntensity = Math.max(intensity, this.shakeIntensity);
            this.shaketime = Math.max(this.shaketime, duration);
        });
        Effects.setEffectProvider((effect, color, x, y, rotation, data) -> {
            Rectangle pos;
            Rectangle view;
            if (effect == Fx.none) {
                return;
            }
            if (Core.settings.getBool("effects") && (view = Core.camera.bounds(this.rect)).overlaps(pos = this.rect2.setSize(effect.size).setCenter(x, y))) {
                if (!(effect instanceof GroundEffectEntity.GroundEffect)) {
                    EffectEntity entity = Pools.obtain(EffectEntity.class, EffectEntity::new);
                    entity.effect = effect;
                    entity.color.set(color);
                    entity.rotation = rotation;
                    entity.data = data;
                    ++entity.id;
                    entity.set(x, y);
                    if (data instanceof Entity) {
                        entity.setParent((Entity)data);
                    }
                    Vars.effectGroup.add(entity);
                } else {
                    GroundEffectEntity entity = Pools.obtain(GroundEffectEntity.class, GroundEffectEntity::new);
                    entity.effect = effect;
                    entity.color.set(color);
                    entity.rotation = rotation;
                    ++entity.id;
                    entity.data = data;
                    entity.set(x, y);
                    if (data instanceof Entity) {
                        entity.setParent((Entity)data);
                    }
                    Vars.groundEffectGroup.add(entity);
                }
            }
        });
        this.clearColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void init() {
        if (Core.settings.getBool("bloom")) {
            this.setupBloom();
        }
    }

    @Override
    public void update() {
        Color.white.set(1.0f, 1.0f, 1.0f, 1.0f);
        this.camerascale = Mathf.lerpDelta(this.camerascale, this.targetscale, 0.1f);
        if (this.landTime > 0.0f) {
            this.landTime -= Time.delta();
            this.camerascale = this.landscale = Interpolation.pow5In.apply(this.minZoomScl, Scl.scl(4.0f), 1.0f - this.landTime / Fx.coreLand.lifetime);
        }
        Core.camera.width = (float)Core.graphics.getWidth() / this.camerascale;
        Core.camera.height = (float)Core.graphics.getHeight() / this.camerascale;
        if (Vars.state.is(GameState.State.menu)) {
            this.landTime = 0.0f;
            Core.graphics.clear(Color.black);
        } else {
            Vector2 position = Tmp.v3.set(Vars.player);
            if (Vars.player.isDead()) {
                TileEntity core = Vars.player.getClosestCore();
                if (core != null && Vars.player.spawner == null) {
                    Core.camera.position.lerpDelta(core.x, core.y, 0.08f);
                } else {
                    Core.camera.position.lerpDelta(position, 0.08f);
                }
            } else if (Vars.control.input instanceof DesktopInput) {
                Core.camera.position.lerpDelta(position, 0.08f);
            }
            this.updateShake(0.75f);
            if (this.pixelator.enabled()) {
                this.pixelator.drawPixelate();
            } else {
                this.draw();
            }
        }
    }

    public float landScale() {
        return this.landTime > 0.0f ? this.landscale : 1.0f;
    }

    @Override
    public void dispose() {
        this.minimap.dispose();
        this.shieldBuffer.dispose();
        this.blocks.dispose();
        if (this.bloom != null) {
            this.bloom.dispose();
            this.bloom = null;
        }
        Events.fire(new EventType.DisposeEvent());
    }

    @Override
    public void resize(int width, int height) {
        if (Core.settings.getBool("bloom")) {
            this.setupBloom();
        }
    }

    void setupBloom() {
        try {
            if (this.bloom != null) {
                this.bloom.dispose();
                this.bloom = null;
            }
            this.bloom = new Bloom(true);
            this.bloom.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            Core.settings.put("bloom", false);
            Core.settings.save();
            Vars.ui.showErrorMessage("$error.bloom");
        }
    }

    public void toggleBloom(boolean enabled) {
        if (enabled) {
            if (this.bloom == null) {
                this.setupBloom();
            }
        } else if (this.bloom != null) {
            this.bloom.dispose();
            this.bloom = null;
        }
    }

    void updateShake(float scale) {
        if (this.shaketime > 0.0f) {
            float intensity = this.shakeIntensity * ((float)Core.settings.getInt("screenshake", 4) / 4.0f) * scale;
            Core.camera.position.add(Mathf.range(intensity), Mathf.range(intensity));
            this.shakeIntensity -= 0.25f * Time.delta();
            this.shaketime -= Time.delta();
            this.shakeIntensity = Mathf.clamp(this.shakeIntensity, 0.0f, 100.0f);
        } else {
            this.shakeIntensity = 0.0f;
        }
    }

    public void draw() {
        Core.camera.update();
        if (Float.isNaN(Core.camera.position.x) || Float.isNaN(Core.camera.position.y)) {
            Core.camera.position.x = Vars.player.x;
            Core.camera.position.y = Vars.player.y;
        }
        Core.graphics.clear(this.clearColor);
        if (!(Core.graphics.isHidden() || !Core.settings.getBool("animatedwater") && !Core.settings.getBool("animatedshields") || this.shieldBuffer.getWidth() == Core.graphics.getWidth() && this.shieldBuffer.getHeight() == Core.graphics.getHeight())) {
            this.shieldBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        }
        Draw.proj(Core.camera.projection());
        this.blocks.floor.drawFloor();
        Vars.groundEffectGroup.draw(e -> e instanceof BelowLiquidTrait);
        Vars.puddleGroup.draw();
        Vars.groundEffectGroup.draw(e -> !(e instanceof BelowLiquidTrait));
        this.blocks.processBlocks();
        this.blocks.drawShadows();
        Draw.color();
        this.blocks.floor.beginDraw();
        this.blocks.floor.drawLayer(CacheLayer.walls);
        this.blocks.floor.endDraw();
        this.blocks.drawBlocks(Layer.block);
        this.blocks.drawFog();
        Draw.shader(Shaders.blockbuild, true);
        this.blocks.drawBlocks(Layer.placement);
        Draw.shader();
        this.blocks.drawBlocks(Layer.overlay);
        this.drawGroundShadows();
        this.drawAllTeams(false);
        this.blocks.drawBlocks(Layer.turret);
        this.drawFlyerShadows();
        this.blocks.drawBlocks(Layer.power);
        this.drawAllTeams(true);
        Draw.flush();
        if (this.bloom != null && !this.pixelator.enabled()) {
            this.bloom.capture();
        }
        Vars.bulletGroup.draw();
        Vars.effectGroup.draw();
        Draw.flush();
        if (this.bloom != null && !this.pixelator.enabled()) {
            this.bloom.render();
        }
        this.overlays.drawBottom();
        Vars.playerGroup.draw(p -> p.isLocal, Player::drawBuildRequests);
        if (Vars.shieldGroup.countInBounds() > 0) {
            if (Core.settings.getBool("animatedshields") && Shaders.shield != null) {
                Draw.flush();
                this.shieldBuffer.begin();
                Core.graphics.clear(Color.clear);
                Vars.shieldGroup.draw();
                Vars.shieldGroup.draw(shield -> true, ForceProjector.ShieldEntity::drawOver);
                Draw.flush();
                this.shieldBuffer.end();
                Draw.shader(Shaders.shield);
                Draw.color(Pal.accent);
                Draw.rect(Draw.wrap((Texture)this.shieldBuffer.getTexture()), Core.camera.position.x, Core.camera.position.y, Core.camera.width, -Core.camera.height);
                Draw.color();
                Draw.shader();
            } else {
                Vars.shieldGroup.draw(shield -> true, ForceProjector.ShieldEntity::drawSimple);
            }
        }
        this.overlays.drawTop();
        Vars.playerGroup.draw(p -> !p.isDead(), Player::drawName);
        this.drawLanding();
        Draw.color();
        Draw.flush();
    }

    private void drawLanding() {
        if (this.landTime > 0.0f && Vars.player.getClosestCore() != null) {
            float fract = this.landTime / Fx.coreLand.lifetime;
            TileEntity entity = Vars.player.getClosestCore();
            TextureRegion reg = entity.block.icon(Block.Icon.full);
            float scl = Scl.scl(4.0f) / this.camerascale;
            float s = (float)reg.getWidth() * Draw.scl * scl * 4.0f * fract;
            Draw.color(Pal.lightTrail);
            Draw.rect("circle-shadow", entity.x, entity.y, s, s);
            Angles.randLenVectors(1L, 1.0f - fract, 100, 1000.0f * scl * (1.0f - fract), (x, y, fin, fout) -> {
                Lines.stroke(scl * fin);
                Lines.lineAngle(entity.x + x, entity.y + y, Mathf.angle(x, y), (fin * 20.0f + 1.0f) * scl);
            });
            Draw.color();
            Draw.mixcol(Color.white, fract);
            Draw.rect(reg, entity.x, entity.y, (float)reg.getWidth() * Draw.scl * scl, (float)reg.getHeight() * Draw.scl * scl, fract * 135.0f);
            Draw.reset();
        }
    }

    private void drawGroundShadows() {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f);
        float rad = 1.6f;
        Consumer<Unit> draw = u -> {
            float size = (float)Math.max(u.getIconRegion().getWidth(), u.getIconRegion().getHeight()) * Draw.scl;
            Draw.rect("circle-shadow", u.x, u.y, size * rad, size * rad);
        };
        for (EntityGroup<BaseUnit> group : Vars.unitGroups) {
            if (group.isEmpty()) continue;
            group.draw(unit -> !unit.isDead(), draw::accept);
        }
        if (!Vars.playerGroup.isEmpty()) {
            Vars.playerGroup.draw(unit -> !unit.isDead(), draw::accept);
        }
        Draw.color();
    }

    private void drawFlyerShadows() {
        float trnsX = -12.0f;
        float trnsY = -13.0f;
        Draw.color(0.0f, 0.0f, 0.0f, 0.22f);
        for (EntityGroup<BaseUnit> group : Vars.unitGroups) {
            if (group.isEmpty()) continue;
            group.draw(unit -> unit.isFlying() && !unit.isDead(), baseUnit -> baseUnit.drawShadow(trnsX, trnsY));
        }
        if (!Vars.playerGroup.isEmpty()) {
            Vars.playerGroup.draw(unit -> unit.isFlying() && !unit.isDead(), player -> player.drawShadow(trnsX, trnsY));
        }
        Draw.color();
    }

    private void drawAllTeams(boolean flying) {
        for (Team team : Team.all) {
            EntityGroup<BaseUnit> group = Vars.unitGroups[team.ordinal()];
            if (group.count(p -> p.isFlying() == flying) + Vars.playerGroup.count(p -> p.isFlying() == flying && p.getTeam() == team) == 0 && flying) continue;
            Vars.unitGroups[team.ordinal()].draw(u -> u.isFlying() == flying && !u.isDead(), Unit::drawUnder);
            Vars.playerGroup.draw(p -> p.isFlying() == flying && p.getTeam() == team && !p.isDead(), Unit::drawUnder);
            Vars.unitGroups[team.ordinal()].draw(u -> u.isFlying() == flying && !u.isDead(), Unit::drawAll);
            Vars.playerGroup.draw(p -> p.isFlying() == flying && p.getTeam() == team, Unit::drawAll);
            Vars.unitGroups[team.ordinal()].draw(u -> u.isFlying() == flying && !u.isDead(), Unit::drawOver);
            Vars.playerGroup.draw(p -> p.isFlying() == flying && p.getTeam() == team, Unit::drawOver);
        }
    }

    public void scaleCamera(float amount) {
        this.targetscale += amount;
        this.clampScale();
    }

    public void clampScale() {
        float s = Scl.scl(1.0f);
        this.targetscale = Mathf.clamp(this.targetscale, s * 1.5f, (float)Math.round(s * 6.0f));
    }

    public float getScale() {
        return this.targetscale;
    }

    public void setScale(float scl) {
        this.targetscale = scl;
        this.clampScale();
    }

    public void zoomIn(float duration) {
        this.landscale = this.minZoomScl;
        this.landTime = duration;
    }

    public void takeMapScreenshot() {
        this.drawGroundShadows();
        int w = Vars.world.width() * 8;
        int h = Vars.world.height() * 8;
        int memory = w * h * 4 / 1024 / 1024;
        if (memory >= 65) {
            Vars.ui.showInfo("$screenshot.invalid");
            return;
        }
        boolean hadShields = Core.settings.getBool("animatedshields");
        boolean hadWater = Core.settings.getBool("animatedwater");
        Core.settings.put("animatedwater", false);
        Core.settings.put("animatedshields", false);
        FrameBuffer buffer = new FrameBuffer(w, h);
        float vpW = Core.camera.width;
        float vpH = Core.camera.height;
        float px = Core.camera.position.x;
        float py = Core.camera.position.y;
        Vars.disableUI = true;
        Core.camera.width = w;
        Core.camera.height = h;
        Core.camera.position.x = (float)w / 2.0f + 4.0f;
        Core.camera.position.y = (float)h / 2.0f + 4.0f;
        Draw.flush();
        buffer.begin();
        this.draw();
        Draw.flush();
        buffer.end();
        Vars.disableUI = false;
        Core.camera.width = vpW;
        Core.camera.height = vpH;
        Core.camera.position.set(px, py);
        buffer.begin();
        byte[] lines = ScreenUtils.getFrameBufferPixels(0, 0, w, h, true);
        for (int i = 0; i < lines.length; i += 4) {
            lines[i + 3] = -1;
        }
        buffer.end();
        Pixmap fullPixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        BufferUtils.copy(lines, 0, (Buffer)fullPixmap.getPixels(), lines.length);
        FileHandle file = Vars.screenshotDirectory.child("screenshot-" + Time.millis() + ".png");
        PixmapIO.writePNG(file, fullPixmap);
        fullPixmap.dispose();
        Vars.ui.showInfoFade(Core.bundle.format("screenshot", file.toString()));
        buffer.dispose();
        Core.settings.put("animatedwater", hadWater);
        Core.settings.put("animatedshields", hadShields);
    }
}

