/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.core;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.maps.MapException;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.maps.generators.Generator;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.WorldContext;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;

public class World {
    public final Context context = new Context();
    private Map currentMap;
    private Tile[][] tiles;
    private boolean generating;
    private boolean invalidMap;

    public boolean isInvalidMap() {
        return this.invalidMap;
    }

    public boolean solid(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null || tile.solid();
    }

    public boolean passable(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile != null && tile.passable();
    }

    public boolean wallSolid(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null || tile.block().solid;
    }

    public boolean isAccessible(int x, int y) {
        return !this.wallSolid(x, y - 1) || !this.wallSolid(x, y + 1) || !this.wallSolid(x - 1, y) || !this.wallSolid(x + 1, y);
    }

    public Map getMap() {
        return this.currentMap;
    }

    public void setMap(Map map) {
        this.currentMap = map;
    }

    public int width() {
        return this.tiles == null ? 0 : this.tiles.length;
    }

    public int height() {
        return this.tiles == null ? 0 : this.tiles[0].length;
    }

    public int unitWidth() {
        return this.width() * 8;
    }

    public int unitHeight() {
        return this.height() * 8;
    }

    public Tile tile(int pos) {
        return this.tiles == null ? null : this.tile(Pos.x(pos), Pos.y(pos));
    }

    public Tile tile(int x, int y) {
        if (this.tiles == null) {
            return null;
        }
        if (!Structs.inBounds(x, y, this.tiles)) {
            return null;
        }
        return this.tiles[x][y];
    }

    public Tile ltile(int x, int y) {
        Tile tile = this.tile(x, y);
        if (tile == null) {
            return null;
        }
        return tile.block().linked(tile);
    }

    public Tile rawTile(int x, int y) {
        return this.tiles[x][y];
    }

    public Tile tileWorld(float x, float y) {
        return this.tile(Math.round(x / 8.0f), Math.round(y / 8.0f));
    }

    public Tile ltileWorld(float x, float y) {
        return this.ltile(Math.round(x / 8.0f), Math.round(y / 8.0f));
    }

    public int toTile(float coord) {
        return Math.round(coord / 8.0f);
    }

    public Tile[][] getTiles() {
        return this.tiles;
    }

    private void clearTileEntities() {
        for (int x = 0; x < this.tiles.length; ++x) {
            for (int y = 0; y < this.tiles[0].length; ++y) {
                if (this.tiles[x][y] == null || this.tiles[x][y].entity == null) continue;
                this.tiles[x][y].entity.remove();
            }
        }
    }

    public Tile[][] createTiles(int width, int height) {
        if (this.tiles != null) {
            this.clearTileEntities();
            if (this.tiles.length != width || this.tiles[0].length != height) {
                this.tiles = new Tile[width][height];
            }
        } else {
            this.tiles = new Tile[width][height];
        }
        return this.tiles;
    }

    public void beginMapLoad() {
        this.generating = true;
    }

    public void endMapLoad() {
        this.prepareTiles(this.tiles);
        for (int x = 0; x < this.tiles.length; ++x) {
            for (int y = 0; y < this.tiles[0].length; ++y) {
                Tile tile = this.tiles[x][y];
                tile.updateOcclusion();
                if (tile.entity == null) continue;
                tile.entity.updateProximity();
            }
        }
        if (!Vars.headless) {
            this.addDarkness(this.tiles);
        }
        Vars.entities.all().each(group -> group.resize(-600.0f, -600.0f, (float)(this.tiles.length * 8) + 1200.0f, (float)(this.tiles[0].length * 8) + 1200.0f));
        this.generating = false;
        Events.fire(new EventType.WorldLoadEvent());
    }

    public boolean isGenerating() {
        return this.generating;
    }

    public boolean isZone() {
        return this.getZone() != null;
    }

    public Zone getZone() {
        return Vars.state.rules.zone;
    }

    public void loadGenerator(Generator generator) {
        this.beginMapLoad();
        this.createTiles(generator.width, generator.height);
        generator.generate(this.tiles);
        this.endMapLoad();
    }

    public void loadMap(Map map) {
        this.loadMap(map, new Rules());
    }

    public void loadMap(Map map, Rules checkRules) {
        try {
            SaveIO.load(map.file, (WorldContext)new FilterContext(map));
        }
        catch (Exception e) {
            Log.err(e);
            if (!Vars.headless) {
                Vars.ui.showErrorMessage("$map.invalid");
                Core.app.post(() -> Vars.state.set(GameState.State.menu));
                this.invalidMap = true;
            }
            this.generating = false;
            return;
        }
        this.currentMap = map;
        this.invalidMap = false;
        if (!Vars.headless) {
            if (Vars.state.teams.get((Team)Vars.defaultTeam).cores.size == 0 && !checkRules.pvp) {
                Vars.ui.showErrorMessage("$map.nospawn");
                this.invalidMap = true;
            } else if (checkRules.pvp) {
                int teams = 0;
                for (Team team : Team.all) {
                    if (Vars.state.teams.get((Team)team).cores.size == 0) continue;
                    ++teams;
                }
                if (teams < 2) {
                    this.invalidMap = true;
                    Vars.ui.showErrorMessage("$map.nospawn.pvp");
                }
            } else if (checkRules.attackMode) {
                this.invalidMap = Vars.state.teams.get((Team)Vars.waveTeam).cores.isEmpty();
                if (this.invalidMap) {
                    Vars.ui.showErrorMessage("$map.nospawn.attack");
                }
            }
        } else {
            this.invalidMap = true;
            for (Team team : Team.all) {
                if (Vars.state.teams.get((Team)team).cores.size == 0) continue;
                this.invalidMap = false;
            }
            if (this.invalidMap) {
                throw new MapException(map, "Map has no cores!");
            }
        }
        if (this.invalidMap) {
            Core.app.post(() -> Vars.state.set(GameState.State.menu));
        }
    }

    public void notifyChanged(Tile tile) {
        if (!this.generating) {
            Core.app.post(() -> Events.fire(new EventType.TileChangeEvent(tile)));
        }
    }

    public void removeBlock(Tile tile) {
        tile.link().getLinkedTiles(other -> other.setBlock(Blocks.air));
    }

    public void setBlock(Tile tile, Block block, Team team) {
        this.setBlock(tile, block, team, 0);
    }

    public void setBlock(Tile tile, Block block, Team team, int rotation) {
        tile.setBlock(block, team, rotation);
        if (block.isMultiblock()) {
            int offsetx = -(block.size - 1) / 2;
            int offsety = -(block.size - 1) / 2;
            for (int dx = 0; dx < block.size; ++dx) {
                for (int dy = 0; dy < block.size; ++dy) {
                    Tile toplace;
                    int worldx = dx + offsetx + tile.x;
                    int worldy = dy + offsety + tile.y;
                    if (worldx == tile.x && worldy == tile.y || (toplace = Vars.world.tile(worldx, worldy)) == null) continue;
                    toplace.setBlock(BlockPart.get(dx + offsetx, dy + offsety), team);
                }
            }
        }
    }

    public void raycastEachWorld(float x0, float y0, float x1, float y1, Raycaster cons) {
        this.raycastEach(this.toTile(x0), this.toTile(y0), this.toTile(x1), this.toTile(y1), cons);
    }

    public void raycastEach(int x0f, int y0f, int x1, int y1, Raycaster cons) {
        int x0 = x0f;
        int y0 = y0f;
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (!(cons.accept(x0, y0) || x0 == x1 && y0 == y1)) {
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    public void addDarkness(Tile[][] tiles) {
        int y;
        int x;
        byte[][] dark = new byte[tiles.length][tiles[0].length];
        byte[][] writeBuffer = new byte[tiles.length][tiles[0].length];
        int darkIterations = 4;
        for (x = 0; x < tiles.length; ++x) {
            for (y = 0; y < tiles[0].length; ++y) {
                Tile tile = tiles[x][y];
                if (!tile.isDarkened()) continue;
                dark[x][y] = darkIterations;
            }
        }
        for (int i = 0; i < darkIterations; ++i) {
            int x2;
            for (x2 = 0; x2 < tiles.length; ++x2) {
                for (int y2 = 0; y2 < tiles[0].length; ++y2) {
                    boolean min = false;
                    for (Point2 point : Geometry.d4) {
                        int newX = x2 + point.x;
                        int newY = y2 + point.y;
                        if (!Structs.inBounds(newX, newY, tiles) || dark[newX][newY] >= dark[x2][y2]) continue;
                        min = true;
                        break;
                    }
                    writeBuffer[x2][y2] = (byte)Math.max(0, dark[x2][y2] - Mathf.num(min));
                }
            }
            for (x2 = 0; x2 < tiles.length; ++x2) {
                System.arraycopy(writeBuffer[x2], 0, dark[x2], 0, tiles[0].length);
            }
        }
        for (x = 0; x < tiles.length; ++x) {
            for (y = 0; y < tiles[0].length; ++y) {
                Tile tile = tiles[x][y];
                if (tile.isDarkened()) {
                    tiles[x][y].rotation(dark[x][y]);
                }
                if (dark[x][y] != 4) continue;
                boolean full = true;
                for (Point2 p : Geometry.d4) {
                    int px = p.x + x;
                    int py = p.y + y;
                    if (!Structs.inBounds(px, py, tiles) || tiles[px][py].isDarkened() && dark[px][py] == 4) continue;
                    full = false;
                    break;
                }
                if (!full) continue;
                tiles[x][y].rotation(5);
            }
        }
    }

    public void prepareTiles(Tile[][] tiles) {
        IntArray multiblocks = new IntArray();
        for (int x = 0; x < tiles.length; ++x) {
            for (int y = 0; y < tiles[0].length; ++y) {
                Tile tile = tiles[x][y];
                if (!tile.block().isMultiblock()) continue;
                multiblocks.add(tile.pos());
            }
        }
        for (int i = 0; i < multiblocks.size; ++i) {
            int pos = multiblocks.get(i);
            short x = Pos.x(pos);
            short y = Pos.y(pos);
            Block result = tiles[x][y].block();
            Team team = tiles[x][y].getTeam();
            int offsetx = -(result.size - 1) / 2;
            int offsety = -(result.size - 1) / 2;
            for (int dx = 0; dx < result.size; ++dx) {
                for (int dy = 0; dy < result.size; ++dy) {
                    Tile toplace;
                    int worldx = dx + offsetx + x;
                    int worldy = dy + offsety + y;
                    if (worldx == x && worldy == y || (toplace = Vars.world.tile(worldx, worldy)) == null) continue;
                    toplace.setBlock(BlockPart.get(dx + offsetx, dy + offsety), team);
                }
            }
        }
    }

    private class FilterContext
    extends Context {
        final Map map;

        FilterContext(Map map) {
            this.map = map;
        }

        @Override
        public void end() {
            Array<GenerateFilter> filters = this.map.filters();
            if (!filters.isEmpty()) {
                GenerateFilter.GenerateInput input = new GenerateFilter.GenerateInput();
                for (GenerateFilter filter : filters) {
                    input.begin(filter, World.this.width(), World.this.height(), (x, y) -> World.this.tiles[x][y]);
                    for (int x2 = 0; x2 < World.this.width(); ++x2) {
                        for (int y2 = 0; y2 < World.this.height(); ++y2) {
                            Tile tile = World.this.rawTile(x2, y2);
                            input.apply(x2, y2, tile.floor(), tile.block(), tile.overlay());
                            filter.apply(input);
                            tile.setFloor((Floor)input.floor);
                            tile.setOverlay(input.ore);
                            if (tile.block().synthetic() || input.block.synthetic()) continue;
                            tile.setBlock(input.block);
                        }
                    }
                }
            }
            super.end();
        }
    }

    private class Context
    implements WorldContext {
        private Context() {
        }

        @Override
        public Tile tile(int x, int y) {
            return World.this.tiles[x][y];
        }

        @Override
        public void resize(int width, int height) {
            World.this.createTiles(width, height);
        }

        @Override
        public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
            Tile tile = new Tile(x, y, floorID, overlayID, wallID);
            ((World)World.this).tiles[x][y] = tile;
            return tile;
        }

        @Override
        public boolean isGenerating() {
            return World.this.isGenerating();
        }

        @Override
        public void begin() {
            World.this.beginMapLoad();
        }

        @Override
        public void end() {
            World.this.endMapLoad();
        }
    }

    public static interface Raycaster {
        public boolean accept(int var1, int var2);
    }
}

