/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop.steam;

import io.anuke.mindustry.desktop.steam.SStat;
import io.anuke.mindustry.desktop.steam.SVars;

public enum SAchievement {
    completeTutorial,
    kill1kEnemies(SStat.unitsDestroyed, 1000),
    kill100kEnemies(SStat.unitsDestroyed, 100000),
    launch10kItems(SStat.itemsLaunched, 10000),
    launch1milItems(SStat.itemsLaunched, 1000000),
    win10Attack(SStat.attacksWon, 10),
    win10PvP(SStat.pvpsWon, 10),
    defeatAttack5Waves,
    launch30Times(SStat.timesLaunched, 30),
    survive100Waves(SStat.maxWavesSurvived, 100),
    survive500Waves(SStat.maxWavesSurvived, 500),
    researchAll,
    useAllMechs(SStat.zoneMechsUsed, 6),
    shockWetEnemy,
    killEnemyPhaseWall,
    researchRouter,
    place10kBlocks(SStat.blocksBuilt, 10000),
    destroy1kBlocks(SStat.blocksDestroyed, 1000),
    overheatReactor(SStat.reactorsOverheated, 1),
    make10maps(SStat.mapsMade, 10),
    downloadMapWorkshop,
    publishMap(SStat.mapsPublished, 1),
    defeatBoss(SStat.bossesDefeated, 1),
    unlockAllZones,
    configAllZones,
    drop10kitems,
    powerupImpactReactor,
    obtainThorium,
    obtainTitanium,
    suicideBomb,
    buildDaggerFactory,
    issueAttackCommand,
    active100Units(SStat.maxUnitActive, 100),
    active10Phantoms,
    active50Crawlers,
    build1000Units,
    earnSRank,
    earnSSRank,
    dieExclusion,
    drown,
    fillCoreAllCampaign,
    hostServer10(SStat.maxPlayersServer, 10),
    buildMeltdownSpectre,
    launchItemPad,
    skipLaunching2Death,
    chainRouters,
    survive10WavesNoBlocks,
    useFlameAmmo,
    coolTurret,
    enablePixelation,
    openWiki;

    private final SStat stat;
    private final int statGoal;
    public static final SAchievement[] all;

    private SAchievement(SStat stat, int goal) {
        this.stat = stat;
        this.statGoal = goal;
    }

    private SAchievement() {
        this(null, 0);
    }

    public void complete() {
        if (!this.isAchieved()) {
            SVars.stats.stats.setAchievement(this.name());
            SVars.stats.stats.storeStats();
        }
    }

    public void checkCompletion() {
        if (!this.isAchieved() && this.stat != null && this.stat.get() >= this.statGoal) {
            this.complete();
        }
    }

    public boolean isAchieved() {
        return SVars.stats.stats.isAchieved(this.name(), false);
    }

    static {
        all = SAchievement.values();
    }
}

