/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop.steam;

import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamFriendsCallback;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamMatchmaking;
import com.codedisaster.steamworks.SteamMatchmakingCallback;
import com.codedisaster.steamworks.SteamNativeHandle;
import com.codedisaster.steamworks.SteamNetworking;
import com.codedisaster.steamworks.SteamNetworkingCallback;
import com.codedisaster.steamworks.SteamResult;
import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.game.Version;
import io.anuke.mindustry.net.ArcNetImpl;
import io.anuke.mindustry.net.Host;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.net.ValidateException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CopyOnWriteArrayList;

public class SNet
implements SteamNetworkingCallback,
SteamMatchmakingCallback,
SteamFriendsCallback,
Net.NetProvider {
    public final SteamNetworking snet = new SteamNetworking(this);
    public final SteamMatchmaking smat = new SteamMatchmaking(this);
    public final SteamFriends friends = new SteamFriends(this);
    final Net.NetProvider provider;
    final ArcNetImpl.PacketSerializer serializer = new ArcNetImpl.PacketSerializer();
    final ByteBuffer writeBuffer = ByteBuffer.allocateDirect(4096);
    final ByteBuffer readBuffer = ByteBuffer.allocateDirect(4096);
    final CopyOnWriteArrayList<SteamConnection> connections = new CopyOnWriteArrayList();
    final IntMap<SteamConnection> steamConnections = new IntMap();
    SteamID currentLobby;
    SteamID currentServer;
    Consumer<Host> lobbyCallback;
    Runnable lobbyDoneCallback;
    Runnable joinCallback;

    public SNet(Net.NetProvider provider) {
        this.provider = provider;
        Events.on(EventType.ClientLoadEvent.class, e -> Core.app.addListener(new ApplicationListener(){
            int length;
            SteamID from = new SteamID();

            @Override
            public void update() {
                while ((this.length = SNet.this.snet.isP2PPacketAvailable(0)) != 0) {
                    try {
                        SNet.this.readBuffer.position(0);
                        SNet.this.snet.readP2PPacket(this.from, SNet.this.readBuffer, 0);
                        int fromID = this.from.getAccountID();
                        Object output = SNet.this.serializer.read(SNet.this.readBuffer);
                        if (Vars.net.server()) {
                            SteamConnection con = SNet.this.steamConnections.get(fromID);
                            try {
                                if (con == null) {
                                    con = new SteamConnection(SteamID.createFromNativeHandle(SteamNativeHandle.getNativeHandle(this.from)));
                                    Packets.Connect c = new Packets.Connect();
                                    c.addressTCP = "steam:" + this.from.getAccountID();
                                    Log.info("&bRecieved STEAM connection: {0}", c.addressTCP);
                                    SNet.this.steamConnections.put(this.from.getAccountID(), con);
                                    SNet.this.connections.add(con);
                                    Vars.net.handleServerReceived(con, c);
                                }
                                Vars.net.handleServerReceived(con, output);
                            }
                            catch (RuntimeException e) {
                                if (e.getCause() instanceof ValidateException) {
                                    ValidateException v = (ValidateException)e.getCause();
                                    Log.err("Validation failed: {0} ({1})", v.player.name, v.getMessage());
                                    continue;
                                }
                                Log.err(e);
                            }
                            catch (Exception e) {
                                Log.err(e);
                            }
                            continue;
                        }
                        if (SNet.this.currentServer == null || fromID != SNet.this.currentServer.getAccountID()) continue;
                        Vars.net.handleClientReceived(output);
                    }
                    catch (SteamException e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        Events.on(EventType.WaveEvent.class, e -> {
            if (this.currentLobby != null && Vars.net.server()) {
                this.smat.setLobbyData(this.currentLobby, "wave", Vars.state.wave + "");
            }
        });
    }

    public boolean isSteamClient() {
        return this.currentServer != null;
    }

    @Override
    public void connectClient(String ip, int port, Runnable success) throws IOException {
        if (ip.startsWith("steam:")) {
            String lobbyname = ip.substring("steam:".length());
            try {
                SteamID lobby = SteamID.createFromNativeHandle(Long.parseLong(lobbyname));
                this.joinCallback = success;
                this.smat.joinLobby(lobby);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid Steam ID: " + lobbyname);
            }
        } else {
            this.provider.connectClient(ip, port, success);
        }
    }

    @Override
    public void sendClient(Object object, Net.SendMode mode) {
        if (this.isSteamClient()) {
            if (this.currentServer == null) {
                Log.info("Not connected, quitting.");
                return;
            }
            try {
                this.writeBuffer.limit(this.writeBuffer.capacity());
                this.writeBuffer.position(0);
                this.serializer.write(this.writeBuffer, object);
                this.writeBuffer.flip();
                this.snet.sendP2PPacket(this.currentServer, this.writeBuffer, mode == Net.SendMode.tcp ? SteamNetworking.P2PSend.Reliable : SteamNetworking.P2PSend.UnreliableNoDelay, 0);
            }
            catch (Exception e) {
                Vars.net.showError(e);
            }
            Pools.free(object);
        } else {
            this.provider.sendClient(object, mode);
        }
    }

    @Override
    public void disconnectClient() {
        if (this.isSteamClient()) {
            if (this.currentLobby != null) {
                this.smat.leaveLobby(this.currentLobby);
                this.snet.closeP2PSessionWithUser(this.currentServer);
                this.currentServer = null;
                this.currentLobby = null;
                Vars.net.handleClientReceived(new Packets.Disconnect());
            }
        } else {
            this.provider.disconnectClient();
        }
    }

    @Override
    public void discoverServers(Consumer<Host> callback, Runnable done) {
        this.smat.addRequestLobbyListResultCountFilter(32);
        this.smat.requestLobbyList();
        this.lobbyCallback = callback;
        this.lobbyDoneCallback = done;
    }

    @Override
    public void pingHost(String address, int port, Consumer<Host> valid, Consumer<Exception> failed) {
        this.provider.pingHost(address, port, valid, failed);
    }

    @Override
    public void hostServer(int port) throws IOException {
        this.provider.hostServer(port);
        this.smat.createLobby(Core.settings.getBool("publichost") ? SteamMatchmaking.LobbyType.Public : SteamMatchmaking.LobbyType.FriendsOnly, 16);
        Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Log.info("Server: {0}\nClient: {1}\nActive: {2}", Vars.net.server(), Vars.net.client(), Vars.net.active()))));
    }

    public void updateLobby() {
        if (this.currentLobby != null && Vars.net.server()) {
            this.smat.setLobbyType(this.currentLobby, Core.settings.getBool("publichost") ? SteamMatchmaking.LobbyType.Public : SteamMatchmaking.LobbyType.FriendsOnly);
        }
    }

    @Override
    public void closeServer() {
        this.provider.closeServer();
        if (this.currentLobby != null) {
            this.smat.leaveLobby(this.currentLobby);
            for (SteamConnection con : this.steamConnections.values()) {
                con.close();
            }
            this.currentLobby = null;
        }
        this.steamConnections.clear();
    }

    @Override
    public Iterable<? extends NetConnection> getConnections() {
        CopyOnWriteArrayList<SteamConnection> connectionsOut = new CopyOnWriteArrayList<SteamConnection>(this.connections);
        for (NetConnection netConnection : this.provider.getConnections()) {
            connectionsOut.add((SteamConnection)netConnection);
        }
        return connectionsOut;
    }

    void disconnectSteamUser(SteamID steamid) {
        int sid = steamid.getAccountID();
        this.snet.closeP2PSessionWithUser(steamid);
        if (this.steamConnections.containsKey(sid)) {
            SteamConnection con = this.steamConnections.get(sid);
            Vars.net.handleServerReceived(con, new Packets.Disconnect());
            this.steamConnections.remove(sid);
            this.connections.remove(con);
        }
    }

    @Override
    public void onFavoritesListChanged(int i, int i1, int i2, int i3, int i4, boolean b, int i5) {
    }

    @Override
    public void onLobbyInvite(SteamID steamIDUser, SteamID steamIDLobby, long gameID) {
        Log.info("onLobbyInvite {0} {1} {2}", steamIDLobby.getAccountID(), steamIDUser.getAccountID(), gameID);
    }

    @Override
    public void onLobbyEnter(SteamID steamIDLobby, int chatPermissions, boolean blocked, SteamMatchmaking.ChatRoomEnterResponse response) {
        Log.info("enter lobby {0} {1}", new Object[]{steamIDLobby.getAccountID(), response});
        if (response != SteamMatchmaking.ChatRoomEnterResponse.Success) {
            Vars.ui.loadfrag.hide();
            Vars.ui.showErrorMessage(Core.bundle.format("cantconnect", response.toString()));
            return;
        }
        this.currentLobby = steamIDLobby;
        this.currentServer = this.smat.getLobbyOwner(steamIDLobby);
        Log.info("Connect to owner {0}: {1}", this.currentServer.getAccountID(), this.friends.getFriendPersonaName(this.currentServer));
        if (this.joinCallback != null) {
            this.joinCallback.run();
            this.joinCallback = null;
        }
        Packets.Connect con = new Packets.Connect();
        con.addressTCP = "steam:" + this.currentServer.getAccountID();
        Vars.net.setClientConnected();
        Vars.net.handleClientReceived(con);
        Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Log.info("Server: {0}\nClient: {1}\nActive: {2}", Vars.net.server(), Vars.net.client(), Vars.net.active()))));
    }

    @Override
    public void onLobbyDataUpdate(SteamID steamID, SteamID steamID1, boolean b) {
    }

    @Override
    public void onLobbyChatUpdate(SteamID lobby, SteamID who, SteamID changer, SteamMatchmaking.ChatMemberStateChange change) {
        Log.info("lobby {0}: {1} caused {2}'s change: {3}", new Object[]{lobby.getAccountID(), who.getAccountID(), changer.getAccountID(), change});
        if (change == SteamMatchmaking.ChatMemberStateChange.Disconnected || change == SteamMatchmaking.ChatMemberStateChange.Left) {
            if (Vars.net.client()) {
                if (who.equals(this.currentServer) || who.equals(this.currentLobby)) {
                    Vars.net.disconnect();
                    Log.info("Current host left.");
                }
            } else {
                this.disconnectSteamUser(who);
            }
        }
    }

    @Override
    public void onLobbyChatMessage(SteamID steamID, SteamID steamID1, SteamMatchmaking.ChatEntryType chatEntryType, int i) {
    }

    @Override
    public void onLobbyGameCreated(SteamID steamID, SteamID steamID1, int i, short i1) {
    }

    @Override
    public void onLobbyMatchList(int matches) {
        Log.info("found {0} matches {1}", matches, this.lobbyDoneCallback);
        if (this.lobbyDoneCallback != null) {
            for (int i = 0; i < matches; ++i) {
                try {
                    SteamID lobby = this.smat.getLobbyByIndex(i);
                    Host out = new Host(this.smat.getLobbyData(lobby, "name"), "steam:" + SteamNativeHandle.getNativeHandle(lobby), this.smat.getLobbyData(lobby, "mapname"), Strings.parseInt(this.smat.getLobbyData(lobby, "wave"), -1), this.smat.getNumLobbyMembers(lobby), Strings.parseInt(this.smat.getLobbyData(lobby, "version"), -1), this.smat.getLobbyData(lobby, "versionType"), Gamemode.valueOf(this.smat.getLobbyData(lobby, "gamemode")), this.smat.getLobbyMemberLimit(lobby));
                    this.lobbyCallback.accept(out);
                    continue;
                }
                catch (Exception e) {
                    Log.err(e);
                }
            }
            this.lobbyDoneCallback.run();
        }
    }

    @Override
    public void onLobbyKicked(SteamID steamID, SteamID steamID1, boolean b) {
        Log.info("Kicked: {0} {1} {2}", steamID, steamID1, b);
    }

    @Override
    public void onLobbyCreated(SteamResult result, SteamID steamID) {
        if (!Vars.net.server()) {
            Log.info("Lobby created on server: {0}, ignoring.", steamID);
            return;
        }
        Log.info("Lobby {1} created? {0}", new Object[]{result, steamID.getAccountID()});
        if (result == SteamResult.OK) {
            this.currentLobby = steamID;
            this.smat.setLobbyData(steamID, "name", Vars.player.name);
            this.smat.setLobbyData(steamID, "mapname", Vars.world.getMap() == null ? "Unknown" : Vars.world.getMap().name());
            this.smat.setLobbyData(steamID, "version", Version.build + "");
            this.smat.setLobbyData(steamID, "versionType", Version.type);
            this.smat.setLobbyData(steamID, "wave", Vars.state.wave + "");
            this.smat.setLobbyData(steamID, "gamemode", Gamemode.bestFit(Vars.state.rules).name() + "");
        }
    }

    public void showFriendInvites() {
        if (this.currentLobby != null) {
            this.friends.activateGameOverlayInviteDialog(this.currentLobby);
            Log.info("Activating overlay dialog");
        }
    }

    @Override
    public void onFavoritesListAccountsUpdated(SteamResult steamResult) {
    }

    @Override
    public void onP2PSessionConnectFail(SteamID steamIDRemote, SteamNetworking.P2PSessionError sessionError) {
        if (Vars.net.server()) {
            Log.info("{0} has disconnected: {1}", new Object[]{steamIDRemote.getAccountID(), sessionError});
            this.disconnectSteamUser(steamIDRemote);
        } else if (steamIDRemote.equals(this.currentServer)) {
            Log.info("Disconnected! {1}: {0}", new Object[]{steamIDRemote.getAccountID(), sessionError});
            Vars.net.handleClientReceived(new Packets.Disconnect());
        }
    }

    @Override
    public void onP2PSessionRequest(SteamID steamIDRemote) {
        Log.info("Connection request: {0}", steamIDRemote.getAccountID());
        if (Vars.net.server()) {
            Log.info("Am server, accepting request from " + steamIDRemote.getAccountID());
            this.snet.acceptP2PSessionWithUser(steamIDRemote);
        }
    }

    @Override
    public void onSetPersonaNameResponse(boolean b, boolean b1, SteamResult steamResult) {
    }

    @Override
    public void onPersonaStateChange(SteamID steamID, SteamFriends.PersonaChange personaChange) {
    }

    @Override
    public void onGameOverlayActivated(boolean b) {
    }

    @Override
    public void onGameLobbyJoinRequested(SteamID lobby, SteamID steamIDFriend) {
        Log.info("onGameLobbyJoinRequested {0} {1}", lobby, steamIDFriend);
        this.smat.joinLobby(lobby);
    }

    @Override
    public void onAvatarImageLoaded(SteamID steamID, int i, int i1, int i2) {
    }

    @Override
    public void onFriendRichPresenceUpdate(SteamID steamID, int i) {
    }

    @Override
    public void onGameRichPresenceJoinRequested(SteamID steamID, String connect) {
        Log.info("onGameRichPresenceJoinRequested {0} {1}", steamID, connect);
    }

    @Override
    public void onGameServerChangeRequested(String server, String password) {
    }

    public class SteamConnection
    extends NetConnection {
        final SteamID sid;
        final SteamNetworking.P2PSessionState state;

        public SteamConnection(SteamID sid) {
            super(sid.getAccountID() + "");
            this.state = new SteamNetworking.P2PSessionState();
            this.sid = sid;
            Log.info("Create STEAM client {0}", sid.getAccountID());
        }

        @Override
        public void send(Object object, Net.SendMode mode) {
            block2: {
                try {
                    SNet.this.writeBuffer.limit(SNet.this.writeBuffer.capacity());
                    SNet.this.writeBuffer.position(0);
                    SNet.this.serializer.write(SNet.this.writeBuffer, object);
                    SNet.this.writeBuffer.flip();
                    SNet.this.snet.sendP2PPacket(this.sid, SNet.this.writeBuffer, mode == Net.SendMode.tcp ? (object instanceof Packets.StreamChunk ? SteamNetworking.P2PSend.ReliableWithBuffering : SteamNetworking.P2PSend.Reliable) : SteamNetworking.P2PSend.UnreliableNoDelay, 0);
                }
                catch (Exception e) {
                    Log.err(e);
                    Log.info("Error sending packet. Disconnecting invalid client!");
                    this.close();
                    SteamConnection k = SNet.this.steamConnections.get(this.sid.getAccountID());
                    if (k == null) break block2;
                    SNet.this.steamConnections.remove(this.sid.getAccountID());
                }
            }
        }

        @Override
        public boolean isConnected() {
            SNet.this.snet.getP2PSessionState(this.sid, this.state);
            return true;
        }

        @Override
        public void close() {
            SNet.this.disconnectSteamUser(this.sid);
        }
    }
}

