/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.desktop.steam;

import com.codedisaster.steamworks.SteamNativeHandle;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamRemoteStorage;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.codedisaster.steamworks.SteamUGCUpdateHandle;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.Log;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.desktop.steam.SAchievement;
import io.anuke.mindustry.desktop.steam.SVars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class SWorkshop
implements SteamUGCCallback {
    public final SteamUGC ugc = new SteamUGC(this);
    private Map lastMap;
    private Array<FileHandle> mapFiles;

    public SWorkshop() {
        int items = this.ugc.getNumSubscribedItems();
        SteamPublishedFileID[] ids = new SteamPublishedFileID[items];
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getSubscribedItems(ids);
        this.mapFiles = Array.with(ids).map(f -> {
            this.ugc.getItemInstallInfo((SteamPublishedFileID)f, info);
            return new FileHandle(info.getFolder());
        }).select(f -> f.list().length > 0).map(f -> f.list()[0]);
        if (items > 0) {
            SAchievement.downloadMapWorkshop.complete();
        }
        Log.info("Fetching {0} subscribed maps.", items);
    }

    public Array<FileHandle> getMapFiles() {
        return this.mapFiles;
    }

    public void publishMap(Map map) {
        if (map.tags.containsKey("steamid")) {
            Log.info("Map already published, redirecting to ID.");
            SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + (String)map.tags.get("steamid"));
            return;
        }
        map.tags.put("author", SVars.net.friends.getPersonaName());
        FloatingDialog dialog = new FloatingDialog("$confirm");
        dialog.setFillParent(false);
        dialog.cont.add("$map.publish.confirm").width(600.0f).wrap();
        dialog.addCloseButton();
        dialog.buttons.addImageTextButton("$eula", Icon.linkSmall, () -> SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement")).size(210.0f, 64.0f);
        dialog.buttons.addImageTextButton("$ok", Icon.checkSmall, () -> {
            this.lastMap = map;
            this.ugc.createItem(1127400, SteamRemoteStorage.WorkshopFileType.Community);
            Vars.ui.loadfrag.show("$map.publishing");
            Log.info("Publish map " + map.name());
            dialog.hide();
        }).size(170.0f, 64.0f);
        dialog.show();
    }

    @Override
    public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
    }

    @Override
    public void onSubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item subscribed from {0}", info.getFolder());
        SAchievement.downloadMapWorkshop.complete();
    }

    @Override
    public void onUnsubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item unsubscribed from {0}", info.getFolder());
    }

    @Override
    public void onRequestUGCDetails(SteamUGCDetails details, SteamResult result) {
    }

    @Override
    public void onCreateItem(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        if (this.lastMap == null) {
            Log.err("No map to publish?", new Object[0]);
            return;
        }
        Map map = this.lastMap;
        Log.info("Create item {0} result {1} {2}", new Object[]{SteamNativeHandle.getNativeHandle(publishedFileID), result, needsToAcceptWLA});
        if (result == SteamResult.OK) {
            SteamUGCUpdateHandle h = this.ugc.startItemUpdate(1127400, publishedFileID);
            Gamemode mode = Gamemode.attack.valid(map) ? Gamemode.attack : Gamemode.survival;
            FileHandle mapFile = Vars.tmpDirectory.child("map_" + publishedFileID.toString()).child("map.msav");
            this.lastMap.file.copyTo(mapFile);
            Log.info(mapFile.parent().absolutePath());
            Log.info(map.previewFile().absolutePath());
            this.ugc.setItemTitle(h, map.name());
            this.ugc.setItemDescription(h, map.description());
            this.ugc.setItemTags(h, new String[]{"map", mode.name()});
            this.ugc.setItemVisibility(h, SteamRemoteStorage.PublishedFileVisibility.Private);
            this.ugc.setItemPreview(h, map.previewFile().absolutePath());
            this.ugc.setItemContent(h, mapFile.parent().absolutePath());
            this.ugc.addItemKeyValueTag(h, "mode", mode.name());
            this.ugc.submitItemUpdate(h, "Map created");
            SteamUGC.ItemUpdateInfo info = new SteamUGC.ItemUpdateInfo();
            Vars.ui.loadfrag.setProgress(() -> {
                SteamUGC.ItemUpdateStatus status = this.ugc.getItemUpdateProgress(h, info);
                Vars.ui.loadfrag.setText("$" + status.name().toLowerCase());
                if (status == SteamUGC.ItemUpdateStatus.Invalid) {
                    Vars.ui.loadfrag.setText("$done");
                    return 1.0f;
                }
                return (float)status.ordinal() / (float)SteamUGC.ItemUpdateStatus.values().length;
            });
        } else {
            Vars.ui.showErrorMessage(Core.bundle.format("map.publish.error ", result.name()));
        }
        this.lastMap = null;
    }

    @Override
    public void onSubmitItemUpdate(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        Vars.ui.loadfrag.hide();
        Log.info("onsubmititemupdate {0} {1} {2}", new Object[]{publishedFileID, needsToAcceptWLA, result});
        if (result == SteamResult.OK) {
            SVars.net.friends.activateGameOverlayToWebPage("steam://url/CommunityFilePage/" + SteamNativeHandle.getNativeHandle(publishedFileID));
            if (needsToAcceptWLA) {
                SVars.net.friends.activateGameOverlayToWebPage("https://steamcommunity.com/sharedfiles/workshoplegalagreement");
            }
            Vars.ui.editor.editor.getTags().put("steamid", SteamNativeHandle.getNativeHandle(publishedFileID) + "");
            try {
                Vars.ui.editor.save();
            }
            catch (Exception e) {
                Log.err(e);
            }
            Events.fire(new EventType.MapPublishEvent());
        } else {
            Vars.ui.showErrorMessage(Core.bundle.format("map.publish.error ", result.name()));
        }
    }

    @Override
    public void onDownloadItemResult(int appID, SteamPublishedFileID publishedFileID, SteamResult result) {
        SAchievement.downloadMapWorkshop.complete();
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item downloaded to {0}", info.getFolder());
    }

    @Override
    public void onUserFavoriteItemsListChanged(SteamPublishedFileID publishedFileID, boolean wasAddRequest, SteamResult result) {
    }

    @Override
    public void onSetUserItemVote(SteamPublishedFileID publishedFileID, boolean voteUp, SteamResult result) {
    }

    @Override
    public void onGetUserItemVote(SteamPublishedFileID publishedFileID, boolean votedUp, boolean votedDown, boolean voteSkipped, SteamResult result) {
    }

    @Override
    public void onStartPlaytimeTracking(SteamResult result) {
    }

    @Override
    public void onStopPlaytimeTracking(SteamResult result) {
    }

    @Override
    public void onStopPlaytimeTrackingForAllItems(SteamResult result) {
    }

    @Override
    public void onDeleteItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
        this.ugc.getItemInstallInfo(publishedFileID, info);
        Log.info("Item removed from {0}", info.getFolder());
    }
}

