/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.collection.IntArray;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Bresenham2;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;

public enum EditorTool {
    zoom,
    pick{

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (!Structs.inBounds(x, y, editor.width(), editor.height())) {
                return;
            }
            Tile tile = editor.tile(x, y).link();
            editor.drawBlock = tile.block() == Blocks.air ? (tile.overlay() == Blocks.air ? tile.floor() : tile.overlay()) : tile.block();
        }
    }
    ,
    line(new String[]{"replace", "orthogonal"}){

        @Override
        public void touchedLine(MapEditor editor, int x1, int y1, int x2, int y2) {
            if (this.mode == 1) {
                if (Math.abs(x2 - x1) > Math.abs(y2 - y1)) {
                    y2 = y1;
                } else {
                    x2 = x1;
                }
            }
            Bresenham2.line(x1, y1, x2, y2, (x, y) -> {
                if (this.mode == 0) {
                    editor.drawBlocksReplace(x, y);
                } else {
                    editor.drawBlocks(x, y);
                }
            });
        }
    }
    ,
    pencil(new String[]{"replace", "square", "drawteams"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (this.mode == -1) {
                editor.drawBlocks(x, y);
            } else if (this.mode == 0) {
                editor.drawBlocksReplace(x, y);
            } else if (this.mode == 1) {
                editor.drawBlocks(x, y, true, tile -> true);
            } else if (this.mode == 2) {
                editor.drawCircle(x, y, tile -> tile.link().setTeam(editor.drawTeam));
            }
        }
    }
    ,
    eraser(new String[]{"eraseores"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            editor.drawCircle(x, y, tile -> {
                if (this.mode == -1) {
                    Vars.world.removeBlock((Tile)tile);
                } else if (this.mode == 0) {
                    tile.clearOverlay();
                }
            });
        }
    }
    ,
    fill(new String[]{"replaceall", "fillteams"}){
        IntArray stack;
        {
            this.edit = true;
            this.stack = new IntArray();
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (!Structs.inBounds(x, y, editor.width(), editor.height())) {
                return;
            }
            Tile tile = editor.tile(x, y);
            if (editor.drawBlock.isMultiblock()) {
                pencil.touched(editor, x, y);
                return;
            }
            if (this.mode == 0 || this.mode == -1) {
                Consumer<Tile> setter;
                Predicate<Tile> tester;
                if (tile.block() instanceof BlockPart || tile.block().isMultiblock()) {
                    return;
                }
                if (editor.drawBlock.isOverlay()) {
                    Floor dest = tile.overlay();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.overlay() == dest;
                    setter = t -> t.setOverlay(editor.drawBlock);
                } else if (editor.drawBlock.isFloor()) {
                    Floor dest = tile.floor();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.floor() == dest;
                    setter = t -> t.setFloorUnder(editor.drawBlock.asFloor());
                } else {
                    Block dest = tile.block();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.block() == dest;
                    setter = t -> t.setBlock(editor.drawBlock, editor.drawTeam);
                }
                this.fill(editor, x, y, this.mode == 0, tester, setter);
            } else if (this.mode == 1 && tile.link().synthetic()) {
                Team dest = tile.getTeam();
                if (dest == editor.drawTeam) {
                    return;
                }
                this.fill(editor, x, y, false, t -> t.getTeamID() == dest.ordinal() && t.link().synthetic(), t -> t.setTeam(editor.drawTeam));
            }
        }

        void fill(MapEditor editor, int x, int y, boolean replace, Predicate<Tile> tester, Consumer<Tile> filler) {
            int width = editor.width();
            int height = editor.height();
            if (replace) {
                for (int cx = 0; cx < width; ++cx) {
                    for (int cy = 0; cy < height; ++cy) {
                        Tile tile = editor.tile(cx, cy);
                        if (!tester.test(tile)) continue;
                        filler.accept(tile);
                    }
                }
            } else {
                this.stack.clear();
                this.stack.add(Pos.get(x, y));
                while (this.stack.size > 0) {
                    int x1;
                    int popped = this.stack.pop();
                    x = Pos.x(popped);
                    y = Pos.y(popped);
                    for (x1 = x; x1 >= 0 && tester.test(editor.tile(x1, y)); --x1) {
                    }
                    ++x1;
                    boolean spanAbove = false;
                    boolean spanBelow = false;
                    while (x1 < width && tester.test(editor.tile(x1, y))) {
                        filler.accept(editor.tile(x1, y));
                        if (!spanAbove && y > 0 && tester.test(editor.tile(x1, y - 1))) {
                            this.stack.add(Pos.get(x1, y - 1));
                            spanAbove = true;
                        } else if (spanAbove && !tester.test(editor.tile(x1, y - 1))) {
                            spanAbove = false;
                        }
                        if (!spanBelow && y < height - 1 && tester.test(editor.tile(x1, y + 1))) {
                            this.stack.add(Pos.get(x1, y + 1));
                            spanBelow = true;
                        } else if (spanBelow && y < height - 1 && !tester.test(editor.tile(x1, y + 1))) {
                            spanBelow = false;
                        }
                        ++x1;
                    }
                }
            }
        }
    }
    ,
    spray(new String[]{"replace"}){
        final double chance = 0.012;
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (editor.drawBlock.isFloor()) {
                editor.drawCircle(x, y, tile -> {
                    if (Mathf.chance(0.012)) {
                        tile.setFloor(editor.drawBlock.asFloor());
                    }
                });
            } else if (this.mode == 0) {
                editor.drawBlocks(x, y, tile -> Mathf.chance(0.012) && tile.block() != Blocks.air);
            } else {
                editor.drawBlocks(x, y, tile -> Mathf.chance(0.012));
            }
        }
    };

    public final String[] altModes;
    public int mode = -1;
    public boolean edit;
    public boolean draggable;

    private EditorTool() {
        this(new String[0]);
    }

    private EditorTool(String ... altModes) {
        this.altModes = altModes;
    }

    public void touched(MapEditor editor, int x, int y) {
    }

    public void touchedLine(MapEditor editor, int x1, int y1, int x2, int y2) {
    }
}

