/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.editor.DrawOperation;
import io.anuke.mindustry.editor.EditorTile;
import io.anuke.mindustry.editor.MapRenderer;
import io.anuke.mindustry.editor.OperationStack;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.TileOp;
import io.anuke.mindustry.io.LegacyMapIO;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.WorldContext;
import io.anuke.mindustry.world.blocks.BlockPart;

public class MapEditor {
    public static final int[] brushSizes = new int[]{1, 2, 3, 4, 5, 9, 15, 20};
    private final Context context = new Context();
    private StringMap tags = new StringMap();
    private MapRenderer renderer = new MapRenderer(this);
    private OperationStack stack = new OperationStack();
    private DrawOperation currentOp;
    private boolean loading;
    public int brushSize = 1;
    public int rotation;
    public Block drawBlock = Blocks.stone;
    public Team drawTeam = Team.sharded;

    public StringMap getTags() {
        return this.tags;
    }

    public void beginEdit(int width, int height) {
        this.reset();
        this.loading = true;
        this.createTiles(width, height);
        this.renderer.resize(this.width(), this.height());
        this.loading = false;
    }

    public void beginEdit(Map map) {
        this.reset();
        this.loading = true;
        this.tags.putAll(map.tags);
        if (map.file.parent().parent().name().equals("1127400") && Vars.steam) {
            this.tags.put("steamid", map.file.parent().name());
        }
        MapIO.loadMap(map, this.context);
        this.checkLinkedTiles();
        this.renderer.resize(this.width(), this.height());
        this.loading = false;
    }

    public void beginEdit(Pixmap pixmap) {
        this.reset();
        this.createTiles(pixmap.getWidth(), pixmap.getHeight());
        this.load(() -> LegacyMapIO.readPixmap(pixmap, this.tiles()));
        this.renderer.resize(this.width(), this.height());
    }

    public void checkLinkedTiles() {
        int y;
        int x;
        Tile[][] tiles = Vars.world.getTiles();
        for (x = 0; x < this.width(); ++x) {
            for (y = 0; y < this.height(); ++y) {
                if (!(tiles[x][y].block() instanceof BlockPart)) continue;
                tiles[x][y].setBlock(Blocks.air);
            }
        }
        for (x = 0; x < this.width(); ++x) {
            for (y = 0; y < this.height(); ++y) {
                if (!tiles[x][y].block().isMultiblock()) continue;
                Vars.world.setBlock(tiles[x][y], tiles[x][y].block(), tiles[x][y].getTeam());
            }
        }
    }

    public void load(Runnable r) {
        this.loading = true;
        r.run();
        this.loading = false;
    }

    private void createTiles(int width, int height) {
        Tile[][] tiles = Vars.world.createTiles(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                tiles[x][y] = new EditorTile(x, y, Blocks.stone.id, 0, 0);
            }
        }
    }

    public Map createMap(FileHandle file) {
        return new Map(file, this.width(), this.height(), new StringMap(this.tags), true);
    }

    private void reset() {
        this.clearOp();
        this.brushSize = 1;
        this.drawBlock = Blocks.stone;
        this.tags = new StringMap();
    }

    public Tile[][] tiles() {
        return Vars.world.getTiles();
    }

    public Tile tile(int x, int y) {
        return Vars.world.rawTile(x, y);
    }

    public int width() {
        return Vars.world.width();
    }

    public int height() {
        return Vars.world.height();
    }

    public void drawBlocksReplace(int x, int y) {
        this.drawBlocks(x, y, tile -> tile.block() != Blocks.air || this.drawBlock.isFloor());
    }

    public void drawBlocks(int x, int y) {
        this.drawBlocks(x, y, false, tile -> true);
    }

    public void drawBlocks(int x, int y, Predicate<Tile> tester) {
        this.drawBlocks(x, y, false, tester);
    }

    public void drawBlocks(int x, int y, boolean square, Predicate<Tile> tester) {
        if (this.drawBlock.isMultiblock()) {
            x = Mathf.clamp(x, (this.drawBlock.size - 1) / 2, this.width() - this.drawBlock.size / 2 - 1);
            y = Mathf.clamp(y, (this.drawBlock.size - 1) / 2, this.height() - this.drawBlock.size / 2 - 1);
            int offsetx = -(this.drawBlock.size - 1) / 2;
            int offsety = -(this.drawBlock.size - 1) / 2;
            for (int dx = 0; dx < this.drawBlock.size; ++dx) {
                for (int dy = 0; dy < this.drawBlock.size; ++dy) {
                    int worldx = dx + offsetx + x;
                    int worldy = dy + offsety + y;
                    if (!Structs.inBounds(worldx, worldy, this.width(), this.height())) continue;
                    Tile tile2 = this.tile(worldx, worldy);
                    Block block = tile2.block();
                    if (block.isMultiblock() || block instanceof BlockPart) {
                        return;
                    }
                    this.renderer.updatePoint(worldx, worldy);
                }
            }
            Vars.world.setBlock(this.tile(x, y), this.drawBlock, this.drawTeam);
        } else {
            boolean isFloor = this.drawBlock.isFloor() && this.drawBlock != Blocks.air;
            Consumer<Tile> drawer = tile -> {
                if (!tester.test((Tile)tile)) {
                    return;
                }
                if (!isFloor && (tile.isLinked() || tile.block().isMultiblock())) {
                    Vars.world.removeBlock(tile.link());
                }
                if (isFloor) {
                    tile.setFloor(this.drawBlock.asFloor());
                } else {
                    tile.setBlock(this.drawBlock);
                    if (this.drawBlock.synthetic()) {
                        tile.setTeam(this.drawTeam);
                    }
                    if (this.drawBlock.rotate) {
                        tile.rotation((byte)this.rotation);
                    }
                }
            };
            if (square) {
                this.drawSquare(x, y, drawer);
            } else {
                this.drawCircle(x, y, drawer);
            }
        }
    }

    public void drawCircle(int x, int y, Consumer<Tile> drawer) {
        for (int rx = -this.brushSize; rx <= this.brushSize; ++rx) {
            for (int ry = -this.brushSize; ry <= this.brushSize; ++ry) {
                if (!(Mathf.dst2(rx, ry) <= ((float)this.brushSize - 0.5f) * ((float)this.brushSize - 0.5f))) continue;
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.accept(this.tile(wx, wy));
            }
        }
    }

    public void drawSquare(int x, int y, Consumer<Tile> drawer) {
        for (int rx = -this.brushSize; rx <= this.brushSize; ++rx) {
            for (int ry = -this.brushSize; ry <= this.brushSize; ++ry) {
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.accept(this.tile(wx, wy));
            }
        }
    }

    public MapRenderer renderer() {
        return this.renderer;
    }

    public void resize(int width, int height) {
        this.clearOp();
        Tile[][] previous = Vars.world.getTiles();
        int offsetX = -(width - this.width()) / 2;
        int offsetY = -(height - this.height()) / 2;
        this.loading = true;
        Tile[][] tiles = Vars.world.createTiles(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int px = offsetX + x;
                int py = offsetY + y;
                if (Structs.inBounds(px, py, previous.length, previous[0].length)) {
                    tiles[x][y] = previous[px][py];
                    tiles[x][y].x = (short)x;
                    tiles[x][y].y = (short)y;
                    continue;
                }
                tiles[x][y] = new EditorTile(x, y, Blocks.stone.id, 0, 0);
            }
        }
        this.renderer.resize(width, height);
        this.loading = false;
    }

    public void clearOp() {
        this.stack.clear();
    }

    public void undo() {
        if (this.stack.canUndo()) {
            this.stack.undo();
        }
    }

    public void redo() {
        if (this.stack.canRedo()) {
            this.stack.redo();
        }
    }

    public boolean canUndo() {
        return this.stack.canUndo();
    }

    public boolean canRedo() {
        return this.stack.canRedo();
    }

    public void flushOp() {
        if (this.currentOp == null || this.currentOp.isEmpty()) {
            return;
        }
        this.stack.add(this.currentOp);
        this.currentOp = null;
    }

    public void addTileOp(long data) {
        if (this.loading) {
            return;
        }
        if (this.currentOp == null) {
            this.currentOp = new DrawOperation(this);
        }
        this.currentOp.addOperation(data);
        this.renderer.updatePoint(TileOp.x(data), TileOp.y(data));
    }

    class Context
    implements WorldContext {
        Context() {
        }

        @Override
        public Tile tile(int x, int y) {
            return Vars.world.tile(x, y);
        }

        @Override
        public void resize(int width, int height) {
            Vars.world.createTiles(width, height);
        }

        @Override
        public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
            EditorTile editorTile = new EditorTile(x, y, floorID, overlayID, wallID);
            MapEditor.this.tiles()[x][y] = editorTile;
            return editorTile;
        }

        @Override
        public boolean isGenerating() {
            return Vars.world.isGenerating();
        }

        @Override
        public void begin() {
            Vars.world.beginMapLoad();
        }

        @Override
        public void end() {
            Vars.world.endMapLoad();
        }
    }
}

