/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.Dialog;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.async.AsyncExecutor;
import io.anuke.arc.util.async.AsyncResult;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.filters.BlendFilter;
import io.anuke.mindustry.maps.filters.ClearFilter;
import io.anuke.mindustry.maps.filters.DistortFilter;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.maps.filters.MedianFilter;
import io.anuke.mindustry.maps.filters.MirrorFilter;
import io.anuke.mindustry.maps.filters.NoiseFilter;
import io.anuke.mindustry.maps.filters.OreFilter;
import io.anuke.mindustry.maps.filters.OreMedianFilter;
import io.anuke.mindustry.maps.filters.RiverNoiseFilter;
import io.anuke.mindustry.maps.filters.ScatterFilter;
import io.anuke.mindustry.maps.filters.TerrainFilter;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.CachedTile;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;

public class MapGenerateDialog
extends FloatingDialog {
    private final Supplier<GenerateFilter>[] filterTypes = new Supplier[]{NoiseFilter::new, ScatterFilter::new, TerrainFilter::new, DistortFilter::new, RiverNoiseFilter::new, OreFilter::new, OreMedianFilter::new, MedianFilter::new, BlendFilter::new, MirrorFilter::new, ClearFilter::new};
    private final MapEditor editor;
    private final boolean applied;
    private Pixmap pixmap;
    private Texture texture;
    private GenerateFilter.GenerateInput input = new GenerateFilter.GenerateInput();
    private Array<GenerateFilter> filters = new Array();
    private int scaling = Vars.mobile ? 3 : 1;
    private Table filterTable;
    private AsyncExecutor executor = new AsyncExecutor(1);
    private AsyncResult<Void> result;
    private boolean generating;
    private GenTile returnTile = new GenTile();
    private GenTile[][] buffer1;
    private GenTile[][] buffer2;
    private Consumer<Array<GenerateFilter>> applier;
    private CachedTile ctile = new CachedTile(){

        @Override
        protected void changed() {
        }
    };

    public MapGenerateDialog(MapEditor editor, boolean applied) {
        super("$editor.generate");
        this.editor = editor;
        this.applied = applied;
        this.shown(this::setup);
        this.addCloseButton();
        if (applied) {
            this.buttons.addButton("$editor.apply", () -> Vars.ui.loadAnd(() -> {
                this.apply();
                this.hide();
            })).size(160.0f, 64.0f);
        } else {
            this.buttons.addButton("$settings.reset", () -> {
                this.filters.set(Vars.maps.readFilters(""));
                this.rebuildFilters();
                this.update();
            }).size(160.0f, 64.0f);
        }
        this.buttons.addButton("$editor.randomize", () -> {
            for (GenerateFilter filter : this.filters) {
                filter.randomize();
            }
            this.update();
        }).size(160.0f, 64.0f);
        this.buttons.addImageTextButton("$add", Icon.add, this::showAdd).height(64.0f).width(140.0f);
        if (!applied) {
            this.hidden(this::apply);
        }
        this.onResize(this::rebuildFilters);
    }

    public void show(Array<GenerateFilter> filters, Consumer<Array<GenerateFilter>> applier) {
        this.filters = filters;
        this.applier = applier;
        this.show();
    }

    public void show(Consumer<Array<GenerateFilter>> applier) {
        this.show(this.filters, applier);
    }

    public void applyToEditor(Array<GenerateFilter> filters) {
        GenTile[][] writeTiles = new GenTile[this.editor.width()][this.editor.height()];
        for (int x = 0; x < this.editor.width(); ++x) {
            for (int y = 0; y < this.editor.height(); ++y) {
                writeTiles[x][y] = new GenTile();
            }
        }
        for (GenerateFilter filter : filters) {
            this.input.begin(filter, this.editor.width(), this.editor.height(), this.editor::tile);
            for (int x = 0; x < this.editor.width(); ++x) {
                for (int y = 0; y < this.editor.height(); ++y) {
                    Tile tile = this.editor.tile(x, y);
                    this.input.apply(x, y, tile.floor(), tile.block(), tile.overlay());
                    filter.apply(this.input);
                    writeTiles[x][y].set(this.input.floor, this.input.block, this.input.ore, tile.getTeam(), tile.rotation());
                }
            }
            this.editor.load(() -> {
                for (int x = 0; x < this.editor.width(); ++x) {
                    for (int y = 0; y < this.editor.height(); ++y) {
                        Tile tile = this.editor.tile(x, y);
                        GenTile write = writeTiles[x][y];
                        tile.rotation(write.rotation);
                        tile.setFloor((Floor)Vars.content.block(write.floor));
                        tile.setBlock(Vars.content.block(write.block));
                        tile.setTeam(Team.all[write.team]);
                        tile.setOverlay(Vars.content.block(write.ore));
                    }
                }
            });
        }
        this.editor.load(this.editor::checkLinkedTiles);
        this.editor.renderer().updateAll();
        this.editor.clearOp();
    }

    void setup() {
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.pixmap = new Pixmap(this.editor.width() / this.scaling, this.editor.height() / this.scaling, Pixmap.Format.RGBA8888);
        this.texture = new Texture(this.pixmap);
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.margin(8.0f);
            t.stack(new BorderImage(this.texture){
                {
                    this.setScaling(Scaling.fit);
                }

                @Override
                public void draw() {
                    super.draw();
                    for (GenerateFilter filter : MapGenerateDialog.this.filters) {
                        filter.draw(this);
                    }
                }
            }, new Stack(){
                {
                    this.add(new Image(Styles.black8));
                    this.add(new Image((Drawable)Icon.refresh, Scaling.none));
                    this.visible(() -> MapGenerateDialog.this.generating && !Vars.updateEditorOnChange);
                }
            }).grow().padRight(10.0f);
            t.pane((Table p) -> {
                this.filterTable = p.marginRight(6.0f);
            }).update((T pane) -> {
                if (Core.scene.getKeyboardFocus() instanceof Dialog && Core.scene.getKeyboardFocus() != this) {
                    return;
                }
                Vector2 v = pane.stageToLocalCoordinates(Core.input.mouse());
                if (v.x >= 0.0f && v.y >= 0.0f && v.x <= pane.getWidth() && v.y <= pane.getHeight()) {
                    Core.scene.setScrollFocus((Element)pane);
                } else {
                    Core.scene.setScrollFocus(null);
                }
            }).grow().get().setScrollingDisabled(true, false);
        }).grow();
        this.buffer1 = this.create();
        this.buffer2 = this.create();
        this.update();
        this.rebuildFilters();
    }

    GenTile[][] create() {
        GenTile[][] out = new GenTile[this.editor.width() / this.scaling][this.editor.height() / this.scaling];
        for (int x = 0; x < out.length; ++x) {
            for (int y = 0; y < out[0].length; ++y) {
                out[x][y] = new GenTile();
            }
        }
        return out;
    }

    void rebuildFilters() {
        int cols = Math.max((int)(Math.max(this.filterTable.getParent().getWidth(), (float)Core.graphics.getWidth() / 2.0f * 0.9f) / Scl.scl(290.0f)), 1);
        this.filterTable.clearChildren();
        this.filterTable.top().left();
        int i = 0;
        for (GenerateFilter filter : this.filters) {
            this.filterTable.table(Tex.button, c -> {
                c.table((Table t) -> {
                    t.top();
                    t.add(filter.name()).padTop(5.0f).color(Pal.accent).growX().left();
                    t.row();
                    t.table((Table b) -> {
                        ImageButton.ImageButtonStyle style = Styles.cleari;
                        b.defaults().size(50.0f);
                        b.addImageButton((Drawable)Icon.refreshSmall, style, () -> {
                            filter.randomize();
                            this.update();
                        });
                        b.addImageButton((Drawable)Icon.arrowUpSmall, style, () -> {
                            int idx = this.filters.indexOf(filter);
                            this.filters.swap(idx, Math.max(0, idx - 1));
                            this.rebuildFilters();
                            this.update();
                        });
                        b.addImageButton((Drawable)Icon.arrowDownSmall, style, () -> {
                            int idx = this.filters.indexOf(filter);
                            this.filters.swap(idx, Math.min(this.filters.size - 1, idx + 1));
                            this.rebuildFilters();
                            this.update();
                        });
                        b.addImageButton((Drawable)Icon.trashSmall, style, () -> {
                            this.filters.remove(filter);
                            this.rebuildFilters();
                            this.update();
                        });
                    });
                }).fillX();
                c.row();
                c.table((Table f) -> {
                    f.left().top();
                    for (FilterOption option : filter.options) {
                        option.changed = this::update;
                        f.table((Table t) -> {
                            t.left();
                            option.build((Table)t);
                        }).growX().left();
                        f.row();
                    }
                }).grow().left().pad(2.0f).top();
            }).width(280.0f).pad(3.0f).top().left().fillY();
            if (++i % cols != 0) continue;
            this.filterTable.row();
        }
        if (this.filters.isEmpty()) {
            this.filterTable.add("$filters.empty").wrap().width(200.0f);
        }
    }

    void showAdd() {
        FloatingDialog selection = new FloatingDialog("$add");
        selection.setFillParent(false);
        selection.cont.defaults().size(210.0f, 60.0f);
        int i = 0;
        for (Supplier<GenerateFilter> gen : this.filterTypes) {
            GenerateFilter filter = gen.get();
            if (!this.applied && filter.buffered) continue;
            selection.cont.addButton(filter.name(), () -> {
                this.filters.add(filter);
                this.rebuildFilters();
                this.update();
                selection.hide();
            });
            if (++i % 2 != 0) continue;
            selection.cont.row();
        }
        selection.cont.addButton("$filter.defaultores", () -> {
            Vars.maps.addDefaultOres(this.filters);
            this.rebuildFilters();
            this.update();
            selection.hide();
        });
        selection.addCloseButton();
        selection.show();
    }

    GenTile dset(Tile tile) {
        this.returnTile.set(tile);
        return this.returnTile;
    }

    void apply() {
        if (this.result != null) {
            this.result.get();
        }
        this.buffer1 = null;
        this.buffer2 = null;
        this.generating = false;
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.applier.accept(this.filters);
    }

    void update() {
        if (this.generating) {
            return;
        }
        Array<GenerateFilter> copy = new Array<GenerateFilter>(this.filters);
        this.result = this.executor.submit(() -> {
            try {
                this.generating = true;
                if (!this.filters.isEmpty()) {
                    for (int px = 0; px < this.pixmap.getWidth(); ++px) {
                        for (int py = 0; py < this.pixmap.getHeight(); ++py) {
                            this.buffer1[px][py].set(this.editor.tile(px * this.scaling, py * this.scaling));
                        }
                    }
                }
                for (GenerateFilter filter : copy) {
                    int py;
                    int px;
                    this.input.begin(filter, this.editor.width(), this.editor.height(), (x, y) -> this.buffer1[Mathf.clamp(x / this.scaling, 0, this.pixmap.getWidth() - 1)][Mathf.clamp(y / this.scaling, 0, this.pixmap.getHeight() - 1)].tile());
                    for (px = 0; px < this.pixmap.getWidth(); ++px) {
                        for (py = 0; py < this.pixmap.getHeight(); ++py) {
                            int x2 = px * this.scaling;
                            int y2 = py * this.scaling;
                            GenTile tile = this.buffer1[px][py];
                            this.input.apply(x2, y2, Vars.content.block(tile.floor), Vars.content.block(tile.block), Vars.content.block(tile.ore));
                            filter.apply(this.input);
                            this.buffer2[px][py].set(this.input.floor, this.input.block, this.input.ore, Team.all[tile.team], tile.rotation);
                        }
                    }
                    for (px = 0; px < this.pixmap.getWidth(); ++px) {
                        for (py = 0; py < this.pixmap.getHeight(); ++py) {
                            this.buffer1[px][py].set(this.buffer2[px][py]);
                        }
                    }
                }
                for (int px = 0; px < this.pixmap.getWidth(); ++px) {
                    for (int py = 0; py < this.pixmap.getHeight(); ++py) {
                        int color;
                        Object tile;
                        if (this.filters.isEmpty()) {
                            tile = this.editor.tile(px * this.scaling, py * this.scaling);
                            color = MapIO.colorFor(((Tile)tile).floor(), ((Tile)tile).block(), ((Tile)tile).overlay(), Team.derelict);
                        } else {
                            tile = this.buffer1[px][py];
                            color = MapIO.colorFor(Vars.content.block(((GenTile)tile).floor), Vars.content.block(((GenTile)tile).block), Vars.content.block(((GenTile)tile).ore), Team.derelict);
                        }
                        this.pixmap.drawPixel(px, this.pixmap.getHeight() - 1 - py, color);
                    }
                }
                Core.app.post(() -> {
                    if (this.pixmap == null || this.texture == null) {
                        return;
                    }
                    this.texture.draw(this.pixmap, 0, 0);
                    this.generating = false;
                });
            }
            catch (Exception e) {
                this.generating = false;
                e.printStackTrace();
            }
            return null;
        });
    }

    private class GenTile {
        public byte team;
        public byte rotation;
        public short block;
        public short floor;
        public short ore;

        private GenTile() {
        }

        public void set(Block floor, Block wall, Block ore, Team team, int rotation) {
            this.floor = floor.id;
            this.block = wall.id;
            this.ore = ore.id;
            this.team = (byte)team.ordinal();
            this.rotation = (byte)rotation;
        }

        public void set(GenTile other) {
            this.floor = other.floor;
            this.block = other.block;
            this.ore = other.ore;
            this.team = other.team;
            this.rotation = other.rotation;
        }

        public GenTile set(Tile other) {
            this.set(other.floor(), other.block(), other.overlay(), other.getTeam(), other.rotation());
            return this;
        }

        Tile tile() {
            MapGenerateDialog.this.ctile.setFloor((Floor)Vars.content.block(this.floor));
            MapGenerateDialog.this.ctile.setBlock(Vars.content.block(this.block));
            MapGenerateDialog.this.ctile.setOverlay(Vars.content.block(this.ore));
            MapGenerateDialog.this.ctile.rotation(this.rotation);
            MapGenerateDialog.this.ctile.setTeam(Team.all[this.team]);
            return MapGenerateDialog.this.ctile;
        }
    }
}

