/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Disposable;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.graphics.IndexedRenderer;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;

public class MapRenderer
implements Disposable {
    private static final int chunkSize = 64;
    private IndexedRenderer[][] chunks;
    private IntSet updates = new IntSet();
    private IntSet delayedUpdates = new IntSet();
    private MapEditor editor;
    private int width;
    private int height;
    private Texture texture;

    public MapRenderer(MapEditor editor) {
        this.editor = editor;
        this.texture = Core.atlas.find("clear-editor").getTexture();
    }

    public void resize(int width, int height) {
        int y;
        int x;
        if (this.chunks != null) {
            for (x = 0; x < this.chunks.length; ++x) {
                for (y = 0; y < this.chunks[0].length; ++y) {
                    this.chunks[x][y].dispose();
                }
            }
        }
        this.chunks = new IndexedRenderer[(int)Math.ceil((float)width / 64.0f)][(int)Math.ceil((float)height / 64.0f)];
        for (x = 0; x < this.chunks.length; ++x) {
            for (y = 0; y < this.chunks[0].length; ++y) {
                this.chunks[x][y] = new IndexedRenderer(8192);
            }
        }
        this.width = width;
        this.height = height;
        this.updateAll();
    }

    public void draw(float tx, float ty, float tw, float th) {
        Draw.flush();
        IntSet.IntSetIterator it = this.updates.iterator();
        while (it.hasNext) {
            int i = it.next();
            int x = i % this.width;
            int y = i / this.width;
            this.render(x, y);
        }
        this.updates.clear();
        this.updates.addAll(this.delayedUpdates);
        this.delayedUpdates.clear();
        if (this.chunks == null) {
            return;
        }
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                IndexedRenderer mesh = this.chunks[x][y];
                if (mesh == null) continue;
                mesh.getTransformMatrix().setToTranslation(tx, ty).scale(tw / (float)(this.width * 8), th / (float)(this.height * 8));
                mesh.setProjectionMatrix(Draw.proj());
                mesh.render(this.texture);
            }
        }
    }

    public void updatePoint(int x, int y) {
        this.updates.add(x + y * this.width);
    }

    public void updateAll() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.render(x, y);
            }
        }
    }

    private void render(int wx, int wy) {
        TextureRegion region;
        int x = wx / 64;
        int y = wy / 64;
        IndexedRenderer mesh = this.chunks[x][y];
        Tile tile = this.editor.tiles()[wx][wy];
        Team team = tile.getTeam();
        Floor floor = tile.floor();
        Block wall = tile.block();
        int idxWall = wx % 64 + wy % 64 * 64;
        int idxDecal = wx % 64 + wy % 64 * 64 + 4096;
        if (wall != Blocks.air && (wall.synthetic() || wall instanceof BlockPart)) {
            TextureRegion textureRegion = region = !Core.atlas.isFound(wall.editorIcon()) ? Core.atlas.find("clear-editor") : wall.editorIcon();
            if (wall.rotate) {
                mesh.draw(idxWall, region, (float)(wx * 8) + wall.offset(), (float)(wy * 8) + wall.offset(), (float)region.getWidth() * Draw.scl, (float)region.getHeight() * Draw.scl, tile.rotation() * 90 - 90);
            } else {
                float width = (float)region.getWidth() * Draw.scl;
                float height = (float)region.getHeight() * Draw.scl;
                mesh.draw(idxWall, region, (float)(wx * 8) + wall.offset() + (8.0f - width) / 2.0f, (float)(wy * 8) + wall.offset() + (8.0f - height) / 2.0f, width, height);
            }
        } else {
            region = floor.editorVariantRegions()[Mathf.randomSeed(idxWall, 0, floor.editorVariantRegions().length - 1)];
            mesh.draw(idxWall, region, wx * 8, wy * 8, 8.0f, 8.0f);
        }
        float offsetX = -(wall.size / 3) * 8;
        float offsetY = -(wall.size / 3) * 8;
        if (wall.update || wall.destructible) {
            mesh.setColor(team.color);
            region = Core.atlas.find("block-border-editor");
        } else if (!wall.synthetic() && wall != Blocks.air) {
            region = !Core.atlas.isFound(wall.editorIcon()) ? Core.atlas.find("clear-editor") : wall.editorIcon();
            offsetX = 4.0f - (float)region.getWidth() / 2.0f * Draw.scl;
            offsetY = 4.0f - (float)region.getHeight() / 2.0f * Draw.scl;
        } else {
            region = wall == Blocks.air && tile.overlay() != null ? tile.overlay().editorVariantRegions()[Mathf.randomSeed(idxWall, 0, tile.overlay().editorVariantRegions().length - 1)] : Core.atlas.find("clear-editor");
        }
        float width = (float)region.getWidth() * Draw.scl;
        float height = (float)region.getHeight() * Draw.scl;
        if (!wall.synthetic() && wall != Blocks.air && !wall.isMultiblock()) {
            offsetX = 0.0f;
            offsetY = 0.0f;
            width = 8.0f;
            height = 8.0f;
        }
        mesh.draw(idxDecal, region, (float)(wx * 8) + offsetX, (float)(wy * 8) + offsetY, width, height);
        mesh.setColor(Color.white);
    }

    @Override
    public void dispose() {
        if (this.chunks == null) {
            return;
        }
        for (int x = 0; x < this.chunks.length; ++x) {
            for (int y = 0; y < this.chunks[0].length; ++y) {
                if (this.chunks[x][y] == null) continue;
                this.chunks[x][y].dispose();
            }
        }
    }
}

