/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.ScissorStack;
import io.anuke.arc.input.GestureDetector;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Bresenham2;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.editor.EditorTool;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.ui.GridImage;

public class MapView
extends Element
implements GestureDetector.GestureListener {
    private MapEditor editor;
    private EditorTool tool = EditorTool.pencil;
    private float offsetx;
    private float offsety;
    private float zoom = 1.0f;
    private boolean grid = false;
    private GridImage image = new GridImage(0, 0);
    private Vector2 vec = new Vector2();
    private Rectangle rect = new Rectangle();
    private Vector2[][] brushPolygons = new Vector2[MapEditor.brushSizes.length][0];
    private boolean drawing;
    private int lastx;
    private int lasty;
    private int startx;
    private int starty;
    private float mousex;
    private float mousey;
    private EditorTool lastTool;

    public MapView(final MapEditor editor) {
        this.editor = editor;
        for (int i = 0; i < MapEditor.brushSizes.length; ++i) {
            float size = MapEditor.brushSizes[i];
            this.brushPolygons[i] = Geometry.pixelCircle(size, (index, x, y) -> Mathf.dst(x, y, index, index) <= index - 0.5f);
        }
        Core.input.getInputProcessors().insert(0, new GestureDetector(20.0f, 0.5f, 2.0f, 0.15f, this));
        this.touchable(Touchable.enabled);
        final Point2 firstTouch = new Point2();
        this.addListener(new InputListener(){

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                MapView.this.mousex = x;
                MapView.this.mousey = y;
                return false;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (pointer != 0) {
                    return false;
                }
                if (!Vars.mobile && button != KeyCode.MOUSE_LEFT && button != KeyCode.MOUSE_MIDDLE) {
                    return true;
                }
                if (button == KeyCode.MOUSE_MIDDLE) {
                    MapView.this.lastTool = MapView.this.tool;
                    MapView.this.tool = EditorTool.zoom;
                }
                MapView.this.mousex = x;
                MapView.this.mousey = y;
                Point2 p = MapView.this.project(x, y);
                MapView.this.lastx = p.x;
                MapView.this.lasty = p.y;
                MapView.this.startx = p.x;
                MapView.this.starty = p.y;
                MapView.this.tool.touched(editor, p.x, p.y);
                firstTouch.set(p);
                if (((MapView)MapView.this).tool.edit) {
                    Vars.ui.editor.resetSaved();
                }
                MapView.this.drawing = true;
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (!Vars.mobile && button != KeyCode.MOUSE_LEFT && button != KeyCode.MOUSE_MIDDLE) {
                    return;
                }
                MapView.this.drawing = false;
                Point2 p = MapView.this.project(x, y);
                if (MapView.this.tool == EditorTool.line) {
                    Vars.ui.editor.resetSaved();
                    MapView.this.tool.touchedLine(editor, MapView.this.startx, MapView.this.starty, p.x, p.y);
                }
                editor.flushOp();
                if (button == KeyCode.MOUSE_MIDDLE && MapView.this.lastTool != null) {
                    MapView.this.tool = MapView.this.lastTool;
                    MapView.this.lastTool = null;
                }
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                MapView.this.mousex = x;
                MapView.this.mousey = y;
                Point2 p = MapView.this.project(x, y);
                if (MapView.this.drawing && ((MapView)MapView.this).tool.draggable && (p.x != MapView.this.lastx || p.y != MapView.this.lasty)) {
                    Vars.ui.editor.resetSaved();
                    Bresenham2.line(MapView.this.lastx, MapView.this.lasty, p.x, p.y, (cx, cy) -> MapView.this.tool.touched(editor, cx, cy));
                }
                if (MapView.this.tool == EditorTool.line && ((MapView)MapView.this).tool.mode == 1) {
                    if (Math.abs(p.x - firstTouch.x) > Math.abs(p.y - firstTouch.y)) {
                        MapView.this.lastx = p.x;
                        MapView.this.lasty = firstTouch.y;
                    } else {
                        MapView.this.lastx = firstTouch.x;
                        MapView.this.lasty = p.y;
                    }
                } else {
                    MapView.this.lastx = p.x;
                    MapView.this.lasty = p.y;
                }
            }
        });
    }

    public EditorTool getTool() {
        return this.tool;
    }

    public void setTool(EditorTool tool) {
        this.tool = tool;
    }

    public boolean isGrid() {
        return this.grid;
    }

    public void setGrid(boolean grid) {
        this.grid = grid;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (Core.scene.getKeyboardFocus() == null || !(Core.scene.getKeyboardFocus() instanceof TextField) && !Core.input.keyDown(KeyCode.CONTROL_LEFT)) {
            float ax = Core.input.axis(Binding.move_x);
            float ay = Core.input.axis(Binding.move_y);
            this.offsetx -= ax * 15.0f / this.zoom;
            this.offsety -= ay * 15.0f / this.zoom;
        }
        if (Core.input.keyTap(KeyCode.SHIFT_LEFT)) {
            this.lastTool = this.tool;
            this.tool = EditorTool.pick;
        }
        if (Core.input.keyRelease(KeyCode.SHIFT_LEFT) && this.lastTool != null) {
            this.tool = this.lastTool;
            this.lastTool = null;
        }
        if (Vars.ui.editor.hasPane()) {
            return;
        }
        this.zoom += Core.input.axis(KeyCode.SCROLL) / 10.0f * this.zoom;
        this.clampZoom();
    }

    private void clampZoom() {
        this.zoom = Mathf.clamp(this.zoom, 0.2f, 20.0f);
    }

    private Point2 project(float x, float y) {
        float ratio = 1.0f / ((float)this.editor.width() / (float)this.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        x = (x - this.getWidth() / 2.0f + sclwidth / 2.0f - this.offsetx * this.zoom) / sclwidth * (float)this.editor.width();
        y = (y - this.getHeight() / 2.0f + sclheight / 2.0f - this.offsety * this.zoom) / sclheight * (float)this.editor.height();
        if (this.editor.drawBlock.size % 2 == 0 && this.tool != EditorTool.eraser) {
            return Tmp.g1.set((int)(x - 0.5f), (int)(y - 0.5f));
        }
        return Tmp.g1.set((int)x, (int)y);
    }

    private Vector2 unproject(int x, int y) {
        float ratio = 1.0f / ((float)this.editor.width() / (float)this.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        float px = (float)x / (float)this.editor.width() * sclwidth + this.offsetx * this.zoom - sclwidth / 2.0f + this.getWidth() / 2.0f;
        float py = (float)y / (float)this.editor.height() * sclheight + this.offsety * this.zoom - sclheight / 2.0f + this.getHeight() / 2.0f;
        return this.vec.set(px, py);
    }

    @Override
    public void draw() {
        float ratio = 1.0f / ((float)this.editor.width() / (float)this.editor.height());
        float size = Math.min(this.width, this.height);
        float sclwidth = size * this.zoom;
        float sclheight = size * this.zoom * ratio;
        float centerx = this.x + this.width / 2.0f + this.offsetx * this.zoom;
        float centery = this.y + this.height / 2.0f + this.offsety * this.zoom;
        this.image.setImageSize(this.editor.width(), this.editor.height());
        if (!ScissorStack.pushScissors(this.rect.set(this.x, this.y, this.width, this.height))) {
            return;
        }
        Draw.color(Pal.remove);
        Lines.stroke(2.0f);
        Lines.rect(centerx - sclwidth / 2.0f - 1.0f, centery - sclheight / 2.0f - 1.0f, sclwidth + 2.0f, sclheight + 2.0f);
        this.editor.renderer().draw(centerx - sclwidth / 2.0f, centery - sclheight / 2.0f, sclwidth, sclheight);
        Draw.reset();
        if (this.grid) {
            Draw.color(Color.gray);
            this.image.setBounds(centerx - sclwidth / 2.0f, centery - sclheight / 2.0f, sclwidth, sclheight);
            this.image.draw();
            Draw.color();
        }
        int index = 0;
        for (int i = 0; i < MapEditor.brushSizes.length; ++i) {
            if (this.editor.brushSize != MapEditor.brushSizes[i]) continue;
            index = i;
            break;
        }
        float scaling = this.zoom * Math.min(this.width, this.height) / (float)this.editor.width();
        Draw.color(Pal.accent);
        Lines.stroke(Scl.scl(2.0f));
        if (!(this.editor.drawBlock.isMultiblock() && this.tool != EditorTool.eraser || this.tool == EditorTool.fill)) {
            if (this.tool == EditorTool.line && this.drawing) {
                Vector2 v1 = this.unproject(this.startx, this.starty).add(this.x, this.y);
                float sx = v1.x;
                float sy = v1.y;
                Vector2 v2 = this.unproject(this.lastx, this.lasty).add(this.x, this.y);
                Lines.poly(this.brushPolygons[index], sx, sy, scaling);
                Lines.poly(this.brushPolygons[index], v2.x, v2.y, scaling);
            }
            if ((this.tool.edit || this.tool == EditorTool.line && !this.drawing) && (!Vars.mobile || this.drawing)) {
                Point2 p = this.project(this.mousex, this.mousey);
                Vector2 v = this.unproject(p.x, p.y).add(this.x, this.y);
                if (this.tool == EditorTool.pencil && this.tool.mode == 1) {
                    Lines.square(v.x + scaling / 2.0f, v.y + scaling / 2.0f, scaling * ((float)this.editor.brushSize + 0.5f));
                } else {
                    Lines.poly(this.brushPolygons[index], v.x, v.y, scaling);
                }
            }
        } else if (!(!this.tool.edit && this.tool != EditorTool.line || Vars.mobile && !this.drawing)) {
            Point2 p = this.project(this.mousex, this.mousey);
            Vector2 v = this.unproject(p.x, p.y).add(this.x, this.y);
            float offset = this.editor.drawBlock.size % 2 == 0 ? scaling / 2.0f : 0.0f;
            Lines.square(v.x + scaling / 2.0f + offset, v.y + scaling / 2.0f + offset, scaling * (float)this.editor.drawBlock.size / 2.0f);
        }
        Draw.color(Pal.accent);
        Lines.stroke(Scl.scl(3.0f));
        Lines.rect(this.x, this.y, this.width, this.height);
        Draw.reset();
        ScissorStack.popScissors();
    }

    private boolean active() {
        return Core.scene.getKeyboardFocus() != null && Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.editor) && Vars.ui.editor.isShown() && this.tool == EditorTool.zoom && Core.scene.hit(Core.input.mouse().x, Core.input.mouse().y, true) == this;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (!this.active()) {
            return false;
        }
        this.offsetx += deltaX / this.zoom;
        this.offsety += deltaY / this.zoom;
        return false;
    }

    @Override
    public boolean zoom(float initialDistance, float distance) {
        if (!this.active()) {
            return false;
        }
        float nzoom = distance - initialDistance;
        this.zoom += nzoom / 10000.0f / Scl.scl(1.0f) * this.zoom;
        this.clampZoom();
        return false;
    }

    @Override
    public boolean pinch(Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
        return false;
    }

    @Override
    public void pinchStop() {
    }
}

