/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.editor;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.editor.MapEditor;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class WaveInfoDialog
extends FloatingDialog {
    private static final int displayed = 20;
    private Array<SpawnGroup> groups = new Array();
    private Table table;
    private Table preview;
    private int start = 0;
    private UnitType lastType = UnitTypes.dagger;
    private float updateTimer;
    private float updatePeriod = 1.0f;

    public WaveInfoDialog(MapEditor editor) {
        super("$waves.title");
        this.shown(this::setup);
        this.hidden(() -> {
            Vars.state.rules.spawns = this.groups;
        });
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                Core.app.post(this::hide);
            }
        });
        this.addCloseButton();
        this.buttons.addButton("$waves.edit", () -> {
            FloatingDialog dialog = new FloatingDialog("$waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.defaults().size(210.0f, 64.0f);
            dialog.cont.addButton("$waves.copy", () -> {
                Vars.ui.showInfoFade("$waves.copied");
                Core.app.setClipboardText(Vars.maps.writeWaves(this.groups));
                dialog.hide();
            }).disabled(b -> this.groups == null);
            dialog.cont.row();
            dialog.cont.addButton("$waves.load", () -> {
                try {
                    this.groups = Vars.maps.readWaves(Core.app.getClipboardText());
                    this.buildGroups();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Vars.ui.showErrorMessage("$waves.invalid");
                }
                dialog.hide();
            }).disabled(b -> Core.app.getClipboardText() == null || Core.app.getClipboardText().isEmpty());
            dialog.cont.row();
            dialog.cont.addButton("$settings.reset", () -> Vars.ui.showConfirm("$confirm", "$settings.clear.confirm", () -> {
                this.groups = JsonIO.copy(Vars.defaultWaves.get());
                this.buildGroups();
                dialog.hide();
            }));
            dialog.show();
        }).size(270.0f, 64.0f);
    }

    void setup() {
        this.groups = JsonIO.copy(Vars.state.rules.spawns.isEmpty() ? Vars.defaultWaves.get() : Vars.state.rules.spawns);
        this.cont.clear();
        this.cont.stack(new Table(Tex.clear, main -> {
            main.pane((Table t) -> {
                this.table = t;
            }).growX().growY().padRight(8.0f).get().setScrollingDisabled(true, false);
            main.row();
            main.addButton("$add", () -> {
                if (this.groups == null) {
                    this.groups = new Array();
                }
                this.groups.add(new SpawnGroup(this.lastType));
                this.buildGroups();
            }).growX().height(70.0f);
        }), new Label("$waves.none"){
            {
                this.visible(() -> WaveInfoDialog.this.groups.isEmpty());
                this.touchable(Touchable.disabled);
                this.setWrap(true);
                this.setAlignment(1, 1);
            }
        }).width(390.0f).growY();
        this.cont.table(Tex.clear, m -> {
            m.add("$waves.preview").color(Color.lightGray).growX().center().get().setAlignment(1, 1);
            m.row();
            m.addButton("-", () -> {}).update((T t) -> {
                if (t.getClickListener().isPressed()) {
                    this.updateTimer += Time.delta();
                    if (this.updateTimer >= this.updatePeriod) {
                        this.start = Math.max(this.start - 1, 0);
                        this.updateTimer = 0.0f;
                        this.updateWaves();
                    }
                }
            }).growX().height(70.0f);
            m.row();
            m.pane((Table t) -> {
                this.preview = t;
            }).grow().get().setScrollingDisabled(true, true);
            m.row();
            m.addButton("+", () -> {}).update((T t) -> {
                if (t.getClickListener().isPressed()) {
                    this.updateTimer += Time.delta();
                    if (this.updateTimer >= this.updatePeriod) {
                        ++this.start;
                        this.updateTimer = 0.0f;
                        this.updateWaves();
                    }
                }
            }).growX().height(70.0f);
        }).growY().width(180.0f).growY();
        this.buildGroups();
    }

    void buildGroups() {
        this.table.clear();
        this.table.top();
        this.table.margin(10.0f);
        if (this.groups != null) {
            for (SpawnGroup group : this.groups) {
                this.table.table(Tex.button, t -> {
                    t.margin(0.0f).defaults().pad(3.0f).padLeft(5.0f).growX().left();
                    t.addButton((Button b) -> {
                        b.left();
                        b.addImage(group.type.iconRegion).size(30.0f).padRight(3.0f);
                        b.add(group.type.localizedName).color(Pal.accent);
                    }, () -> this.showUpdate(group)).pad(-6.0f).padBottom(0.0f);
                    t.row();
                    t.table((Table spawns) -> {
                        spawns.addField("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, text -> {
                            if (Strings.canParsePostiveInt(text)) {
                                group.begin = Strings.parseInt(text) - 1;
                                this.updateWaves();
                            }
                        }).width(100.0f);
                        spawns.add("$waves.to").padLeft(4.0f).padRight(4.0f);
                        spawns.addField(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, text -> {
                            if (Strings.canParsePostiveInt(text)) {
                                group.end = Strings.parseInt(text) - 1;
                                this.updateWaves();
                            } else if (text.isEmpty()) {
                                group.end = Integer.MAX_VALUE;
                                this.updateWaves();
                            }
                        }).width(100.0f).get().setMessageText(Core.bundle.get("waves.never"));
                    });
                    t.row();
                    t.table((Table p) -> {
                        p.add("$waves.every").padRight(4.0f);
                        p.addField(group.spacing + "", TextField.TextFieldFilter.digitsOnly, text -> {
                            if (Strings.canParsePostiveInt(text) && Strings.parseInt(text) > 0) {
                                group.spacing = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(100.0f);
                        p.add("$waves.waves").padLeft(4.0f);
                    });
                    t.row();
                    t.table((Table a) -> {
                        a.addField(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, text -> {
                            if (Strings.canParsePostiveInt(text)) {
                                group.unitAmount = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add(" + ");
                        a.addField(Strings.fixed(Math.max(Mathf.isZero(group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), 2), TextField.TextFieldFilter.floatsOnly, text -> {
                            if (Strings.canParsePositiveFloat(text)) {
                                group.unitScaling = 1.0f / Strings.parseFloat(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add("$waves.perspawn").padLeft(4.0f);
                    });
                    t.row();
                    t.addCheck("$waves.boss", b -> {
                        group.effect = b ? StatusEffects.boss : null;
                    }).padTop(4.0f).update((T b) -> b.setChecked(group.effect == StatusEffects.boss));
                    t.row();
                    t.addButton("$waves.remove", () -> {
                        this.groups.remove(group);
                        this.table.getCell(t).pad(0.0f);
                        t.remove();
                        this.updateWaves();
                    }).growX().pad(-6.0f).padTop(5.0f);
                }).width(340.0f).pad(16.0f);
                this.table.row();
            }
        } else {
            this.table.add("$editor.default");
        }
        this.updateWaves();
    }

    void showUpdate(SpawnGroup group) {
        FloatingDialog dialog = new FloatingDialog("");
        dialog.setFillParent(false);
        int i = 0;
        for (UnitType type : Vars.content.units()) {
            dialog.cont.addButton((Button t) -> {
                t.left();
                t.addImage(type.iconRegion).size(40.0f).padRight(2.0f);
                t.add(type.localizedName);
            }, () -> {
                this.lastType = type;
                group.type = type;
                dialog.hide();
                this.buildGroups();
            }).pad(2.0f).margin(12.0f).fillX();
            if (++i % 3 != 0) continue;
            dialog.cont.row();
        }
        dialog.show();
    }

    void updateWaves() {
        this.preview.clear();
        this.preview.top();
        int i = this.start;
        while (i < 20 + this.start) {
            int wave = i++;
            this.preview.table(Tex.underline, table -> {
                table.add(wave + 1 + "").color(Pal.accent).center().colspan(2).get().setAlignment(1, 1);
                table.row();
                int[] spawned = new int[Vars.content.getBy((ContentType)ContentType.unit).size];
                for (SpawnGroup spawn : this.groups) {
                    short s = spawn.type.id;
                    spawned[s] = spawned[s] + spawn.getUnitsSpawned(wave);
                }
                for (int j = 0; j < spawned.length; ++j) {
                    if (spawned[j] <= 0) continue;
                    UnitType type = (UnitType)Vars.content.getByID(ContentType.unit, j);
                    table.addImage(type.iconRegion).size(30.0f).padRight(4.0f);
                    table.add(spawned[j] + "x").color(Color.lightGray).padRight(6.0f);
                    table.row();
                }
                if (table.getChildren().size == 1) {
                    table.add("$none").color(Pal.remove);
                }
            }).width(110.0f).pad(2.0f);
            this.preview.row();
        }
    }
}

