/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.Events;
import io.anuke.arc.collection.GridBits;
import io.anuke.arc.collection.IntQueue;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.IntPositionConsumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.PropCell;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Tile;

public class Damage {
    private static Rectangle rect = new Rectangle();
    private static Rectangle hitrect = new Rectangle();
    private static Vector2 tr = new Vector2();
    private static GridBits bits = new GridBits(30, 30);
    private static IntQueue propagation = new IntQueue();

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, Color color) {
        int i = 0;
        while ((float)i < Mathf.clamp(power / 20.0f, 0.0f, 6.0f)) {
            int branches = 5 + Mathf.clamp((int)(power / 30.0f), 1, 20);
            Time.run((float)i * 2.0f + Mathf.random(4.0f), () -> Lightning.create(Team.derelict, Pal.power, 3.0f, x, y, Mathf.random(360.0f), branches + Mathf.range(2)));
            ++i;
        }
        i = 0;
        while ((float)i < Mathf.clamp(flammability / 4.0f, 0.0f, 30.0f)) {
            Time.run((float)i / 2.0f, () -> Call.createBullet(Bullets.fireball, x, y, Mathf.random(360.0f)));
            ++i;
        }
        int waves = Mathf.clamp((int)(explosiveness / 4.0f), 0, 30);
        for (int i2 = 0; i2 < waves; ++i2) {
            int f = i2;
            Time.run((float)i2 * 2.0f, () -> {
                Damage.damage(x, y, Mathf.clamp(radius + explosiveness, 0.0f, 50.0f) * (((float)f + 1.0f) / (float)waves), explosiveness / 2.0f);
                Effects.effect(Fx.blockExplosionSmoke, x + Mathf.range(radius), y + Mathf.range(radius));
            });
        }
        if (explosiveness > 15.0f) {
            Effects.effect(Fx.shockwave, x, y);
        }
        if (explosiveness > 30.0f) {
            Effects.effect(Fx.bigShockwave, x, y);
        }
        float shake = Math.min(explosiveness / 4.0f + 3.0f, 9.0f);
        Effects.shake(shake, shake, x, y);
        Effects.effect(Fx.dynamicExplosion, x, y, radius / 8.0f);
    }

    public static void createIncend(float x, float y, float range, int amount) {
        for (int i = 0; i < amount; ++i) {
            float cy;
            float cx = x + Mathf.range(range);
            Tile tile = Vars.world.tileWorld(cx, cy = y + Mathf.range(range));
            if (tile == null) continue;
            Fire.create(tile);
        }
    }

    public static void collideLine(Bullet hitter, Team team, Effects.Effect effect, float x, float y, float angle, float length) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, false);
    }

    public static void collideLine(Bullet hitter, Team team, Effects.Effect effect, float x, float y, float angle, float length, boolean large) {
        tr.trns(angle, length);
        IntPositionConsumer collider = (cx, cy) -> {
            Tile tile = Vars.world.ltile(cx, cy);
            if (tile != null && tile.entity != null && tile.getTeamID() != team.ordinal() && tile.entity.collide(hitter)) {
                tile.entity.collision(hitter);
                hitter.getBulletType().hit(hitter, tile.worldx(), tile.worldy());
            }
        };
        Vars.world.raycastEachWorld(x, y, x + Damage.tr.x, y + Damage.tr.y, (cx, cy) -> {
            collider.accept(cx, cy);
            if (large) {
                for (Point2 p : Geometry.d4) {
                    collider.accept(cx + p.x, cy + p.y);
                }
            }
            return false;
        });
        rect.setPosition(x, y).setSize(Damage.tr.x, Damage.tr.y);
        float x2 = Damage.tr.x + x;
        float y2 = Damage.tr.y + y;
        if (Damage.rect.width < 0.0f) {
            Damage.rect.x += Damage.rect.width;
            Damage.rect.width *= -1.0f;
        }
        if (Damage.rect.height < 0.0f) {
            Damage.rect.y += Damage.rect.height;
            Damage.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        Damage.rect.y -= expand;
        Damage.rect.x -= expand;
        Damage.rect.width += expand * 2.0f;
        Damage.rect.height += expand * 2.0f;
        Consumer<Unit> cons = e -> {
            e.hitbox(hitrect);
            Rectangle other = hitrect;
            other.y -= expand;
            other.x -= expand;
            other.width += expand * 2.0f;
            other.height += expand * 2.0f;
            Vector2 vec = Geometry.raycastRect(x, y, x2, y2, other);
            if (vec != null) {
                Effects.effect(effect, vec.x, vec.y);
                e.collision(hitter, vec.x, vec.y);
                hitter.collision((SolidTrait)e, vec.x, vec.y);
            }
        };
        Units.nearbyEnemies(team, rect, cons);
    }

    public static void damageUnits(Team team, float x, float y, float size, float damage, Predicate<Unit> predicate, Consumer<Unit> acceptor) {
        Consumer<Unit> cons = entity -> {
            if (!predicate.test((Unit)entity)) {
                return;
            }
            entity.hitbox(hitrect);
            if (!hitrect.overlaps(rect)) {
                return;
            }
            entity.damage(damage);
            acceptor.accept((Unit)entity);
        };
        rect.setSize(size * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
    }

    public static void damage(float x, float y, float radius, float damage) {
        Damage.damage(null, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage) {
        Damage.damage(team, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete) {
        Consumer<Unit> cons = entity -> {
            if (entity.getTeam() == team || entity.dst(x, y) > radius) {
                return;
            }
            float amount = Damage.calculateDamage(x, y, entity.x, entity.y, radius, damage);
            entity.damage(amount);
            float dst = tr.set(entity.x - x, entity.y - y).len();
            entity.velocity().add(tr.setLength((1.0f - dst / radius) * 2.0f / entity.mass()));
            if (complete && damage >= 9999999.0f && entity == Vars.player) {
                Events.fire(EventType.Trigger.exclusionDeath);
            }
        };
        rect.setSize(radius * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
        if (!complete) {
            int trad = (int)(radius / 8.0f);
            Tile tile = Vars.world.tileWorld(x, y);
            if (tile != null) {
                Damage.tileDamage(team, tile.x, tile.y, trad, damage);
            }
        } else {
            Damage.completeDamage(team, x, y, radius, damage);
        }
    }

    public static void tileDamage(Team team, int startx, int starty, int radius, float baseDamage) {
        bits.clear();
        propagation.clear();
        int bitOffset = bits.width() / 2;
        propagation.addFirst(PropCell.get((byte)0, (byte)0, (short)baseDamage));
        radius = Math.min(radius, bits.width() / 2);
        while (!propagation.isEmpty()) {
            int prop = propagation.removeLast();
            byte x = PropCell.x(prop);
            byte y = PropCell.y(prop);
            short damage = PropCell.damage(prop);
            int dst = Math.abs(x) + Math.abs(y);
            int scaledDamage = (int)((float)damage * (1.0f - (float)dst / (float)radius));
            bits.set(bitOffset + x, bitOffset + y);
            Tile tile = Vars.world.ltile(startx + x, starty + y);
            if (scaledDamage <= 0 || tile == null) continue;
            if (tile.entity != null && tile.getTeam() != team) {
                int health = (int)tile.entity.health;
                if (tile.entity.health > 0.0f) {
                    tile.entity.damage(scaledDamage);
                    if ((scaledDamage -= health) <= 0) continue;
                }
            }
            for (Point2 p : Geometry.d4) {
                if (bits.get(bitOffset + x + p.x, bitOffset + y + p.y)) continue;
                propagation.addFirst(PropCell.get((byte)(x + p.x), (byte)(y + p.y), (short)scaledDamage));
            }
        }
    }

    private static void completeDamage(Team team, float x, float y, float radius, float damage) {
        int trad = (int)(radius / 8.0f);
        for (int dx = -trad; dx <= trad; ++dx) {
            for (int dy = -trad; dy <= trad; ++dy) {
                Tile tile = Vars.world.tile(Math.round(x / 8.0f) + dx, Math.round(y / 8.0f) + dy);
                if (tile == null || tile.entity == null || team != null && !Vars.state.teams.areEnemies(team, tile.getTeam()) || !(Mathf.dst(dx, dy) <= (float)trad)) continue;
                tile.entity.damage(damage);
            }
        }
    }

    private static float calculateDamage(float x, float y, float tx, float ty, float radius, float damage) {
        float dist = Mathf.dst(x, y, tx, ty);
        float falloff = 0.4f;
        float scaled = Mathf.lerp(1.0f - dist / radius, 1.0f, falloff);
        return damage * scaled;
    }

    class PropCellStruct {
        byte x;
        byte y;
        short damage;

        PropCellStruct() {
        }
    }
}

