/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.entities.traits.ScaleTrait;
import io.anuke.mindustry.entities.type.EffectEntity;

public class Effects {
    private static final EffectContainer container = new EffectContainer();
    private static Array<Effect> effects = new Array();
    private static ScreenshakeProvider shakeProvider;
    private static float shakeFalloff;
    private static EffectProvider provider;

    public static void setEffectProvider(EffectProvider prov) {
        provider = prov;
    }

    public static void setScreenShakeProvider(ScreenshakeProvider provider) {
        shakeProvider = provider;
    }

    public static void renderEffect(int id, Effect render, Color color, float life, float rotation, float x, float y, Object data) {
        container.set(id, color, life, render.lifetime, rotation, x, y, data);
        render.draw.render(container);
    }

    public static Effect getEffect(int id) {
        if (id >= Effects.effects.size || id < 0) {
            throw new IllegalArgumentException("The effect with ID \"" + id + "\" does not exist!");
        }
        return effects.get(id);
    }

    public static Array<Effect> all() {
        return effects;
    }

    public static void effect(Effect effect, float x, float y, float rotation) {
        provider.createEffect(effect, Color.white, x, y, rotation, null);
    }

    public static void effect(Effect effect, float x, float y) {
        Effects.effect(effect, x, y, 0.0f);
    }

    public static void effect(Effect effect, Color color, float x, float y) {
        provider.createEffect(effect, color, x, y, 0.0f, null);
    }

    public static void effect(Effect effect, Position loc) {
        provider.createEffect(effect, Color.white, loc.getX(), loc.getY(), 0.0f, null);
    }

    public static void effect(Effect effect, Color color, float x, float y, float rotation) {
        provider.createEffect(effect, color, x, y, rotation, null);
    }

    public static void effect(Effect effect, Color color, float x, float y, float rotation, Object data) {
        provider.createEffect(effect, color, x, y, rotation, data);
    }

    public static void effect(Effect effect, float x, float y, float rotation, Object data) {
        provider.createEffect(effect, Color.white, x, y, rotation, data);
    }

    public static void setShakeFalloff(float falloff) {
        shakeFalloff = falloff;
    }

    private static void shake(float intensity, float duration) {
        if (shakeProvider == null) {
            throw new RuntimeException("Screenshake provider is null! Set it first.");
        }
        shakeProvider.accept(intensity, duration);
    }

    public static void shake(float intensity, float duration, float x, float y) {
        if (Core.camera == null) {
            return;
        }
        float distance = Core.camera.position.dst(x, y);
        if (distance < 1.0f) {
            distance = 1.0f;
        }
        Effects.shake(Mathf.clamp(1.0f / (distance * distance / shakeFalloff)) * intensity, duration);
    }

    public static void shake(float intensity, float duration, Position loc) {
        Effects.shake(intensity, duration, loc.getX(), loc.getY());
    }

    static {
        shakeFalloff = 10000.0f;
        provider = (effect, color, x, y, rotation, data) -> {
            EffectEntity entity = Pools.obtain(EffectEntity.class, EffectEntity::new);
            entity.effect = effect;
            entity.color = color;
            entity.rotation = rotation;
            entity.data = data;
            entity.set(x, y);
            entity.add();
        };
    }

    public static interface EffectRenderer {
        public void render(EffectContainer var1);
    }

    public static interface EffectProvider {
        public void createEffect(Effect var1, Color var2, float var3, float var4, float var5, Object var6);
    }

    public static class EffectContainer
    implements ScaleTrait {
        public float x;
        public float y;
        public float time;
        public float lifetime;
        public float rotation;
        public Color color;
        public int id;
        public Object data;
        private EffectContainer innerContainer;

        public void set(int id, Color color, float life, float lifetime, float rotation, float x, float y, Object data) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.time = life;
            this.lifetime = lifetime;
            this.id = id;
            this.rotation = rotation;
            this.data = data;
        }

        public void scaled(float lifetime, Consumer<EffectContainer> cons) {
            if (this.innerContainer == null) {
                this.innerContainer = new EffectContainer();
            }
            if (this.time <= lifetime) {
                this.innerContainer.set(this.id, this.color, this.time, lifetime, this.rotation, this.x, this.y, this.data);
                cons.accept(this.innerContainer);
            }
        }

        @Override
        public float fin() {
            return this.time / this.lifetime;
        }
    }

    public static class Effect {
        private static int lastid = 0;
        public final int id = lastid++;
        public final EffectRenderer draw;
        public final float lifetime;
        public float size;

        public Effect(float life, float clipsize, EffectRenderer draw) {
            this.lifetime = life;
            this.draw = draw;
            this.size = clipsize;
            effects.add(this);
        }

        public Effect(float life, EffectRenderer draw) {
            this(life, 28.0f, draw);
        }
    }

    public static interface ScreenshakeProvider {
        public void accept(float var1, float var2);
    }
}

