/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Camera;
import io.anuke.arc.math.geom.QuadTree;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.Entity;

public class EntityGroup<T extends Entity> {
    private final boolean useTree;
    private final int id;
    private final Class<T> type;
    private final Array<T> entityArray = new Array(false, 32);
    private final Array<T> entitiesToRemove = new Array(false, 32);
    private final Array<T> entitiesToAdd = new Array(false, 32);
    private final Array<T> intersectArray = new Array();
    private final Rectangle intersectRect = new Rectangle();
    private IntMap<T> map;
    private QuadTree tree;
    private Consumer<T> removeListener;
    private Consumer<T> addListener;
    private final Rectangle viewport = new Rectangle();
    private int count = 0;

    public EntityGroup(int id, Class<T> type, boolean useTree) {
        this.useTree = useTree;
        this.id = id;
        this.type = type;
        if (useTree) {
            this.tree = new QuadTree(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f));
        }
    }

    public void update() {
        this.updateEvents();
        if (this.useTree()) {
            Vars.collisions.updatePhysics(this);
        }
        for (Entity e : this.all()) {
            e.update();
        }
    }

    public int countInBounds() {
        this.count = 0;
        this.draw(e -> true, e -> ++this.count);
        return this.count;
    }

    public void draw() {
        this.draw(e -> true);
    }

    public void draw(Predicate<T> toDraw) {
        this.draw(toDraw, t -> ((DrawTrait)t).draw());
    }

    public void draw(Predicate<T> toDraw, Consumer<T> cons) {
        Camera cam = Core.camera;
        this.viewport.set(cam.position.x - cam.width / 2.0f, cam.position.y - cam.height / 2.0f, cam.width, cam.height);
        for (Entity e : this.all()) {
            DrawTrait draw;
            if (!(e instanceof DrawTrait) || !toDraw.test(e) || !e.isAdded() || !this.viewport.overlaps((draw = (DrawTrait)e).getX() - draw.drawSize() / 2.0f, draw.getY() - draw.drawSize() / 2.0f, draw.drawSize(), draw.drawSize())) continue;
            cons.accept(e);
        }
    }

    public boolean useTree() {
        return this.useTree;
    }

    public void setRemoveListener(Consumer<T> removeListener) {
        this.removeListener = removeListener;
    }

    public void setAddListener(Consumer<T> addListener) {
        this.addListener = addListener;
    }

    public EntityGroup<T> enableMapping() {
        this.map = new IntMap();
        return this;
    }

    public boolean mappingEnabled() {
        return this.map != null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getID() {
        return this.id;
    }

    public void updateEvents() {
        for (Entity e : this.entitiesToAdd) {
            if (e == null) continue;
            this.entityArray.add(e);
            e.added();
            if (this.map == null) continue;
            this.map.put(e.getID(), e);
        }
        this.entitiesToAdd.clear();
        for (Entity e : this.entitiesToRemove) {
            this.entityArray.removeValue(e, true);
            if (this.map != null) {
                this.map.remove(e.getID());
            }
            e.removed();
        }
        this.entitiesToRemove.clear();
    }

    public T getByID(int id) {
        if (this.map == null) {
            throw new RuntimeException("Mapping is not enabled for group " + id + "!");
        }
        return (T)((Entity)this.map.get(id));
    }

    public void removeByID(int id) {
        if (this.map == null) {
            throw new RuntimeException("Mapping is not enabled for group " + id + "!");
        }
        Entity t = (Entity)this.map.get(id);
        if (t != null) {
            this.remove(t);
        } else {
            for (Entity check : this.entitiesToAdd) {
                if (check.getID() != id) continue;
                this.entitiesToAdd.removeValue(check, true);
                if (this.removeListener == null) break;
                this.removeListener.accept(check);
                break;
            }
        }
    }

    public void intersect(float x, float y, float width, float height, Consumer<? super T> out) {
        if (this.isEmpty()) {
            return;
        }
        this.tree().getIntersect(out, x, y, width, height);
    }

    public Array<T> intersect(float x, float y, float width, float height) {
        this.intersectArray.clear();
        if (this.isEmpty()) {
            return this.intersectArray;
        }
        this.tree().getIntersect(this.intersectArray, this.intersectRect.set(x, y, width, height));
        return this.intersectArray;
    }

    public QuadTree tree() {
        if (!this.useTree) {
            throw new RuntimeException("This group does not support quadtrees! Enable quadtrees when creating it.");
        }
        return this.tree;
    }

    public void resize(float x, float y, float w, float h) {
        if (this.useTree) {
            this.tree = new QuadTree(new Rectangle(x, y, w, h));
        }
    }

    public boolean isEmpty() {
        return this.entityArray.size == 0;
    }

    public int size() {
        return this.entityArray.size;
    }

    public int count(Predicate<T> pred) {
        int count = 0;
        for (int i = 0; i < this.entityArray.size; ++i) {
            if (!pred.test(this.entityArray.get(i))) continue;
            ++count;
        }
        return count;
    }

    public void add(T type) {
        if (type == null) {
            throw new RuntimeException("Cannot add a null entity!");
        }
        if (type.getGroup() != null) {
            return;
        }
        type.setGroup(this);
        this.entitiesToAdd.add(type);
        if (this.mappingEnabled()) {
            this.map.put(type.getID(), type);
        }
        if (this.addListener != null) {
            this.addListener.accept(type);
        }
    }

    public void remove(T type) {
        if (type == null) {
            throw new RuntimeException("Cannot remove a null entity!");
        }
        type.setGroup(null);
        this.entitiesToRemove.add(type);
        if (this.removeListener != null) {
            this.removeListener.accept(type);
        }
    }

    public void clear() {
        for (Entity entity : this.entityArray) {
            entity.removed();
            entity.setGroup(null);
        }
        for (Entity entity : this.entitiesToAdd) {
            entity.setGroup(null);
        }
        for (Entity entity : this.entitiesToRemove) {
            entity.setGroup(null);
        }
        this.entitiesToAdd.clear();
        this.entitiesToRemove.clear();
        this.entityArray.clear();
        if (this.map != null) {
            this.map.clear();
        }
    }

    public T find(Predicate<T> pred) {
        for (int i = 0; i < this.entityArray.size; ++i) {
            if (!pred.test(this.entityArray.get(i))) continue;
            return (T)((Entity)this.entityArray.get(i));
        }
        return null;
    }

    public Array<T> all() {
        return this.entityArray;
    }
}

