/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.entities.traits.TargetTrait;

public class Predict {
    private static Vector2 vec = new Vector2();
    private static Vector2 vresult = new Vector2();

    public static Vector2 intercept(float srcx, float srcy, float dstx, float dsty, float dstvx, float dstvy, float v) {
        float tx = dstx - srcx;
        float ty = dsty - srcy;
        float a = (dstvx /= Time.delta()) * dstvx + (dstvy /= Time.delta()) * dstvy - v * v;
        float b = 2.0f * (dstvx * tx + dstvy * ty);
        float c = tx * tx + ty * ty;
        Vector2 ts = Predict.quad(a, b, c);
        Vector2 sol = vresult.set(dstx, dsty);
        if (ts != null) {
            float t0 = ts.x;
            float t1 = ts.y;
            float t = Math.min(t0, t1);
            if (t < 0.0f) {
                t = Math.max(t0, t1);
            }
            if (t > 0.0f) {
                sol.set(dstx + dstvx * t, dsty + dstvy * t);
            }
        }
        return sol;
    }

    public static Vector2 intercept(TargetTrait src, TargetTrait dst, float v) {
        return Predict.intercept(src.getX(), src.getY(), dst.getX(), dst.getY(), dst.getTargetVelocityX() - src.getTargetVelocityX() / 2.0f, dst.getTargetVelocityY() - src.getTargetVelocityY() / 2.0f, v);
    }

    private static Vector2 quad(float a, float b, float c) {
        Vector2 sol = null;
        if ((double)Math.abs(a) < 1.0E-6) {
            if ((double)Math.abs(b) < 1.0E-6) {
                sol = (double)Math.abs(c) < 1.0E-6 ? vec.set(0.0f, 0.0f) : null;
            } else {
                vec.set(-c / b, -c / b);
            }
        } else {
            float disc = b * b - 4.0f * a * c;
            if (disc >= 0.0f) {
                disc = Mathf.sqrt(disc);
                a = 2.0f * a;
                sol = vec.set((-b - disc) / a, (-b + disc) / a);
            }
        }
        return sol;
    }
}

