/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.gen.Sounds;

public class ArtilleryBulletType
extends BasicBulletType {
    protected Effects.Effect trailEffect = Fx.artilleryTrail;

    public ArtilleryBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
        this.collidesTiles = false;
        this.collides = false;
        this.collidesAir = false;
        this.hitShake = 1.0f;
        this.hitSound = Sounds.explosion;
    }

    @Override
    public void update(Bullet b) {
        super.update(b);
        if (b.timer.get(0, 3.0f + b.fslope() * 2.0f)) {
            Effects.effect(this.trailEffect, this.backColor, b.x, b.y, b.fslope() * 4.0f);
        }
    }

    @Override
    public void draw(Bullet b) {
        float baseScale = 0.7f;
        float scale = baseScale + b.fslope() * (1.0f - baseScale);
        float height = this.bulletHeight * (1.0f - this.bulletShrink + this.bulletShrink * b.fout());
        Draw.color(this.backColor);
        Draw.rect(this.backRegion, b.x, b.y, this.bulletWidth * scale, height * scale, b.rot() - 90.0f);
        Draw.color(this.frontColor);
        Draw.rect(this.frontRegion, b.x, b.y, this.bulletWidth * scale, height * scale, b.rot() - 90.0f);
        Draw.color();
    }
}

