/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.graphics.Pal;

public class BasicBulletType
extends BulletType {
    public Color backColor = Pal.bulletYellowBack;
    public Color frontColor = Pal.bulletYellow;
    public float bulletWidth = 5.0f;
    public float bulletHeight = 7.0f;
    public float bulletShrink = 0.5f;
    public String bulletSprite;
    public TextureRegion backRegion;
    public TextureRegion frontRegion;

    public BasicBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage);
        this.bulletSprite = bulletSprite;
    }

    @Override
    public void load() {
        this.backRegion = Core.atlas.find(this.bulletSprite + "-back");
        this.frontRegion = Core.atlas.find(this.bulletSprite);
    }

    @Override
    public void draw(Bullet b) {
        float height = this.bulletHeight * (1.0f - this.bulletShrink + this.bulletShrink * b.fout());
        Draw.color(this.backColor);
        Draw.rect(this.backRegion, b.x, b.y, this.bulletWidth, height, b.rot() - 90.0f);
        Draw.color(this.frontColor);
        Draw.rect(this.frontRegion, b.x, b.y, this.bulletWidth, height, b.rot() - 90.0f);
        Draw.color();
    }
}

