/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.world.Tile;

public class LiquidBulletType
extends BulletType {
    Liquid liquid;

    public LiquidBulletType(Liquid liquid) {
        super(3.5f, 0.0f);
        this.liquid = liquid;
        this.lifetime = 74.0f;
        this.status = liquid.effect;
        this.statusDuration = 90.0f;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.hitLiquid;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
        this.drag = 0.009f;
        this.knockback = 0.55f;
    }

    @Override
    public float range() {
        return this.speed * this.lifetime / 2.0f;
    }

    @Override
    public void update(Bullet b) {
        Tile tile;
        super.update(b);
        if (this.liquid.canExtinguish() && (tile = Vars.world.tileWorld(b.x, b.y)) != null && Fire.has(tile.x, tile.y)) {
            Fire.extinguish(tile, 100.0f);
            b.remove();
            this.hit(b);
        }
    }

    @Override
    public void draw(Bullet b) {
        Draw.color(this.liquid.color, Color.white, b.fout() / 100.0f);
        Fill.circle(b.x, b.y, 0.5f + b.fout() * 2.5f);
    }

    @Override
    public void hit(Bullet b, float hitx, float hity) {
        Effects.effect(this.hitEffect, this.liquid.color, hitx, hity);
        Puddle.deposit(Vars.world.tileWorld(hitx, hity), this.liquid, 5.0f);
        if (this.liquid.temperature <= 0.5f && this.liquid.flammability < 0.3f) {
            float intensity = 400.0f;
            Fire.extinguish(Vars.world.tileWorld(hitx, hity), intensity);
            for (Point2 p : Geometry.d4) {
                Fire.extinguish(Vars.world.tileWorld(hitx + (float)(p.x * 8), hity + (float)(p.y * 8)), intensity);
            }
        }
    }
}

