/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.bullet;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.blocks.distribution.MassDriver;

public class MassDriverBolt
extends BulletType {
    public MassDriverBolt() {
        super(5.3f, 50.0f);
        this.collidesTiles = false;
        this.lifetime = 200.0f;
        this.despawnEffect = Fx.smeltsmoke;
        this.hitEffect = Fx.hitBulletBig;
        this.drag = 0.005f;
    }

    @Override
    public void draw(Bullet b) {
        float w = 11.0f;
        float h = 13.0f;
        Draw.color(Pal.bulletYellowBack);
        Draw.rect("shell-back", b.x, b.y, w, h, b.rot() + 90.0f);
        Draw.color(Pal.bulletYellow);
        Draw.rect("shell", b.x, b.y, w, h, b.rot() + 90.0f);
        Draw.reset();
    }

    @Override
    public void update(Bullet b) {
        float baseAngle;
        float angleTo;
        if (!(b.getData() instanceof MassDriver.DriverBulletData)) {
            this.hit(b);
            return;
        }
        float hitDst = 7.0f;
        MassDriver.DriverBulletData data = (MassDriver.DriverBulletData)b.getData();
        if (data.to.isDead()) {
            return;
        }
        float baseDst = data.from.dst(data.to);
        float dst1 = b.dst(data.from);
        float dst2 = b.dst(data.to);
        boolean intersect = false;
        if (dst1 > baseDst && Angles.near(angleTo = b.angleTo(data.to), baseAngle = data.to.angleTo(data.from), 2.0f)) {
            intersect = true;
            b.set(data.to.x + Angles.trnsx(baseAngle, hitDst), data.to.y + Angles.trnsy(baseAngle, hitDst));
        }
        if (Math.abs(dst1 + dst2 - baseDst) < 4.0f && dst2 <= hitDst) {
            intersect = true;
        }
        if (intersect) {
            data.to.handlePayload(b, data);
        }
    }

    @Override
    public void despawned(Bullet b) {
        super.despawned(b);
        if (!(b.getData() instanceof MassDriver.DriverBulletData)) {
            return;
        }
        MassDriver.DriverBulletData data = (MassDriver.DriverBulletData)b.getData();
        for (int i = 0; i < data.items.length; ++i) {
            int amountDropped = Mathf.random(0, data.items[i]);
            if (amountDropped <= 0) continue;
            float angle = b.rot() + Mathf.range(100.0f);
            Effects.effect(Fx.dropItem, Color.white, b.x, b.y, angle, Vars.content.item(i));
        }
    }

    @Override
    public void hit(Bullet b, float hitx, float hity) {
        super.hit(b, hitx, hity);
        this.despawned(b);
    }
}

